/* $Id: mat_region-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_region-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_region.h"

int main(int argc, char ** argv) {
    
    mat_region *dst = NULL;                                    
    mat_region *src = NULL;                                    
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    src=mat_region_new(1,2,0,0,10,10);
    cpl_test(src != NULL);
    cpl_test(mat_region_set_name(src,(char *)"foo",1)==CPL_ERROR_NONE);
    cpl_test(mat_region_set_area(src,1,1,10,10)==CPL_ERROR_NONE);
    dst=mat_region_copy(dst,src,2);
    cpl_test(dst != NULL);
    cpl_test(mat_region_delete(dst) == CPL_ERROR_NONE);
    dst=mat_region_duplicate(src,2);
    cpl_test(dst != NULL);
    cpl_test(mat_region_delete(dst) == CPL_ERROR_NONE);
    cpl_test(mat_region_delete(src) == CPL_ERROR_NONE);

    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
