/* $Id: mat_shiftmap-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_shiftmap-test.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
/* #include "../mat_shiftmap_save.h" */
#include "../mat_shift.h"
#include "../mat_imagingdetector.h"
/* #include "../mat_apply_shift.h" */

int main(int argc, char ** argv) {
    int i=0;
    int j=0;

    mat_shiftmap *shift=NULL;
    cpl_frameset *frames=NULL;
    cpl_frameset *sel_frames=NULL;
    cpl_frame *dummyframe=NULL;
    cpl_frame *dummyframedup=NULL;
    cpl_propertylist *pheader=NULL;
    cpl_parameterlist *parlist=NULL;
    char output[]="shiftmap-save.fits";
    mat_gendata *gendata=NULL;
    mat_gendata *gendatacorr=NULL;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    shift=cpl_malloc(sizeof(mat_shiftmap));
    shift->keywords=cpl_propertylist_new();
    cpl_propertylist_append_int(shift->keywords,"ESO TPL NEXP",2);
    cpl_propertylist_append_string(shift->keywords,"ESO DET CHIP NAME","AQUARIUS");
    cpl_propertylist_append_string(shift->keywords,"ESO INS DIN POS","'LOW'");
    shift->imgdet=cpl_malloc(sizeof(mat_imagingdetector));
    shift->imgdet->nbregion=5;
    shift->imgdet->nbtel=1;
    shift->imgdet->nbdetector=1;
    shift->imgdet->instrument=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(shift->imgdet->instrument,"foo");
    //shift->imgdet->origin=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(shift->imgdet->origin,"foo");
    shift->imgdet->dateobsmjd=0.;
    shift->imgdet->dateobs=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(shift->imgdet->dateobs,"foo");
    //shift->imgdet->date=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(shift->imgdet->date,"foo");
    shift->imgdet->dcsdictionaryid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(shift->imgdet->dcsdictionaryid,"foo");
    shift->imgdet->dcsid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(shift->imgdet->dcsid,"foo");
    
    shift->imgdet->list_region=cpl_malloc(shift->imgdet->nbregion*
					  sizeof(mat_region *));
    for(i=0;i<5;i++) {
	shift->imgdet->list_region[i]=cpl_malloc(sizeof(mat_region));
	shift->imgdet->list_region[i]->naxis[0]=10;
	shift->imgdet->list_region[i]->naxis[1]=10;
	shift->imgdet->list_region[i]->numdetector=1;
	shift->imgdet->list_region[i]->numregion=i+1;
	shift->imgdet->list_region[i]->regionname=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(shift->imgdet->list_region[i]->regionname,"foo");
	shift->imgdet->list_region[i]->numbeam=cpl_calloc(1,sizeof(int));
	shift->imgdet->list_region[i]->numbeam[0]=1;
	shift->imgdet->list_region[i]->correlation=1;
	shift->imgdet->list_region[i]->gain=1.;
	shift->imgdet->list_region[i]->crval[0]=1.;
	shift->imgdet->list_region[i]->crval[1]=1.;
	shift->imgdet->list_region[i]->crpix[0]=1.;
	shift->imgdet->list_region[i]->crpix[1]=1.;
	shift->imgdet->list_region[i]->corner[0]=1;
	shift->imgdet->list_region[i]->corner[1]=1;
	shift->imgdet->list_region[i]->ctype[0]=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(shift->imgdet->list_region[i]->ctype[0],"foo");
	shift->imgdet->list_region[i]->ctype[1]=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(shift->imgdet->list_region[i]->ctype[1],"foo");
    }
    shift->nbreg=5;
    shift->list_shiftcoefx=cpl_malloc(shift->nbreg*sizeof(mat_shiftcoef *));
    shift->list_shiftcoefy=cpl_malloc(shift->nbreg*sizeof(mat_shiftcoef *));

    for(i=0;i<shift->nbreg;i++) {
	shift->list_shiftcoefx[i]=cpl_malloc(sizeof(mat_shiftcoef));
	shift->list_shiftcoefx[i]->order=3;
	shift->list_shiftcoefx[i]->numdetector=1;
	shift->list_shiftcoefx[i]->numregion=1;
	shift->list_shiftcoefx[i]->nlig=10;
	shift->list_shiftcoefx[i]->coefdistor=cpl_matrix_new(
	    shift->list_shiftcoefx[i]->order,shift->list_shiftcoefx[i]->nlig);
	for(j=0; j<shift->list_shiftcoefx[i]->nlig; j++) {
	    cpl_matrix_set(shift->list_shiftcoefx[i]->coefdistor, 0, j, 0);
	    cpl_matrix_set(shift->list_shiftcoefx[i]->coefdistor, 1, j, 1);
	    cpl_matrix_set(shift->list_shiftcoefx[i]->coefdistor, 2, j, 0);
	}
	shift->list_shiftcoefx[i]->errdistor=cpl_matrix_new(
	    shift->list_shiftcoefx[i]->order,shift->list_shiftcoefx[i]->nlig);
	shift->list_shiftcoefy[i]=cpl_malloc(sizeof(mat_shiftcoef));
	shift->list_shiftcoefy[i]->order=3;
	shift->list_shiftcoefy[i]->numdetector=1;
	shift->list_shiftcoefy[i]->numregion=1;
	shift->list_shiftcoefy[i]->nlig=10;
	shift->list_shiftcoefy[i]->coefdistor=cpl_matrix_new(
	    shift->list_shiftcoefy[i]->order,shift->list_shiftcoefy[i]->nlig);
	for(j=0; j<shift->list_shiftcoefy[i]->nlig; j++) {
	    cpl_matrix_set(shift->list_shiftcoefy[i]->coefdistor, 0, j, 0);
	    cpl_matrix_set(shift->list_shiftcoefy[i]->coefdistor, 1, j, 1);
	    cpl_matrix_set(shift->list_shiftcoefy[i]->coefdistor, 2, j, 0);
      }
	shift->list_shiftcoefy[i]->errdistor=cpl_matrix_new(
	    shift->list_shiftcoefy[i]->order,shift->list_shiftcoefy[i]->nlig);
    }
    shift->dispcoef[0]=0.;
    shift->dispcoef[1]=0.;
    shift->dispcoef[2]=0.;
    shift->dispcoef[3]=0.;
    shift->dispcoef[4]=0.;
    shift->errdispcoef[0]=0.;
    shift->errdispcoef[1]=0.;
    shift->errdispcoef[2]=0.;
    shift->errdispcoef[3]=0.;
    shift->errdispcoef[4]=0.;


    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_01.fits", MAT_TESTDATADIR);
    frames=cpl_frameset_new();
    sel_frames=cpl_frameset_new();
    dummyframe=cpl_frame_new();
    cpl_frame_set_filename(dummyframe,filename);
    cpl_free(filename);
    cpl_frame_set_group(dummyframe,CPL_FRAME_GROUP_RAW);
    cpl_frame_set_tag(dummyframe,"DARK");
    cpl_frameset_insert(frames,dummyframe);
    dummyframedup=cpl_frame_duplicate(dummyframe);
    cpl_frameset_insert(sel_frames,dummyframedup);
    pheader=cpl_propertylist_new();
    cpl_propertylist_append_int(pheader,"ESO SHIFT_MAP UNIT TEST",1);
    //cpl_propertylist_append_string(pheader,"ORIGIN ","foo");
    //cpl_test(cpl_propertylist_has(pheader,"ORIGIN "));
    //cpl_propertylist_append_string(pheader,"DATE","foo");
    //cpl_test(cpl_propertylist_has(pheader,"DATE"));
    cpl_propertylist_append_string(pheader,"EXTNAME","SHIFT_MAP");
    cpl_propertylist_append_int(pheader,"NREGION",5);
    parlist=cpl_parameterlist_new();
    cpl_test(mat_shiftmap_save(shift,pheader,frames,sel_frames,parlist,
			       "DUMMY","SHIFT_MAP","IMAGE","F",
			       output) == CPL_ERROR_NONE);
    cpl_parameterlist_delete(parlist);
    cpl_propertylist_delete(pheader);
    cpl_frameset_delete(frames);
    cpl_frameset_delete(sel_frames);
    mat_imagingdetector_save(shift->imgdet, NULL, output);
    cpl_test(mat_shiftmap_free(shift)==CPL_ERROR_NONE);


    dummyframe=cpl_frame_new();
    cpl_frame_set_filename(dummyframe,"shiftmap-save.fits");
    cpl_frame_set_group(dummyframe,CPL_FRAME_GROUP_RAW);
    cpl_frame_set_tag(dummyframe,"SHIFT_MAP");
    shift=mat_shiftmap_load(dummyframe);
    cpl_test(shift!=NULL);
    cpl_frame_delete(dummyframe);
// create mat_gendata for testing mat_apply_shift
    gendata=cpl_malloc(sizeof(mat_gendata));
    gendata->keywords=cpl_propertylist_new();
    cpl_propertylist_append_string(gendata->keywords,"ESO DET CHIP NAME","AQUARIUS");
    cpl_propertylist_append_string(gendata->keywords,"ESO INS DIN POS","LOW");
    gendata->array=NULL;
    gendata->imgdet=cpl_malloc(sizeof(mat_imagingdetector));
    gendata->imgdet->nbregion=1;
    gendata->imgdet->nbtel=1;
    gendata->imgdet->nbdetector=1;
    gendata->imgdet->instrument=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdet->instrument,"foo");
    //gendata->imgdet->origin=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(gendata->imgdet->origin,"foo");
    gendata->imgdet->dateobsmjd=0.;
    gendata->imgdet->dateobs=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdet->dateobs,"foo");
    //gendata->imgdet->date=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(gendata->imgdet->date,"foo");
    gendata->imgdet->dcsdictionaryid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdet->dcsdictionaryid,"foo");
    gendata->imgdet->dcsid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdet->dcsid,"foo");
    gendata->imgdet->list_region=cpl_malloc(gendata->imgdet->nbregion*
					  sizeof(mat_region *));
    for(i=0;i<gendata->imgdet->nbregion;i++) {
	gendata->imgdet->list_region[i]=cpl_malloc(sizeof(mat_region));
	gendata->imgdet->list_region[i]->naxis[0]=10;
	gendata->imgdet->list_region[i]->naxis[1]=10;
	gendata->imgdet->list_region[i]->numdetector=1;
	gendata->imgdet->list_region[i]->numregion=i+1;
	gendata->imgdet->list_region[i]->regionname=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(gendata->imgdet->list_region[i]->regionname,"foo");
	gendata->imgdet->list_region[i]->numbeam=cpl_calloc(1,sizeof(int));
	gendata->imgdet->list_region[i]->numbeam[0]=1;
	gendata->imgdet->list_region[i]->correlation=2;
	gendata->imgdet->list_region[i]->gain=1.;
	gendata->imgdet->list_region[i]->crval[0]=1.;
	gendata->imgdet->list_region[i]->crval[1]=1.;
	gendata->imgdet->list_region[i]->crpix[0]=1.;
	gendata->imgdet->list_region[i]->crpix[1]=1.;
	gendata->imgdet->list_region[i]->corner[0]=1;
	gendata->imgdet->list_region[i]->corner[1]=1;
	gendata->imgdet->list_region[i]->ctype[0]=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(gendata->imgdet->list_region[i]->ctype[0],"foo");
	gendata->imgdet->list_region[i]->ctype[1]=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
	strcpy(gendata->imgdet->list_region[i]->ctype[1],"foo");
    }
   
    gendata->imgdata=cpl_malloc(sizeof(mat_imagingdata));
    gendata->imgdata->nbframe=1;
    gendata->imgdata->nbtel=1;
    gendata->imgdata->instrument=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdata->instrument,"foo");
    //gendata->imgdata->origin=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(gendata->imgdata->origin,"foo");
    gendata->imgdata->dateobsmjd=0.;
    gendata->imgdata->dateobs=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdata->dateobs,"foo");
    //gendata->imgdata->date=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    //strcpy(gendata->imgdata->date,"foo");
    gendata->imgdata->dcsdictionaryid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdata->dcsdictionaryid,"foo");
    gendata->imgdata->dcsid=cpl_calloc(SIZE_MAX_KEYWORDS,sizeof(char));
    strcpy(gendata->imgdata->dcsid,"foo");
    gendata->imgdata->list_frame=cpl_malloc(gendata->imgdata->nbframe*
					  sizeof(mat_frame *));
    for(i=0;i<gendata->imgdata->nbframe;i++) {
	gendata->imgdata->list_frame[i]=cpl_calloc(1,sizeof(mat_frame));
	gendata->imgdata->list_frame[i]->time=0.;
	gendata->imgdata->list_frame[i]->exptime=0.;
	gendata->imgdata->list_frame[i]->nbsubwin=1;
	gendata->imgdata->list_frame[i]->list_subwin=cpl_malloc(
	    gendata->imgdata->list_frame[i]->nbsubwin*sizeof(mat_imgreg *));
	for(j=0;j<gendata->imgdata->list_frame[i]->nbsubwin;j++) {
	    gendata->imgdata->list_frame[i]->list_subwin[j]=cpl_malloc(
		sizeof(mat_imgreg));
	    gendata->imgdata->list_frame[i]->list_subwin[j]->nbimgreg=1;
	    gendata->imgdata->list_frame[i]->list_subwin[j]->imgreg=cpl_malloc(
		gendata->imgdata->list_frame[i]->list_subwin[j]->nbimgreg*
		sizeof(cpl_image *));
	    gendata->imgdata->list_frame[i]->list_subwin[j]->imgreg[0]=
		cpl_image_new(gendata->imgdet->list_region[0]->naxis[0],
			      gendata->imgdet->list_region[0]->naxis[1],
			      CPL_TYPE_DOUBLE);
	    cpl_image_fill_noise_uniform(
		gendata->imgdata->list_frame[i]->list_subwin[j]->imgreg[0],
		0,10.);
	}
    }
    
    gendatacorr=mat_apply_shift(gendata,shift,0);
    cpl_test(gendatacorr!=NULL);
    mat_gendata_delete(gendata);
    mat_gendata_delete(gendatacorr);
    mat_shiftmap_free(shift);
 
    remove("shiftmap-save.fits");

// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

