/* $Id: mat_utils-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_utils-test.c $
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include "../mat_utils.h"

int main(int argc, char ** argv) {
    int ier=0;
    int i=0;
    cpl_propertylist *plist=NULL;
    cpl_vector *vecy=NULL;
    cpl_vector *vecw=NULL;
    cpl_vector *fit=NULL;
    mat_oivis2 *oivis2=NULL;
    mat_oivis *oivis=NULL;
    mat_oit3 *oit3=NULL;
    char *str=NULL;
    (void) argc;
    (void) argv;

    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

// mat_round unit tests
    cpl_test(fabs(mat_round(12.3456,2)-12.35) < 1.E-8);
    cpl_test(fabs(mat_round(12.3456,-3)-0.) < 1.E-8);

// mat_get_nexp unit tests
    plist=cpl_propertylist_new();
    cpl_test(mat_get_nexp(plist)==-1);
    cpl_propertylist_append_int(plist,"ESO TPL NEXP",2);
    cpl_test(mat_get_nexp(plist)==2);
    cpl_propertylist_delete(plist);

// mat_combinaison unit tests
    cpl_test(mat_combinaison(1,0)==-1);
    cpl_test(mat_combinaison(1,2)==-1);
    cpl_test(mat_combinaison(1,1)==1);
    cpl_test(mat_combinaison(1,-1)==1);
    cpl_test(mat_combinaison(2,1)==2);

// mat_poly_fit unit tests
    cpl_test(mat_polyfit_1d(vecy,vecw,1,fit,0)==-1);
    vecy=cpl_vector_new(10);
    vecw=cpl_vector_new(10);
    fit=cpl_vector_new(5);
    cpl_test(mat_polyfit_1d(vecy,vecw,1,fit,0)==-1);
    cpl_vector_delete(fit);
    fit=cpl_vector_new(10);
    cpl_vector_fill(vecy,1.);
    cpl_vector_fill(vecw,1.);
    ier=mat_polyfit_1d(vecy,vecw,0,fit,0);
    cpl_test(ier==0);
    cpl_test(fit!=NULL);
    cpl_test(cpl_vector_get(fit,1)==1.0);
    cpl_vector_delete(fit);
    cpl_vector_delete(vecy);
    cpl_vector_delete(vecw);

// mat_get_nbtel_from_oivis2 unit tests
    cpl_test(mat_get_nbtel_from_oivis2(oivis2)==-1);
    oivis2=cpl_malloc(sizeof(mat_oivis2));
    oivis2->nbvis2=0;
    cpl_test(mat_get_nbtel_from_oivis2(oivis2)==-1);
    oivis2->nbvis2=1;
    oivis2->list_vis2=cpl_malloc(oivis2->nbvis2*sizeof(mat_vis2elem *));
    oivis2->list_vis2[0]=cpl_malloc(sizeof(mat_vis2elem));
    oivis2->list_vis2[i]->stationindex[0]=1;
    oivis2->list_vis2[i]->stationindex[1]=2;
    cpl_test(mat_get_nbtel_from_oivis2(oivis2)==2);
    cpl_free(oivis2->list_vis2[0]);
    cpl_free(oivis2->list_vis2);
    cpl_free(oivis2);

// mat_get_nbtel_from_oivis unit tests
    cpl_test(mat_get_nbtel_from_oivis(oivis)==-1);
    oivis=cpl_malloc(sizeof(mat_oivis));
    oivis->nbvis=0;
    cpl_test(mat_get_nbtel_from_oivis(oivis)==-1);
    oivis->nbvis=1;
    oivis->list_vis=cpl_malloc(oivis->nbvis*sizeof(mat_viselem *));
    oivis->list_vis[0]=cpl_malloc(sizeof(mat_viselem));
    oivis->list_vis[i]->stationindex[0]=1;
    oivis->list_vis[i]->stationindex[1]=2;
    cpl_test(mat_get_nbtel_from_oivis(oivis)==2);
    cpl_free(oivis->list_vis[0]);
    cpl_free(oivis->list_vis);
    cpl_free(oivis);

// mat_get_nbtel_from_oit3 unit tests
    cpl_test(mat_get_nbtel_from_oit3(oit3)==-1);
    oit3=cpl_malloc(sizeof(mat_oit3));
    oit3->nbt3=0;
    cpl_test(mat_get_nbtel_from_oit3(oit3)==-1);
    oit3->nbt3=1;
    oit3->list_t3=cpl_malloc(oit3->nbt3*sizeof(mat_t3elem *));
    oit3->list_t3[0]=cpl_calloc(1,sizeof(mat_t3elem));
    oit3->list_t3[i]->stationindex[0]=1;
    oit3->list_t3[i]->stationindex[1]=2;
    oit3->list_t3[i]->stationindex[1]=3;
    cpl_test(mat_get_nbtel_from_oit3(oit3)==3);
    cpl_free(oit3->list_t3[0]);
    cpl_free(oit3->list_t3);
    cpl_free(oit3);

// mat_propertylist_get_string and mat_propertylist_copy_string unit tests
    plist=cpl_propertylist_new();
    cpl_propertylist_append_string(plist,"ESO FOO","foo");
    str=mat_propertylist_copy_string(plist,"ESO FOO");
    cpl_test(strstr(str,"foo")!=NULL);
    cpl_free(str);
    cpl_propertylist_delete(plist);

// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

