/* $Id: mat_cal_cphase.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_cal_cphase.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/
#include <cpl.h>
#include "mat_drl.h"
#include "mat_cal_cphase_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_cal_cphase"



/* Plugin detailed description */
static const char *
mat_cal_cphase_help = "This plugin calibrates the phase closure.\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    TARGET_RAW_INT         Science OIFITS              Yes \n"
  "    CALIB_RAW_INT          Calibrator OIFITS           Yes \n"
  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    CAL_CPHASE             OIFITS with OI_T3 binary table\n";
static int mat_cal_cphase_create(cpl_plugin *);
static int mat_cal_cphase_exec(cpl_plugin *);
static int mat_cal_cphase_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_cal_cphase",
                     "Calibration of the phase closure",
                     mat_cal_cphase_help,
                     "Philippe Berio",
                     PACKAGE_BUGREPORT,
                     "GPL",
                     mat_cal_cphase_create,
                     mat_cal_cphase_exec,
                     mat_cal_cphase_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_cal_cphase_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    recipe->parameters = cpl_parameterlist_new();
    return 0;
}
static int mat_cal_cphase_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    return 0;
}


static int mat_cal_cphase_exec(cpl_plugin *plugin)
{
  cpl_recipe *recipe = (cpl_recipe *)plugin;
  if (mat_cal_cphase_lib(recipe->parameters,recipe->frames,RECIPE_NAME)) 
    {
	cpl_msg_warning(cpl_func,"Error in mat_cal_cphase_lib");
	return CPL_ERROR_ILLEGAL_OUTPUT;
    }
 
  return 0;
}

