/* $Id: mat_cal_vis.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_cal_vis.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/

#include <cpl.h>
#include "mat_drl.h"
#include "mat_cal_vis_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_cal_vis"



/* Plugin detailed description */
static const char *
mat_cal_vis_help = "This plugin calibrates the squared visibility. It interpolates the transfer function from several calibrators (CALIB_RAW_INT).\n"
"Then it divides the raw squared  visibility by the interpolated transfer function.\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    TARGET_RAW_INT         Science OIFITS              Yes \n"
  "    CALIB_RAW_INT          Calibrator OIFITS           Yes \n"
  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    CAL_VIS2               OIFITS with OI_VIS2 binary table\n"
  "    INTERP_TF2             interpolated transfer function\n"
;
static int mat_cal_vis_create(cpl_plugin *);
static int mat_cal_vis_exec(cpl_plugin *);
static int mat_cal_vis_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_cal_vis",
                     "Calibration of the squared visibility",
                     mat_cal_vis_help,
                     "Philippe Berio",
                     PACKAGE_BUGREPORT,
                     "GPL",
                     mat_cal_vis_create,
                     mat_cal_vis_exec,
                     mat_cal_vis_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_cal_vis_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameter *p1, *p2;
    recipe->parameters = cpl_parameterlist_new();


    p2 = cpl_parameter_new_value("matisse.mat_cal_vis.tfKeep",
				CPL_TYPE_INT, 
				"store interpolate function (=1)", 
				"matisse.mat_cal_vis",
				0,0,1);
    cpl_parameter_set_alias(p2, CPL_PARAMETER_MODE_CLI, "tfKeep") ;
    cpl_parameterlist_append(recipe->parameters, p2) ;

    p1 = cpl_parameter_new_value("matisse.mat_cal_vis.tfInterp",
    				CPL_TYPE_INT,
    				"transfer function interpolation method (0: average, 2:linear function)",
    				"matisse.mat_cal_vis",
				0,0,2);
    cpl_parameter_set_alias(p1, CPL_PARAMETER_MODE_CLI, "tfInterp") ;
    cpl_parameterlist_append(recipe->parameters, p1) ;


    cpl_msg_info("mat_cal_vis_create", "Parameters created.");

    return 0;
}
static int mat_cal_vis_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    return 0;
}






static int mat_cal_vis_exec(cpl_plugin *plugin)
{
 
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    if (cpl_plugin_get_type(plugin) == CPL_PLUGIN_TYPE_RECIPE) {
	recipe=(cpl_recipe *)plugin;
    } else {
	return -1;
    }
    if (mat_cal_vis_lib(recipe->parameters,recipe->frames,RECIPE_NAME)) 
    {
	cpl_msg_warning(cpl_func,"Error in mat_cal_vis_lib");
	return CPL_ERROR_ILLEGAL_OUTPUT;
    }
 
  return 0;
}


