/* $Id: mat_est_tf.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_est_tf.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/
#include <cpl.h>
#include "mat_drl.h"
#include "mat_est_tf_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_est_tf"



/* Plugin detailed description */
static const char *
mat_est_tf_help = 
    "This plugin estimates the Transfer Function from one or several \n"
    "RAW_VIS2 FITS files corresponding to observations of calibrator stars. \n"
    "The angular diameter (and its error) of the calibators should be known. \n"
    "The user can provide them using the parameters diamStar and diamErr. \n"
    "In this case, the same angular diameter is used for all RAW_VIS2 files \n"
    "provided in the sof file. If the catalog parameter is used, the \n"
    "diameter and its error are retrieved from the JSDC catalog. In this case, \n"
    "RAW_VIS2 files corresponding to different calibrators could be provided \n"
    "in the sof file. The recipes creates a RAW_TF2 FITS file containing the \n"
    "transfer function for each RAW_VIS2 file given as input.\n\n"
    "The following QC1 parameters are calculated:\n"
    "   - QC DET<i> TFSQR<m>: the vaerage transfer function from the \n"
    "     squared raw visibility.\n"
    "where i=detector number (1=L/M band, 2=N band) and m=baselien number (1..6)\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    RAW_VIS2               VIS2 (Calibrator)           Yes \n"
  "    RAW_DPHASE             VIS (Calibrator)            Optional \n"
  "    JSDC_CAT               JSDC Catalog                Yes \n"
  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    RAW_TF2                transfer function\n"
;
static int mat_est_tf_create(cpl_plugin *);
static int mat_est_tf_exec(cpl_plugin *);
static int mat_est_tf_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_est_tf",
                     "Estimation of the Transfer Function",
                     mat_est_tf_help,
                     "Philippe Berio",
                     PACKAGE_BUGREPORT,
                     "GPL",
                     mat_est_tf_create,
                     mat_est_tf_exec,
                     mat_est_tf_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_est_tf_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe;
    /* cpl_parameter *p1, *p2, *p3; */

    /* Check that the plugin is part of a valid recipe */
    if (cpl_plugin_get_type(plugin) == CPL_PLUGIN_TYPE_RECIPE)
      recipe = (cpl_recipe *)plugin;
    else
      return -1;

    /* Create the parameters list in the cpl_recipe object */
    recipe->parameters = cpl_parameterlist_new();
    /* Fill the parameters list */

    /* p3 = cpl_parameter_new_range("matisse.mat_est_tf.catalog", */
    /* 				CPL_TYPE_INT, */
    /* 				"calibrator catalog", */
    /* 				"matisse.mat_est_tf", */
    /* 				 1,0,1); */

    /* cpl_parameter_set_alias(p3, CPL_PARAMETER_MODE_CLI, "catalog"); */
    /* cpl_parameterlist_append(recipe->parameters, p3); */

    /* /\* --diameter *\/ */
    /* p1 = cpl_parameter_new_range("matisse.mat_est_tf.diamStar", */
    /* 				CPL_TYPE_DOUBLE, */
    /* 				"calibrator angular diameter", */
    /* 				"matisse.mat_est_tf", */
    /* 				1.0,0.0001,10.0); */
    /* cpl_parameter_set_alias(p1, CPL_PARAMETER_MODE_CLI, "diamStar"); */
    /* cpl_parameterlist_append(recipe->parameters, p1); */
    
    /* /\* --diameter error *\/ */
    /* p2 = cpl_parameter_new_range("matisse.mat_est_tf.diamErr", */
    /* 				CPL_TYPE_DOUBLE, */
    /* 				"calibrator angular diameter error", */
    /* 				"matisse.mat_est_tf", */
    /* 				0.01, 0.00001, 10.0); */
    /* cpl_parameter_set_alias(p2, CPL_PARAMETER_MODE_CLI, "diamErr"); */
    /* cpl_parameterlist_append(recipe->parameters, p2); */
    return 0;
}


static int mat_est_tf_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    return 0;
}


static int mat_est_tf_exec(cpl_plugin *plugin)
{
  cpl_recipe *recipe = (cpl_recipe *)plugin;
   
  if (mat_est_tf_lib(recipe->parameters,recipe->frames,RECIPE_NAME)) {
    cpl_msg_error(cpl_func,"Error in mat_est_tf_lib");
    return CPL_ERROR_ILLEGAL_OUTPUT;
  }
  return 0;
}

