/* $Id: mat_merge_results.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_merge_results.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/
#include <cpl.h>
#include "mat_drl.h"
#include "mat_merge_results_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_merge_results"



/* Plugin detailed description */
static const char *
mat_merge_results_help = "This plugin merges the intermediate results (RAW_VIS2, RAW_CPHASE, RAW_CPHASE, RAW_SPECTRUM, RAW_TF2.\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    RAW_VIS2               raw OI_VIS2                 No \n"
  "    RAW_CPHASE             raw OI_T3                   No \n"
  "    RAW_DPHASE             raw OI_VIS                  No \n"
  "    RAW_SPECTRUM           OI_FLUX                     No \n"
  "    RAW_TF2                Transfer function           No \n"
  "    CAL_VIS2               calibrated OI_VIS2          No \n"
  "    CAL_CPHASE             calibrated OI_T3            No \n"
  "    CAL_DPHASE             calibarted OI_VIS           No \n"
  "    TARGET_RAW_INT         raw OIFITS                  No \n"

  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    TARGET_CAL_INT         Calibrated OIFITS\n"
  "    TARGET_RAW_INT         Raw OIFITS (Target)\n"
  "    CALIB_RAW_INT          Raw OIFITS (Calibrator)\n";
static int mat_merge_results_create(cpl_plugin *);
static int mat_merge_results_exec(cpl_plugin *);
static int mat_merge_results_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_merge_results",
                     "Merge intermediate results",
                     mat_merge_results_help,
                     "Philippe Berio",
                     PACKAGE_BUGREPORT,
                     "GPL",
                     mat_merge_results_create,
                     mat_merge_results_exec,
                     mat_merge_results_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_merge_results_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameter *p,*p1;

    recipe->parameters = cpl_parameterlist_new();
    p = cpl_parameter_new_value("matisse.mat_merge_results.cumulBlock",
				CPL_TYPE_BOOL, "cumul all blocks of an OB", 
				"matisse.mat_merge_results",FALSE);
    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI, "cumulBlock") ;
    cpl_parameterlist_append(recipe->parameters, p) ; 
    p1 = cpl_parameter_new_value("matisse.mat_merge_results.bcdMode",
				CPL_TYPE_INT, "Select frames with \n CHOP \"FALSE\" and BCD OUT-OUT"
						" (0) or with BCD IN-IN (1) or with "
						"BCD IN-OUT (2) or with BCD OUT-IN (3) \n or \n"
						" CHOP \"TRUE\" and BCD OUT-OUT (4) or with BCD "
						"IN-IN (5) or with BCD IN-OUT (6) or with "
						"BCD OUT-IN (7)",
				"matisse.mat_merge_results",0);
    cpl_parameter_set_alias(p1, CPL_PARAMETER_MODE_CLI, "bcdMode") ;
    cpl_parameterlist_append(recipe->parameters, p1) ; 
    cpl_msg_info("mat_merge_results_create", "Parameters created.");
    return 0;
}
static int mat_merge_results_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    return 0;
}


static int mat_merge_results_exec(cpl_plugin *plugin)
{
  cpl_recipe *recipe = (cpl_recipe *)plugin;
  if (mat_merge_results_lib(recipe->frames,recipe->parameters,RECIPE_NAME,NULL)) {
    cpl_msg_warning(cpl_func,"Error in mat_merge_results_lib");
    return CPL_ERROR_ILLEGAL_OUTPUT;
  }
  return 0;
}

