/* $Id: mat_proc_coher.c,v0.5 2014-06-15 12:56:21 fmillour Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fmillour $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_proc_coher.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/
#include <cpl.h>
#include "mat_drl.h"
#include "mat_proc_coher_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_proc_coher"



/* Plugin detailed description */
static const char *mat_proc_coher_help = "This plugin runs the coherent processing."
  " It computes the raw differential phase and visibility.\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    OBJ_CORR_FLUX          Correlated Flux             Yes \n"
  "    PHOT_BEAMS             Photometric Beam            No (corrFlux parameter)\n"
  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    RAW_DPHASE             raw differential phase and visibility\n";
static int mat_proc_coher_create(cpl_plugin *);
static int mat_proc_coher_exec(cpl_plugin *);
static int mat_proc_coher_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_proc_coher",
                     "Coherent processing",
                     mat_proc_coher_help,
                     "Florentin Millour",
                     "fmillour@oca.eu",
                     "GPL",
                     mat_proc_coher_create,
                     mat_proc_coher_exec,
                     mat_proc_coher_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_proc_coher_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    recipe->parameters = cpl_parameterlist_new();
    cpl_parameter *p;
    
    p = cpl_parameter_new_value("matisse.mat_proc_coher.coherentAlgo",
				CPL_TYPE_INT,
				"Estimation Algorithm (1: AMBER like Method, 2: CRAL Cohrent Integration Method)",
				"matisse.mat_proc_coher",
				2, 1, 2);
    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI, "coherentAlgo");
    cpl_parameterlist_append(recipe->parameters, p);

    cpl_msg_info("mat_raw_estimates_create", "Parameters created.");

    return 0;
}
static int mat_proc_coher_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    //cpl_memory_dump();
    return 0;
}


/*----------------------------------------------------------------------------*/
/**
   @brief Execute the plugin instance given by the interface. This plugin
   calculates the average differential phase from all selected frames.
   @param plugin the plugin
   @return 0 if everything is ok
*/
/*----------------------------------------------------------------------------*/

static int mat_proc_coher_exec(cpl_plugin *plugin)
{
  cpl_recipe *recipe = (cpl_recipe *)plugin;

  if (mat_proc_coher_lib(recipe->frames,recipe->parameters,RECIPE_NAME)) {
    cpl_msg_warning(cpl_func,"Error in mat_proc_coher_lib");
    return CPL_ERROR_ILLEGAL_OUTPUT;
  }
  
  return 0;
}

