#!/usr/bin/python
# -*- coding: utf-8 -*-

# newclass.py
from __future__ import absolute_import
from astropy.io import fits
import string
from reflex import *
import json
import numpy as np
import sys
import wx
import matplotlib as mp
from pylab import *
from matplotlib.figure import Figure
from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg as FigureCanvas
import readFits
from os import walk
import wx.lib.scrolledpanel

class FrameRawEstimate(wx.Frame):

    def __init__(self, *args, **kwds):    
        for key,value in kwds.items():
            if key == 'file':
                self.objcorrflux_in=value['corrflux']
                self.objphot_in=value['phot']
                self.objopd_in=value['opd']
        del kwds['file']

        self.target=''
        self.mode=''
        self.detector=''
        self.resolution=''
        self.spectralfilter=''
        self.polarizer=''
        self.spatialfilter=''
        self.dit=''

        self.interferogram=[]
        self.cub=[]
        self.dico=[]
        self.exponumCorrFlux=[]
        self.exponumPhot=[]
        self.exponumOpd=[]
        for i in range(0,len(self.objcorrflux_in)):
            hdulist=fits.open(self.objcorrflux_in[i])
            prihdr=hdulist[0].header
            self.exponumCorrFlux.append(str(prihdr['HIERARCH ESO TPL EXPNO']))
            if (i == 0):
                if ('HIERARCH ESO TARGET NAME' in prihdr):
                    self.target=prihdr['HIERARCH ESO TARGET NAME']
                else :
                    self.target='laboratory data'
                self.detector=prihdr['HIERARCH ESO DET CHIP NAME']
                self.dit=prihdr['HIERARCH ESO DET SEQ1 DIT']
                pil=prihdr['HIERARCH ESO INS PIL ID']
                pin=prihdr['HIERARCH ESO INS PIN ID']
                if (pil == 'PHOTO' and pin == 'PHOTO') :
                    self.mode='SIPHOT'
                if (pil == 'PHOTO' and pin == 'INTER') :
                    self.mode='HYBRID'
                if (pil == 'INTER' and pin == 'INTER') :
                    self.mode='HIGHSENS'
                if (self.detector == 'HAWAII-2RG'):
                    self.resolution=prihdr['HIERARCH ESO INS DIL ID']
                    self.spectralfilter=prihdr['HIERARCH ESO INS FIL ID']
                    self.polarizer=prihdr['HIERARCH ESO INS POL ID']
                    self.spatialfilter=prihdr['HIERARCH ESO INS SFL ID']
                else:
                    self.resolution=prihdr['HIERARCH ESO INS DIN ID']
                    self.spectralfilter=prihdr['HIERARCH ESO INS FIN ID']
                    self.polarizer=prihdr['HIERARCH ESO INS PON ID']
                    self.spatialfilter=prihdr['HIERARCH ESO INS SFN ID']
                        
                     
                
            hdulist.close()


          
        for i in range(0,len(self.objphot_in)):
            hdulist=fits.open(self.objphot_in[i])
            prihdr=hdulist[0].header
            self.exponumPhot.append(str(prihdr['HIERARCH ESO TPL EXPNO']))
            hdulist.close()
        for i in range(0,len(self.objopd_in)):
            hdulist=fits.open(self.objopd_in[i])
            prihdr=hdulist[0].header
            self.exponumOpd.append(str(prihdr['HIERARCH ESO TPL EXPNO']))
            hdulist.close()

        if len(self.objphot_in) > 0 :
            fitsFileName=self.objphot_in[0]
            hdulist=fits.open(fitsFileName)
            prihdr=hdulist[0].header
            hdulist.close()
            chipName=prihdr['HIERARCH ESO DET CHIP NAME']
            dico = readFits.readFile(fitsFileName)
            self.wavelength = dico['lambda']
            self.lambda_inf = min(self.wavelength)
            self.lambda_max = max(self.wavelength)
            self.lambda_mean = sum(self.wavelength) / float(len(self.wavelength))
            self.lambda_mid = (self.lambda_max-self.lambda_inf)/2+self.lambda_inf
            if chipName == 'AQUARIUS':
                self.lambda_lim_inf=8.
                self.lambda_lim_sup=13.0
            else:
                self.lambda_lim_inf=2.8
                self.lambda_lim_sup=5.0

            
            del dico

        self.InitUI(*args, **kwds)
        if len(self.objphot_in) == 0 :
            self.Destroy()
       #self.Maximize()
        self.Centre()
        self.Show()     

    def InitUI(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)
      
        #panel = wx.Panel(self,size=(200,200))
        panel = wx.lib.scrolledpanel.ScrolledPanel(self, -1, size=(400, 200))        
        panel.SetupScrolling()
        sizer = wx.GridBagSizer(5, 5)


    # CONFIGURATION ZONE
        text1 = wx.StaticText(panel, label="Configuration")
        font = wx.Font(16, wx.DECORATIVE, wx.NORMAL, wx.BOLD)
        text1.SetFont(font) 
        sizer.Add(text1, pos=(0, 0), flag=wx.TOP|wx.LEFT|wx.BOTTOM, 
            border=15)
        
#        icon = wx.StaticBitmap(panel, bitmap=wx.Bitmap('logo2.PNG'))
#        sizer.Add(icon, pos=(0, 5), 
#                  flag=wx.TOP|wx.RIGHT|wx.ALIGN_RIGHT, 
#                  border=5)
        
        gridBox=wx.GridSizer(1,6,10,10)
        str0=' '
        str1='TARGET : '+self.target+'\nMODE : '+self.mode+'\nDETECTOR : '+self.detector+'\nDIT : '+str(self.dit)+'s'
        str2='SPECTRAL RESOLUTION : '+self.resolution+'\nPOLARIZER : '+self.polarizer+'\nSPATIAL FILTER : '+self.spatialfilter
        textConf0 = wx.StaticText(panel, -1 , str0)
        font = wx.Font(8, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        textConf0.SetFont(font) 
        gridBox.Add(textConf0,0, 
                    flag=wx.EXPAND)
        textConf1 = wx.StaticText(panel, -1 , str1)
        font = wx.Font(8, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        textConf1.SetFont(font) 
        gridBox.Add(textConf1,0, 
                    flag=wx.EXPAND)
        textConf2 = wx.StaticText(panel, -1 , str2)
        textConf2.SetFont(font) 
        gridBox.Add(textConf2,0, 
                  flag=wx.EXPAND)
        sizer.Add(gridBox,pos=(0,1),span=(1,4),
                  flag=wx.EXPAND, 
                  border=20)


        line = wx.StaticLine(panel)
        sizer.Add(line, pos=(2, 0), span=(1, 5), flag=wx.EXPAND|wx.BOTTOM, border=10)

    # PHOTOMETRY ZONE
        text2 = wx.StaticText(panel, label="Photometry")
        font = wx.Font(16, wx.DECORATIVE, wx.NORMAL, wx.BOLD)
        text2.SetFont(font) 
        sizer.Add(text2, pos=(3, 0), flag=wx.LEFT, border=10)

        vboxPhot = wx.BoxSizer(wx.VERTICAL)
        textExpoPhot = wx.StaticText(panel, label="Select Exposure")
        font = wx.Font(6, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        textExpoPhot.SetFont(font) 
        vboxPhot.Add(textExpoPhot,0,wx.CENTER)
        self.lstBoxPhot = wx.ListBox(panel, size=(70,-1) , choices = self.exponumPhot, style = wx.LB_SINGLE)
        vboxPhot.Add(self.lstBoxPhot,0,wx.CENTER)
        sizer.Add(vboxPhot, pos=(4, 0), flag=wx.EXPAND, border=20)
  
        self.vboxFigPhot = wx.GridSizer(1,3,10,10)
        self.figPhot=Figure(figsize=(4,2))
        if ( (self.detector == 'HAWAII-2RG' and (self.mode == 'SIPHOT' or self.mode == 'HYBRID')) or (self.detector == 'HAWAII-2RGAQUARIUS' and self.mode == 'SIPHOT') ):
            self.figPhot.suptitle('Temporal Evolution of Photometry', fontsize=10)
        self.figPhot.set_facecolor('white')
        self.canvasPhot=FigureCanvas(panel,-1,self.figPhot)
        self.vboxFigPhot.Add(self.canvasPhot,0,wx.EXPAND|wx.CENTER)

        self.figSpec=Figure(figsize=(4,2))
        self.figSpec.set_facecolor('white')
        self.figSpec.suptitle('Raw Spectrum', fontsize=10)
        self.canvasSpec=FigureCanvas(panel,-1,self.figSpec)
        self.vboxFigPhot.Add(self.canvasSpec,0,wx.EXPAND|wx.CENTER)

        if ( (self.detector == 'HAWAII-2RG' and (self.mode == 'SIPHOT' or self.mode == 'HYBRID')) or (self.detector == 'HAWAII-2RGAQUARIUS' and self.mode == 'SIPHOT') ):
            boxPhot=wx.BoxSizer(wx.VERTICAL)
            self.sliderPhotWave = wx.Slider(panel, -1, int(len(self.wavelength)/2), 0, len(self.wavelength), size=(200,60))
            self.buttonPhotWave = wx.CheckBox(panel, id=-1, label='Mean Wavelength')
            
            aux =  "Wavelength : %.2f" % self.lambda_mid
            self.labelPhotWave =  wx.StaticText(panel, -1, aux)
            font = wx.Font(8, wx.NORMAL, wx.NORMAL, wx.NORMAL)
            self.labelPhotWave.SetFont(font) 
            
            boxPhot.Add(self.labelPhotWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
            boxPhot.Add(self.sliderPhotWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
            boxPhot.Add(self.buttonPhotWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
            self.vboxFigPhot.Add(boxPhot,0,wx.EXPAND|wx.CENTER)

        sizer.Add(self.vboxFigPhot, pos=(3, 1), span=(2,4),
                      flag=wx.EXPAND, border=0)

    # FRINGES ZONE
        line = wx.StaticLine(panel)
        sizer.Add(line, pos=(5, 0), span=(1, 5), 
            flag=wx.EXPAND|wx.BOTTOM, border=10)

        text3 = wx.StaticText(panel, label="Fringes")
        font = wx.Font(16, wx.DECORATIVE, wx.NORMAL, wx.BOLD)
        text3.SetFont(font) 
        sizer.Add(text3, pos=(6, 0), flag=wx.LEFT, border=10)

        vboxFrin = wx.BoxSizer(wx.VERTICAL)
        textExpoFrin = wx.StaticText(panel, label="Select Exposure")
        font = wx.Font(6, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        textExpoFrin.SetFont(font) 
        vboxFrin.Add(textExpoFrin,0,wx.CENTER)
        self.lstBoxFrin = wx.ListBox(panel, size=(70,-1) , choices = self.exponumCorrFlux, style = wx.LB_SINGLE)
        vboxFrin.Add(self.lstBoxFrin,0,wx.CENTER)
        sizer.Add(vboxFrin, pos=(7, 0), flag=wx.EXPAND, border=20)
  
        self.vboxFigFrin = wx.GridSizer(1,3,10,10)
        self.figFrin=Figure(figsize=(4,2))
        self.figFrin.suptitle('Interferogram', fontsize=10)
        self.figFrin.set_facecolor('white')
        self.canvasFrin=FigureCanvas(panel,-1,self.figFrin)
        self.vboxFigFrin.Add(self.canvasFrin,0,wx.EXPAND|wx.CENTER)

        self.figDsp=Figure(figsize=(4,2))
        self.figDsp.suptitle('Power Spectrum', fontsize=10)
        self.figDsp.set_facecolor('white')
        self.canvasDsp=FigureCanvas(panel,-1,self.figDsp)
        self.vboxFigFrin.Add(self.canvasDsp,0,wx.EXPAND|wx.CENTER)

        boxFrin=wx.BoxSizer(wx.VERTICAL)
        self.sliderFrinWave = wx.Slider(panel, -1, 1, 0, 100, size=(200,60))
        self.buttonFrinWave = wx.CheckBox(panel, id=-1, label='Average')

        aux =  "Frame Number : %d" % 1
        self.labelFrinWave =  wx.StaticText(panel, -1, aux)
        font = wx.Font(8, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        self.labelFrinWave.SetFont(font) 

        boxFrin.Add(self.labelFrinWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
        boxFrin.Add(self.sliderFrinWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
        boxFrin.Add(self.buttonFrinWave, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
        self.vboxFigFrin.Add(boxFrin,0,wx.EXPAND|wx.CENTER)

        sizer.Add(self.vboxFigFrin, pos=(6, 1), span=(2,4),
                  flag=wx.EXPAND, border=0)

    # OPD ZONE
        line = wx.StaticLine(panel)
        sizer.Add(line, pos=(8, 0), span=(1, 5), 
            flag=wx.EXPAND|wx.BOTTOM, border=10)

        text4 = wx.StaticText(panel, label="OPD")
        font = wx.Font(16, wx.DECORATIVE, wx.NORMAL, wx.BOLD)
        text4.SetFont(font) 
        sizer.Add(text4, pos=(9, 0), flag=wx.LEFT, border=10)

        vboxOpd = wx.BoxSizer(wx.VERTICAL)
        textExpoOpd = wx.StaticText(panel, label="Select Exposure")
        font = wx.Font(6, wx.NORMAL, wx.NORMAL, wx.NORMAL)
        textExpoOpd.SetFont(font) 
        vboxOpd.Add(textExpoOpd,0,wx.CENTER)
        self.lstBoxOpd = wx.ListBox(panel, size=(70,-1) , choices = self.exponumOpd, style = wx.LB_SINGLE)
        vboxOpd.Add(self.lstBoxOpd,0,wx.CENTER)
        sizer.Add(vboxOpd, pos=(10, 0), flag=wx.EXPAND, border=20)
  
        vboxFigOpd = wx.GridSizer(2,3,10,10)
        self.figOpd1=Figure(figsize=(4,1))
        self.figOpd1.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd1.set_facecolor('white')
        self.canvasOpd1=FigureCanvas(panel,-1,self.figOpd1)
        vboxFigOpd.Add(self.canvasOpd1,0,wx.EXPAND|wx.CENTER)

        self.figOpd2=Figure(figsize=(4,1))
        self.figOpd2.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd2.set_facecolor('white')
        self.canvasOpd2=FigureCanvas(panel,-1,self.figOpd2)
        vboxFigOpd.Add(self.canvasOpd2,0,wx.EXPAND|wx.CENTER)
 
        self.figOpd3=Figure(figsize=(4,1))
        self.figOpd3.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd3.set_facecolor('white')
        self.canvasOpd3=FigureCanvas(panel,-1,self.figOpd3)
        vboxFigOpd.Add(self.canvasOpd3,0,wx.EXPAND|wx.CENTER)

        self.figOpd4=Figure(figsize=(4,1))
        self.figOpd4.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd4.set_facecolor('white')
        self.canvasOpd4=FigureCanvas(panel,-1,self.figOpd4)
        vboxFigOpd.Add(self.canvasOpd4,0,wx.EXPAND|wx.CENTER)

        self.figOpd5=Figure(figsize=(4,1))
        self.figOpd5.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd5.set_facecolor('white')
        self.canvasOpd5=FigureCanvas(panel,-1,self.figOpd5)
        vboxFigOpd.Add(self.canvasOpd5,0,wx.EXPAND|wx.CENTER)

        self.figOpd6=Figure(figsize=(4,1))
        self.figOpd6.suptitle('Temporal Evolution of OPD (baseline 1)', fontsize=10)
        self.figOpd6.set_facecolor('white')
        self.canvasOpd6=FigureCanvas(panel,-1,self.figOpd6)
        vboxFigOpd.Add(self.canvasOpd6,0,wx.EXPAND|wx.CENTER)

        sizer.Add(vboxFigOpd, pos=(9, 1), span=(9,4),
                  flag=wx.EXPAND, border=0)
    # BOTTOM BUTTONS
        line = wx.StaticLine(panel)
        sizer.Add(line, pos=(19, 0), span=(1, 5), 
            flag=wx.EXPAND|wx.BOTTOM, border=10)

        hboxButton = wx.BoxSizer(wx.HORIZONTAL)
        buttonCont = wx.Button(panel, label="Continue")
        #buttonQuit = wx.Button(panel, label="Quit")
        hboxButton.Add(buttonCont,0,wx.CENTER)
        #hboxButton.Add(buttonQuit,0,wx.CENTER)
        sizer.Add(hboxButton, pos=(20, 4),   
                  flag=wx.CENTER, border=5)

        sizer.AddGrowableCol(2)
        
        panel.SetSizer(sizer)

        self.lstBoxPhot.Bind(wx.EVT_LISTBOX, self.exposurePhotClick)
        self.lstBoxFrin.Bind(wx.EVT_LISTBOX, self.exposureFrinClick)
        self.lstBoxOpd.Bind(wx.EVT_LISTBOX, self.exposureOpdClick)
        buttonCont.Bind(wx.EVT_BUTTON, self.buttonContClick)
        #buttonQuit.Bind(wx.EVT_BUTTON, self.buttonQuitClick)
        if ( (self.detector == 'HAWAII-2RG' and (self.mode == 'SIPHOT' or self.mode == 'HYBRID')) or (self.detector == 'HAWAII-2RGAQUARIUS' and self.mode == 'SIPHOT') ):
            self.buttonPhotWave.Bind(wx.EVT_CHECKBOX, self.buttonPhotWaveClick)
            self.sliderPhotWave.Bind(wx.EVT_SCROLL, self.OnSliderPhotWaveScroll)
        self.buttonFrinWave.Bind(wx.EVT_CHECKBOX, self.buttonFrinWaveClick)
        self.sliderFrinWave.Bind(wx.EVT_SCROLL, self.OnSliderFrinWaveScroll)

    def exposurePhotClick(self, event):
        self.OnPhot(event)

    def exposureFrinClick(self, event):
        self.OnFringe(event)

    def exposureOpdClick(self, event):
        self.OnOpd(event)

    def buttonContClick(self,event):
        self.figPhot.clf()
        self.figSpec.clf()
        self.figFrin.clf()
        self.figDsp.clf()
        self.figOpd1.clf()
        self.figOpd2.clf()
        self.figOpd3.clf()
        self.figOpd4.clf()
        self.figOpd5.clf()
        self.figOpd6.clf()
        self.Close()
        if hasattr(self,'interferogram') :
            del self.interferogram
        if hasattr(self,'cub') :
            del self.cub
        if hasattr(self,'dico') :
            del self.dico
        event.Skip()

#    def buttonQuitClick(self,event):
#        if hasattr(self,'interferogram') :
#            del self.interferogram
#        if hasattr(self,'cub') :
#            del self.cub
#        if hasattr(self,'dico') :
#            del self.dico
#        self.Destroy()


    def OnOpd(self,event):
        str=self.lstBoxOpd.GetStringSelection()
        if (str == ''):
            nexpSelected=0
        else:
            nexpSelected=int(str)
        index=-1
        for i in range(0,len(self.objopd_in)):
            hdulist=fits.open(self.objopd_in[i])
            prihdr=hdulist[0].header
            if (nexpSelected == prihdr['HIERARCH ESO TPL EXPNO']):
                index=i
            hdulist.close()
        fitsFileName=self.objopd_in[index]
        f = fits.open(fitsFileName) 
        self.drawOpd(fitsFileName)
        self.Layout()

    def OnFringe(self,event):
        str=self.lstBoxFrin.GetStringSelection()
        if (str == ''):
            nexpSelected=0
        else:
            nexpSelected=int(str)
        index=-1
        for i in range(0,len(self.objcorrflux_in)):
            hdulist=fits.open(self.objcorrflux_in[i])
            prihdr=hdulist[0].header
            if (nexpSelected == prihdr['HIERARCH ESO TPL EXPNO']):
                index=i
            hdulist.close()
        fitsFileName=self.objcorrflux_in[index]
        f = fits.open(fitsFileName) 
        prihdr=f[f.index_of('OBJ_CORR_FLUX')].header
        f.close()
        self.frameNumber=prihdr['NAXIS2']
        self.sliderFrinWave.SetMax(int(self.frameNumber / 10));
        self.drawFringe(fitsFileName)
        self.Layout()

    def OnPhot(self,event):
        if hasattr(self,'dico') :
            del self.dico

        str=self.lstBoxPhot.GetStringSelection()
        if (str == ''):
            nexpSelected=0
        else:
            nexpSelected=int(str)
        index=-1
        for i in range(0,len(self.objphot_in)):
            hdulist=fits.open(self.objphot_in[i])
            prihdr=hdulist[0].header
            if (nexpSelected == prihdr['HIERARCH ESO TPL EXPNO']):
                index=i
            hdulist.close()
        fitsFileName=self.objphot_in[index]
        self.dico = readFits.readFile(fitsFileName)

        if ( (self.detector == 'HAWAII-2RG' and (self.mode == 'SIPHOT' or self.mode == 'HYBRID')) or (self.detector == 'HAWAII-2RGAQUARIUS' and self.mode == 'SIPHOT') ):
            indexVal=int(self.sliderPhotWave.GetValue())
            val=self.wavelength[indexVal]
            self.drawPhot(val)

        self.drawSpec()
        self.Layout()

    def buttonPhotWaveClick(self,event):
        indexVal=len(self.wavelength)/2
        val=self.wavelength[indexVal]
        aux = "Wavelength : %.2f" % val
        self.labelPhotWave.SetLabel(aux)
        self.sliderPhotWave.SetValue(indexVal)
        self.drawPhot('mean')

    def OnSliderPhotWaveScroll(self, event):        
        obj = event.GetEventObject()
        val = obj.GetValue()
        self.buttonPhotWave.SetValue(False)
        aux = "Wavelength : %.2f" % self.wavelength[val]
        self.labelPhotWave.SetLabel(aux)
        self.drawPhot(self.wavelength[val])

    def drawPhot(self, method):   
        self.figPhot.clf()
        if method == 'mean':
            self.indice_lambda = readFits.readIndiceMean(self.dico['lambda'],sum(self.dico['lambda']) / float(len(self.dico['lambda'])))
        else:
            self.indice_lambda = readFits.readIndiceMean(self.dico['lambda'], method)


        X = np.array(range(len(self.dico['phot'][0])))

        self.axes=self.figPhot.add_subplot(111)
        self.axes.set_xlabel('Frame Number')
        self.axes.xaxis.label.set_fontsize(8)
        self.axes.set_title('Temporal Evolution of Photometry')
        self.axes.title.set_fontsize(10)
        for item in (self.axes.get_xticklabels() + self.axes.get_yticklabels()):
            item.set_fontsize(6)        

        aux = []
        for i in range(0, len(self.dico['phot'][0])): 
            aux.append(self.dico['phot'][0][i][self.indice_lambda])
        Y1 = np.array(aux, np.float32)
        aux = []
        for i in range(0, len(self.dico['phot'][1])): 
            aux.append(self.dico['phot'][1][i][self.indice_lambda])
        Y2 = np.array(aux, np.float32)
        aux = []
        for i in range(0, len(self.dico['phot'][2])): 
            aux.append(self.dico['phot'][2][i][self.indice_lambda])
        Y3 = np.array(aux, np.float32)
        aux = []
        for i in range(0, len(self.dico['phot'][3])): 
            aux.append(self.dico['phot'][3][i][self.indice_lambda])
        Y4 = np.array(aux, np.float32)
  
        val=np.max([Y1,Y2,Y3,Y4])
        expo=int(np.log10(val))
        Y1*=10**(-expo)
        Y2*=10**(-expo)
        Y3*=10**(-expo)
        Y4*=10**(-expo)
        aux = "Flux (x1E%d)" % expo
        self.axes.set_ylabel(aux)
        self.axes.yaxis.label.set_fontsize(8)

        self.im = self.axes.plot(X, Y1, 'b', label='Beam 1')
        self.im = self.axes.plot(X, Y2,'g', label='Beam 2')
        self.im = self.axes.plot(X, Y3,'r', label='Beam 3')
        self.im = self.axes.plot(X, Y4,'m', label='Beam 4')
        valmin=np.min([Y1,Y2,Y3,Y4])
        if (valmin < 0):
            valmin*=1.5
        else:
            valmin/=4.
        self.axes.set_ylim(valmin,np.max([Y1,Y2,Y3,Y4])*1.2)
        self.figPhot.tight_layout()
        self.axes.legend(loc='lower right',prop={'size':6})   
        self.canvasPhot.draw()


    def drawSpec(self):   
        self.figSpec.clf()
  
        X = self.wavelength
        Y1 = np.array(self.dico['spectrum'][0], np.float32)
        Y2 = np.array(self.dico['spectrum'][1], np.float32)            
        Y3 = np.array(self.dico['spectrum'][2], np.float32)
        Y4 = np.array(self.dico['spectrum'][3], np.float32)
        val=np.max([Y1,Y2,Y3,Y4])
        expo=int(np.log10(val))
        Y1*=10**(-expo)
        Y2*=10**(-expo)
        Y3*=10**(-expo)
        Y4*=10**(-expo)

        self.axes=self.figSpec.add_subplot(111)
        self.axes.set_xlabel('Wavelength')
        self.axes.xaxis.label.set_fontsize(8)
        aux = "Flux (x1E%d)" % expo
        self.axes.set_ylabel(aux)
        self.axes.yaxis.label.set_fontsize(8)
        self.axes.set_title('Raw Spectrum')
        self.axes.title.set_fontsize(10)
        for item in (self.axes.get_xticklabels() + self.axes.get_yticklabels()):
            item.set_fontsize(6)        
        l1 = self.axes.plot(X, Y1, 'b', label='Beam 1')
        l2 = self.axes.plot(X, Y2,'g', label='Beam 2')
        l3 = self.axes.plot(X, Y3,'r', label='Beam 3')
        l4 = self.axes.plot(X, Y4,'m', label='Beam 4')
        self.figSpec.tight_layout()
        self.axes.set_xlim(self.lambda_lim_inf,self.lambda_lim_sup)
        self.axes.legend(loc='upper right',prop={'size':6})   
        self.canvasSpec.draw()  

    def drawOpd(self,fitsFileName):
        f = fits.open(fitsFileName) 
        oiopd=f[f.index_of('OPD')].data
        self.opd=oiopd.field('OPD')
        del oiopd
        f.close()
        self.plotOpd()

    def drawFringe(self,fitsFileName):
        if hasattr(self,'interferogram') :
            del self.interferogram
            del self.cub
        f = fits.open(fitsFileName) 
        corrflux=f[f.index_of('OBJ_CORR_FLUX')].data
        cubReal=corrflux.field('CORRFLUXREAL1')
        cubReal=np.transpose(cubReal[0:self.frameNumber:10,:,:])
        cubImag=corrflux.field('CORRFLUXIMAG1')
        cubImag=np.transpose(cubImag[0:self.frameNumber:10,:,:])
        self.interferogram=np.real(np.fft.fftshift(np.fft.ifft(np.fft.fftshift(cubReal+1j*cubImag,axes=(0)),axis=0),axes=(0)))
        self.interferogram=np.sqrt(np.abs(self.interferogram))
        self.cub=np.sqrt(np.sqrt(np.sqrt(cubReal*cubReal+cubImag*cubImag)))
        del corrflux
        del cubReal
        del cubImag
        prihdr=f[0].header 
        data_corner = f[2].data
        f.close()
        #compute wavelength
        C0 = float(prihdr['HIERARCH PRO DISP COEF0'])
        C1 = float(prihdr['HIERARCH PRO DISP COEF1'])
        C2 = float(prihdr['HIERARCH PRO DISP COEF2'])
        C3 = float(prihdr['HIERARCH PRO DISP COEF3'])
        C4 = float(prihdr['HIERARCH PRO DISP COEF4'])
        CORNER = np.array(data_corner.field("CORNER"), np.int16)[0][1]
        N = np.array(data_corner.field("NAXIS"), np.int16)[0][1]
        self.lambd = []
        readFits.computeLambdas(C0, C1, C2, C3, C4, CORNER, N, self.lambd)
        self.ind=1
        self.plotDsp('slider')
        self.plotFringe()

    def plotDsp(self, method):
        self.figDsp.clf()
        
        if method=='slider':
            axes=self.figDsp.add_subplot(111, yticks=[])
            axes.set_xlabel('Wavelength')
            axes.xaxis.label.set_fontsize(8)
            axes.set_ylabel('Spatial Frequency')
            axes.yaxis.label.set_fontsize(8)
            axes.set_title('Power Spectrum')
            axes.title.set_fontsize(10)
            axes.imshow(self.cub[:,:,self.ind-1], extent = [min(self.lambd), max(self.lambd), self.cub[:,:,self.ind-1].min(), self.cub[:,:,self.ind-1].max()],aspect='auto')
            self.figDsp.tight_layout()
            self.canvasDsp.draw()
        if method =='mean':
            if self.buttonFrinWave.IsChecked() == True:
                cubmean = np.sum(self.cub, axis = 2)/len(self.cub[0][0]) 
                axes=self.figDsp.add_subplot(111, yticks=[])
                axes.set_xlabel('Wavelength')
                axes.xaxis.label.set_fontsize(8)
                axes.set_ylabel('Spatial Frequency')
                axes.yaxis.label.set_fontsize(8)
                axes.set_title('Power Spectrum')
                axes.title.set_fontsize(10)
                axes.imshow(cubmean[:,:], extent = [min(self.lambd), max(self.lambd), cubmean[:,:].min(), cubmean[:,:].max()],aspect='auto')
                axes.set_visible(True)
                self.figDsp.tight_layout()
                self.canvasDsp.draw()
            else:
                self.ind=self.sliderFrinWave.GetValue();
                axes=self.figDsp.add_subplot(111, yticks=[])
                axes.set_xlabel('Wavelength')
                axes.xaxis.label.set_fontsize(8)
                axes.set_ylabel('Spatial Frequency')
                axes.yaxis.label.set_fontsize(8)
                axes.set_title('Power Spectrum')
                axes.title.set_fontsize(10)
                axes.imshow(self.cub[:,:,self.ind-1], extent = [min(self.lambd), max(self.lambd), self.cub[:,:,self.ind-1].min(), self.cub[:,:,self.ind-1].max()],aspect='auto')
                self.figDsp.tight_layout()

                self.canvasDsp.draw()

    def plotFringe(self):
        self.figFrin.clf()
        axes=self.figFrin.add_subplot(111, yticks=[])
        axes.set_xlabel('Wavelength')
        axes.xaxis.label.set_fontsize(8)
        axes.set_ylabel('Spatial direction')
        axes.yaxis.label.set_fontsize(8)
        axes.set_title('Interferogram')
        axes.title.set_fontsize(10)
        axes.imshow(self.interferogram[:,:,self.ind-1], extent = [min(self.lambd), max(self.lambd), self.interferogram[:,:,self.ind-1].min(), self.interferogram[:,:,self.ind-1].max()],aspect='auto')
        self.figFrin.tight_layout()
        self.canvasFrin.draw()

    def plotOpd(self):
        self.figOpd1.clf()
        self.figOpd2.clf()
        self.figOpd3.clf()
        self.figOpd4.clf()
        self.figOpd5.clf()
        self.figOpd6.clf()
        opdSize=np.shape(self.opd)[0]

        valmin=np.min(self.opd[0:opdSize,0])
        valmax=np.max(self.opd[0:opdSize,0])
        axes1=self.figOpd1.add_subplot(111)
        axes1.set_ylabel('Opd')
        axes1.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes1.yaxis.label.set_fontsize(6)
        axes1.set_xlabel('Frame Number')
        axes1.xaxis.label.set_fontsize(6)
        axes1.set_title('Temporal Evolution of OPD (Baseline 1)')
        axes1.title.set_fontsize(6)
        for item in (axes1.get_xticklabels() + axes1.get_yticklabels()):
            item.set_fontsize(6)        
        axes1.plot(self.opd[0:opdSize,0],'b')
        self.figOpd1.tight_layout()
        self.canvasOpd1.draw()

        valmin=np.min(self.opd[0:opdSize,1])
        valmax=np.max(self.opd[0:opdSize,1])
        axes2=self.figOpd2.add_subplot(111)
        axes2.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes2.set_ylabel('Opd')
        axes2.yaxis.label.set_fontsize(6)
        axes2.set_xlabel('Frame Number')
        axes2.xaxis.label.set_fontsize(6)
        axes2.set_title('Temporal Evolution of OPD (Baseline 2)')
        axes2.title.set_fontsize(6)
        for item in (axes2.get_xticklabels() + axes2.get_yticklabels()):
            item.set_fontsize(6)        
        axes2.plot(self.opd[0:opdSize,1],'b')
        self.figOpd2.tight_layout()
        self.canvasOpd2.draw()

        valmin=np.min(self.opd[0:opdSize,2])
        valmax=np.max(self.opd[0:opdSize,2])
        axes3=self.figOpd3.add_subplot(111)
        axes3.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes3.set_ylabel('Opd')
        axes3.yaxis.label.set_fontsize(6)
        axes3.set_xlabel('Frame Number')
        axes3.xaxis.label.set_fontsize(6)
        axes3.set_title('Temporal Evolution of OPD (Baseline 3)')
        axes3.title.set_fontsize(6)
        for item in (axes3.get_xticklabels() + axes3.get_yticklabels()):
            item.set_fontsize(6)        
        axes3.plot(self.opd[0:opdSize,2],'b')
        self.figOpd3.tight_layout()
        self.canvasOpd3.draw()

        valmin=np.min(self.opd[0:opdSize,3])
        valmax=np.max(self.opd[0:opdSize,3])
        axes4=self.figOpd4.add_subplot(111)
        axes4.set_ylabel('Opd')
        axes4.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes4.yaxis.label.set_fontsize(6)
        axes4.set_xlabel('Frame Number')
        axes4.xaxis.label.set_fontsize(6)
        axes4.set_title('Temporal Evolution of OPD (Baseline 4)')
        axes4.title.set_fontsize(6)
        for item in (axes4.get_xticklabels() + axes4.get_yticklabels()):
            item.set_fontsize(6)        
        axes4.plot(self.opd[0:opdSize,3],'b')
        self.figOpd4.tight_layout()
        self.canvasOpd4.draw()

        valmin=np.min(self.opd[0:opdSize,4])
        valmax=np.max(self.opd[0:opdSize,4])
        axes5=self.figOpd5.add_subplot(111)
        axes5.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes5.set_ylabel('Opd')
        axes5.yaxis.label.set_fontsize(6)
        axes5.set_xlabel('Frame Number')
        axes5.xaxis.label.set_fontsize(6)
        axes5.set_title('Temporal Evolution of OPD (Baseline 5)')
        axes5.title.set_fontsize(6)
        for item in (axes5.get_xticklabels() + axes5.get_yticklabels()):
            item.set_fontsize(6)        
        axes5.plot(self.opd[0:opdSize,4],'b')
        self.figOpd5.tight_layout()
        self.canvasOpd5.draw()

        valmin=np.min(self.opd[0:opdSize,5])
        valmax=np.max(self.opd[0:opdSize,5])
        axes6=self.figOpd6.add_subplot(111)
        axes6.set_ylim(valmin-(valmax-valmin),valmax+(valmax-valmin))
        axes6.set_ylabel('Opd')
        axes6.yaxis.label.set_fontsize(6)
        axes6.set_xlabel('Frame Number')
        axes6.xaxis.label.set_fontsize(6)
        axes6.set_title('Temporal Evolution of OPD (Baseline 6)')
        axes6.title.set_fontsize(6)
        for item in (axes6.get_xticklabels() + axes6.get_yticklabels()):
            item.set_fontsize(6)        
        axes6.plot(self.opd[0:opdSize,5],'b')
        self.figOpd6.tight_layout()
        self.canvasOpd6.draw()

    def buttonFrinWaveClick(self,event):
        #indexVal=np.int(self.frameNumber/2)
        #aux = "Frame Number : %d" % indexVal
        #self.labelFrinWave.SetLabel(aux)
        #self.sliderFrinWave.SetValue(indexVal)
        self.plotDsp('mean')

    def OnSliderFrinWaveScroll(self, event):        
        obj = event.GetEventObject()
        self.ind = obj.GetValue()
        self.buttonFrinWave.SetValue(False)
        aux = "Frame Number: %d" % (self.ind * 10)
        self.labelFrinWave.SetLabel(aux)
        self.plotDsp('slider')
        self.plotFringe()











if __name__ == '__main__':
  
    parser = ReflexIOParser()
    parser.add_input("--enable")
    parser.add_input("--sof_in")
    #input files
    inputs = parser.get_inputs()
    if (inputs.enable == "true") :
        # list all files which are OBJ_CORR_FLUX files    
        listFile=[]
        listPhot=[]
        listOpd=[]
        for i in range(0,len(inputs.sof_in.files)):
            if (inputs.sof_in.files[i].category == "OBJ_CORR_FLUX") :
                listFile.append(inputs.sof_in.files[i].name)
            if (inputs.sof_in.files[i].category == "PHOT_BEAMS") :
                listPhot.append(inputs.sof_in.files[i].name)
            if (inputs.sof_in.files[i].category == "OI_OPDWVPO") :
                listOpd.append(inputs.sof_in.files[i].name)
        listFiles={'phot':  listPhot, 'corrflux': listFile, 'opd': listOpd}

        app = wx.App()
        frameReflex=FrameRawEstimate(None, title="MATISSE WORKFLOW RAW ESTIMATE",size=(1500, 820),file=listFiles )
        app.SetTopWindow(frameReflex)
        app.MainLoop()
    parser.write_outputs()
    sys.exit()
