from adari_core.utils.utils import fetch_kw_or_default

class MatisseReportMixin(object):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

class MatisseSetupInfo:

    @staticmethod
    def detmon(hdul):
        metadata = [
            "DET.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET NAME", default="N/A"
                )
            ),
            "DET.READ.CURNAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET READ CURNAME", default="N/A"
                )
            ),
        ]
        return metadata

    @staticmethod
    def flat(hdul):
        metadata = None
        det_name = str(
            fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO DET NAME", default="N/A")
        )
        if det_name == "MATISSE-N":
            metadata = [
                "DET.NAME: " + det_name,
                "DET.READ.CURNAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO DET READ CURNAME", default="N/A"
                    )
                ),
                "DET.SEQ1.DIT: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO DET SEQ1 DIT", default="N/A"
                    )
                ),
                "INS.PIN.NAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO INS PIN NAME", default="N/A"
                    )
                ),
                "INS.DIN.NAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO INS DIN NAME", default="N/A"
                    )
                ),
            ]
        elif det_name == "MATISSE-LM":
            metadata = [
                "DET.NAME: " + det_name,
                "DET.READ.CURNAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO DET READ CURNAME", default="N/A"
                    )
                ),
                "DET.SEQ1.DIT: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO DET SEQ1 DIT", default="N/A"
                    )
                ),
                "INS.PIL.NAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO INS PIL NAME", default="N/A"
                    )
                ),
                "INS.DIL.NAME: "
                + str(
                    fetch_kw_or_default(
                        hdul["PRIMARY"], "HIERARCH ESO INS DIL NAME", default="N/A"
                    )
                ),
            ]

        return metadata

    @staticmethod
    def kappa(hdul):
        metadata = [
            "DET.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET NAME", default="N/A"
                )
            ),
            "DET.READ.CURNAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET READ CURNAME", default="N/A"
                )
            ),
            "DET.SEQ1.DIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET SEQ1 DIT", default="N/A"
                )
            ),
            "INS.DIL.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS DIL NAME", default="N/A"
                )
            ),
            "QC.DELTA.SHIFT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC DELTA SHIFT", default="N/A"
                )
            ),
        ]
        return metadata

    @staticmethod
    def calib(hdul):
        det_name = str(
            fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO DET NAME", default="N/A")
        )
        ins_di = None
        if det_name == "MATISSE-N":
            ins_di = "INS.DIN.NAME: " + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS DIN NAME", default="N/A"
                )
            )
        elif det_name == "MATISSE-LM":
            ins_di = "INS.DIL.NAME: " + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS DIL NAME", default="N/A"
                )
            )
        metadata = [
            "DET.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET NAME", default="N/A"
                )
            ),
            "DET.READ.CURNAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET READ CURNAME", default="N/A"
                )
            ),
            "DET.SEQ1.DIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET SEQ1 DIT", default="N/A"
                )
            ),
            ins_di,
            "CFG.BCD.MODE: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO CFG BCD MODE", default="N/A"
                )
            ),
            "ISS.CHOP.ST: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CHOP ST", default="N/A"
                )
            ),
        ]
        return metadata
