from dataclasses import dataclass  # noqa

from edps import subworkflow, task, qc1calib, Task

from .matisse_datasources import *
from .matisse_task_functions import which_resolution


@dataclass
class MonitoringTasks:
    rmnrec: Task
    test_calibrations: Task
    acquisition: Task
    cophasing: Task
    basic_detector_map: Task
    extended_detector_map: Task
    remanence_detector_map: Task


@subworkflow("quality_control", "")
def quality_control(detector_calibration, lamp_flat, distortion_calibrations, kappa_matrix):
    # This workflow contains tasks that are needed for quality control but not for the science reduction

    # Ancillary files: test,  RMNrec (Reflective Memory Network Recorder), and acquisitions -------
    rmnrec = (task("rmnrec")
              .with_main_input(raw_rmnrec)
              .build())

    test_calibrations = (task("test_calibrations")
                         .with_main_input(raw_test_calib)
                         .with_meta_targets([qc1calib])
                         .build())

    acquisition = (task("acquisition")
                   .with_main_input(raw_acquisition)
                   .build())
    # ----------------------------------------------------------------------------------------------

    cophasing = (task("cophasing")
                 .with_main_input(raw_cophasing)
                 .with_dynamic_parameter("which_resolution", which_resolution)
                 .with_associated_input(detector_calibration, [BADPIX, NONLINEARITY])
                 .with_associated_input(lamp_flat, [OBS_FLATFIELD], min_ret=0, match_rules=assoc_flats_to_calibrator)
                 # .with_associated_input(distortion_calibrations, [SHIFT_MAP], min_ret=0)
                 .with_alternative_associated_inputs(distortion_calibrations)
                 .with_associated_input(kappa_matrix, [KAPPA_MATRIX], min_ret=0)
                 .with_meta_targets([qc1calib])
                 .build())

    # Calculates a basic detector monitoring map
    basic_detector_map = (task("basic_detector_map")
                          .with_recipe("mat_im_basic")
                          .with_main_input(raw_im_cold)
                          .with_associated_input(detector_calibration, [BADPIX], match_rules=assoc_dark_detector_map)
                          .with_meta_targets([qc1calib])
                          .build())

    # Calculates a extended detector monitoring map
    extended_detector_map = (task("extended_detector_map")
                             .with_recipe("mat_im_extended")
                             .with_main_input(raw_im_extended)
                             .with_associated_input(detector_calibration, [BADPIX])
                             .with_meta_targets([qc1calib])
                             .build())

    # Calculates a detector remanence map
    remanence_detector_map = (task("remanence_detector_map")
                              .with_recipe("mat_im_rem")
                              .with_main_input(raw_im_remanence)
                              .with_associated_input(detector_calibration, [BADPIX])
                              .with_meta_targets([qc1calib])
                              .build())

    return MonitoringTasks(rmnrec=rmnrec,
                           test_calibrations=test_calibrations,
                           acquisition=acquisition,
                           cophasing=cophasing,
                           basic_detector_map=basic_detector_map,
                           extended_detector_map=extended_detector_map,
                           remanence_detector_map=remanence_detector_map)
