/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_BADPIX_H
#define MOO_BADPIX_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/**
 * @ingroup moo_badpix
 */
/**@{*/
/**   The good pixel value */
#define MOO_BADPIX_GOOD 0x0

/** Electronic pickup noise (8) */
#define MOO_BADPIX_NOISY 0x8

/** Cosmic (unremoved) (32) */
#define MOO_BADPIX_COSMIC_UNREMOVED 0x20

/**  Low quantum efficiency (64) */
#define MOO_BADPIX_LOW_QE 0x40

/** Calibration file defect (128) */
#define MOO_BADPIX_CALIB_DEFECT 0x80

/** Hot pixel (256) */
#define MOO_BADPIX_HOT 0x100

/**  Cold pixel (512) */
#define MOO_BADPIX_COLD 0x200

/** Permanent camera defect (8192) */
#define MOO_BADPIX_COSMETIC 0x2000

/**   Non linear response pixel (32768) */
#define MOO_BADPIX_NON_LINEAR 0x8000
/** Outside data range (2^31) */
#define MOO_BADPIX_OUTSIDE_DATA_RANGE 0x80000000

/**@}*/
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code
moo_badpix_to_mask(cpl_image *badpix, cpl_mask *mask, unsigned int level);
cpl_error_code
moo_mask_to_badpix(cpl_image *badpix, cpl_mask *mask, unsigned int level);
cpl_error_code moo_badpix_merge(cpl_image *badpix1, cpl_image *badpix2);
#endif
