/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_COMBINE_PAIR_H
#define MOO_COMBINE_PAIR_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_rbn.h"
#include "moo_target_table.h"
#include "moo_f2f.h"
#include "moo_sci.h"
#include "moo_products.h"

#define MOO_DEBUG_COMBINEPAIR 0

#define MOO_SCI2D_NOT_PAIRED 0
#define MOO_SCI2D_PAIRED     1
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_sci *moo_combine_pair(moo_rbn *nod_rbn,
                          moo_rbn *sky_rbn,
                          moo_rbn *obj_rbn,
                          moo_target_table *target_table,
                          moo_f2f *f2f,
                          const cpl_frame *solflux_frame,
                          const cpl_frame *airglow_group_frame,
                          const cpl_frame *airglow_var_frame,
                          moo_combine_pair_params *params,
                          moo_sub_sky_stare_params *sky_params,
                          const char *filename,
                          moo_products *products,
                          const cpl_frame *ref_frame);

moo_sci *moo_create_sci2d(moo_rbn *nod_rbn,
                          moo_rbn *sky_rbn,
                          moo_rbn *obj_rbn,
                          moo_target_table *target_table,
                          int ispaired,
                          const char *filename);

moo_sci *moo_combine_pair_sci(moo_target_table *target_table,
                              moo_sci *sci1d,
                              moo_sci *psci1d,
                              moo_sci *sci2d,
                              moo_sci *psci2d,
                              const char *filename);


#endif
