/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_COMPUTE_RESP_H
#define MOO_COMPUTE_RESP_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_scilist.h"
#include "moo_resp.h"
#include "moo_atm.h"
#include "moo_flx.h"

#define MOO_DEBUG_RESPONSE_FIT       0
#define MOO_COMPUTE_RESP_FIT_WAVE    "WAVE"
#define MOO_COMPUTE_RESP_FIT_FLUX    "FLUX"
#define MOO_COMPUTE_RESP_FIT_IS_USED "IS_USED"
#define MOO_COMPUTE_RESP_FIT_FIT     "FIT"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_resp *moo_compute_resp(moo_scilist *scilist,
                           moo_atm *atm,
                           moo_flx *stdFlx,
                           moo_compute_resp_params *params);

#endif
