/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_CREATE_S1D_H
#define MOO_CREATE_S1D_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_sci.h"
#include "moo_products.h"

#define MOO_S1D_SPETCRUM_EXTNAME "SPECTRUM"
#define MOO_S1D_WAVE             "WAVE"
#define MOO_S1D_FLUX             "FLUX"
#define MOO_S1D_ERR              "ERR"
#define MOO_S1D_QUAL             "QUAL"
#define MOO_S1D_BGFLUX           "BGFLUX"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_s1d *moo_s1d_new(void);
void moo_s1d_delete(moo_s1d *self);
void moo_s1d_save(moo_s1d *self);
cpl_error_code moo_create_s1d(cpl_frame *sci,
                              moo_create_s1d_params *params,
                              const char *tag,
                              moo_products *products);

#endif
