/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_CUBE_H
#define MOO_CUBE_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
#include "moo_saturate_map.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_propertylist *data_header[6];
    cpl_imagelist *data[6];
} moo_cube;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_cube *moo_cube_new(void);
moo_cube *moo_cube_load(const cpl_frame *frame);
cpl_error_code moo_cube_set_data(moo_cube *self,
                                 moo_detector_type type,
                                 int ntas,
                                 cpl_imagelist *data,
                                 cpl_propertylist *header);
cpl_error_code moo_cube_add_data(moo_cube *self,
                                 cpl_imagelist *list,
                                 moo_detector_type type,
                                 int ntas);
cpl_error_code moo_cube_normalise(moo_cube *self, moo_saturate_map *saturate);
void moo_cube_save(moo_cube *self, const char *filename);
moo_cube *moo_cube_merge(moo_cube *cubea,
                         moo_saturate_map *saturatea,
                         moo_cube *cubeb,
                         moo_saturate_map *saturateb);
void moo_cube_delete(moo_cube *self);
#endif
