/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_DET_H
#define MOO_DET_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
#include "moo_single.h"


/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */

typedef struct
{
    char *filename;

    cpl_propertylist *primary_header;

    moo_single *ri[2];

    moo_single *yj[2];

    moo_single *h[2];

    cpl_table *fibre_table;
} moo_det;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_det *moo_det_new(void);
moo_det *moo_det_create(const cpl_frame *frame);
cpl_error_code moo_det_load(moo_det *self, unsigned int level);
moo_single *
moo_det_load_single(moo_det *self, moo_detector_type type, int num, int level);
cpl_error_code
moo_det_free_single(moo_det *self, moo_detector_type type, int num);
cpl_error_code moo_det_load_ri(moo_det *self, int num, int level);
cpl_error_code moo_det_load_yj(moo_det *self, int num, int level);
cpl_error_code moo_det_load_h(moo_det *self, int num, int level);

cpl_error_code moo_det_set_single(moo_det *self,
                                  moo_detector_type type,
                                  int num,
                                  moo_single *single);
moo_single *moo_det_get_single(moo_det *self, moo_detector_type type, int num);

cpl_propertylist *moo_det_get_primary_header(moo_det *self);
cpl_table *moo_det_get_fibre_table(moo_det *self);

cpl_propertylist *
moo_det_get_single_header(moo_det *self, moo_detector_type type, int num);

void moo_det_delete(moo_det *self);
void moo_det_save(moo_det *self, const char *filename);
cpl_error_code moo_det_dump(const moo_det *self, FILE *stream);
cpl_error_code moo_det_divide(moo_det *self, moo_det *det);
cpl_error_code moo_det_rescale_using_exptime(moo_det *self, moo_det *det);
cpl_error_code moo_det_sum(moo_det *self, moo_det *det);
cpl_error_code moo_det_subtract(moo_det *self, moo_det *det);
cpl_error_code moo_det_mean(moo_det *self, moo_det *det);
cpl_error_code moo_det_filter_snr(moo_det *self, double *min_snr);
#endif
