/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_DFS_H
#define MOO_DFS_H

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
#include <cpl.h>

/* Raw frame tags  */
#define MOONS_TAG_RAW                       "RAW"
#define MOONS_TAG_LINEARITY                 "LINEARITY"
#define MOONS_TAG_LINEARITY_OFF             "LINEARITY_OFF"
#define MOONS_TAG_LINEARITY_SATURATE        "LINEARITY_SATURATE"
#define MOONS_TAG_LINEARITY_SNR             "LINEARITY_SNR"
#define MOONS_TAG_LINEARITY_COEFF_CUBE      "LINEARITY_COEFF_CUBE"
#define MOONS_TAG_LINEARITY_NORM_COEFF_CUBE "LINEARITY_NORM_COEFF_CUBE"
#define MOONS_TAG_BIAS                      "BIAS"
#define MOONS_TAG_DARK_VIS                  "DARK_VIS"
#define MOONS_TAG_DARK_NIR                  "DARK_NIR"
#define MOONS_TAG_FLAT                      "FLAT"
#define MOONS_TAG_FLAT_ATTACHED             "FLAT_ATTACHED"
#define MOONS_TAG_FLAT_OFF                  "FLAT_OFF"
#define MOONS_TAG_ARC                       "ARC"
#define MOONS_TAG_ARC_OFF                   "ARC_OFF"
#define MOONS_TAG_OBJECT                    "OBJECT"
#define MOONS_TAG_STD_FLUX                  "STD_FLUX"
#define MOONS_TAG_STD_TELL                  "STD_TELL"
#define MOONS_TAG_STD_TARGET_TABLE          "STD_TARGET_TABLE"
#define MOONS_TAG_OBJECT_STARE              "OBJECT_STARE"
#define MOONS_TAG_OBJECT_STARENOD           "OBJECT_STARENOD"
#define MOONS_TAG_OBJECT_XSWITCH            "OBJECT_XSWITCH"

#define MOONS_TAG_SKY_STARENOD              "SKY_STARENOD"

/*Intermediate */
#define MOONS_TAG_BIAS_PREPARE                 "BIAS_PREPARE"
#define MOONS_TAG_DARK_CORRECTBIAS             "DARK_CORRECTBIAS"
#define MOONS_TAG_DARK_REMOVECRH               "DARK_REMOVECRH"
#define MOONS_TAG_DARK_COMPUTEHOT              "DARK_COMPUTEHOT"

#define MOONS_TAG_FLAT_CORRECTBIAS             "FLAT_CORRECTBIAS"
#define MOONS_TAG_FLAT_CORRECTDARK             "FLAT_CORRECTDARK"
#define MOONS_TAG_FLAT_REMOVECRH               "FLAT_REMOVECRH"
#define MOONS_TAG_FLAT_APPLYP2P                "FLAT_APPLYP2P"

#define MOONS_TAG_FLATOFF_PREPARE              "FLATOFF_PREPARE"
#define MOONS_TAG_FLAT_EXTSPECTRA              "FLAT_EXTSPECTRA"

#define MOONS_TAG_LINEARITY_PREPAREADU         "LINEARITY_PREPAREADU"
#define MOONS_TAG_LINEARITY_COMBSLIT           "LINEARITY_COMBSLIT"
#define MOONS_TAG_LINEARITY_OFF_COMBSLIT       "LINEARITY_OFF_COMBSLIT"

#define MOONS_TAG_ARC_CORRECTBIAS              "ARC_CORRECTBIAS"
#define MOONS_TAG_ARCOFF_PREPARE               "ARCOFF_PREPARE"
#define MOONS_TAG_ARC_CORRECTDARK              "ARC_CORRECTDARK"
#define MOONS_TAG_ARC_REMOVECRH                "ARC_REMOVECRH"

#define MOONS_TAG_STDTELL_CORRECTDARK          "STDTELL_CORRECTDARK"
#define MOONS_TAG_STDTELL_REMOVECRH            "STDTELL_REMOVECRH"
#define MOONS_TAG_STDTELL_APPLYP2P             "STDTELL_APPLYP2P"
#define MOONS_TAG_STDTELL_EXTSPECTRA           "STDTELL_EXTSPECTRA"
#define MOONS_TAG_STDTELL_FFEXTSPECTRA         "STDTELL_FFEXTSPECTRA"
#define MOONS_TAG_STDTELL_TARGET_TABLE         "STDTELL_TARGET_TABLE"

#define MOONS_TAG_STDFLUX_CORRECTDARK          "STDFLUX_CORRECTDARK"
#define MOONS_TAG_STDFLUX_APPLYP2P             "STDFLUX_APPLYP2P"
#define MOONS_TAG_STDFLUX_EXTSPECTRA           "STDFLUX_EXTSPECTRA"
#define MOONS_TAG_STDFLUX_FFEXTSPECTRA         "STDFLUX_FFEXTSPECTRA"
#define MOONS_TAG_STDFLUX_TARGET_TABLE         "STDFLUX_TARGET_TABLE"

#define MOONS_TAG_QUICKLOOK_PREPARE            "QUICKLOOK_PREPARE"
#define MOONS_TAG_QUICKLOOK_CORRECTDARK        "QUICKLOOK_CORRECTDARK"
#define MOONS_TAG_QUICKLOOK_APPLYP2P           "QUICKLOOK_APPLYP2P"
#define MOONS_TAG_SCIENCE_QUICKLOOK_EXTSPECTRA "SCIENCE_QUICKLOOK_EXTSPECTRA"
#define MOONS_TAG_SCIENCE_QUICKLOOK_FFEXTSPECTRA \
    "SCIENCE_QUICKLOOK_FFEXTSPECTRA"

#define MOONS_TAG_STARE_PREPARE            "STARE_PREPARE"
#define MOONS_TAG_STARE_CORRECTDARK        "STARE_CORRECTDARK"
#define MOONS_TAG_STARE_APPLYP2P           "STARE_APPLYP2P"
#define MOONS_TAG_STD_SCISPECTRA           "STD_SCISPECTRA"

#define MOONS_TAG_STARENOD_REMOVECRH       "STARENOD_REMOVECRH"
#define MOONS_TAG_STARENOD_SUBTRACTNOD     "STARENOD_SUBTRACTNOD"
#define MOONS_TAG_STARENOD_OBJ_CORRECTDARK "STARENOD_OBJ_CORRECTDARK"
#define MOONS_TAG_STARENOD_SKY_CORRECTDARK "STARENOD_SKY_CORRECTDARK"
#define MOONS_TAG_STARENOD_OBJ_APPLYP2P    "STARENOD_OBJ_APPLYP2P"
#define MOONS_TAG_STARENOD_SKY_APPLYP2P    "STARENOD_SKY_APPLYP2P"

#define MOONS_TAG_XSWITCH_REMOVECRH        "XSWITCH_REMOVECRH"
#define MOONS_TAG_XSWITCH_SUBTRACTNOD      "XSWITCH_SUBTRACTNOD"
#define MOONS_TAG_XSWITCH_CORRECTDARK      "XSWITCH_CORRECTDARK"
#define MOONS_TAG_XSWITCH_APPLYP2P         "XSWITCH_APPLYP2P"
#define MOONS_TAG_XSWITCH_TARGET_TABLE     "XSWITCH_TARGET_TABLE"

/* Product frame tags */
#define MOONS_TAG_BP_MAP_RP                    "BP_MAP_RP"
#define MOONS_TAG_BP_MAP_NL                    "BP_MAP_NL"
#define MOONS_TAG_LINE_CATALOG                 "LINE_CATALOG"
#define MOONS_TAG_FLUX_STD_CATALOG             "FLUX_STD_CAT"
#define MOONS_TAG_ATMOS_EXT                    "ATMOS_EXT"
#define MOONS_TAG_MASTER_BIAS                  "MASTER_BIAS"
#define MOONS_TAG_MASTER_DARK_VIS              "MASTER_DARK_VIS"
#define MOONS_TAG_MASTER_DARK_NIR              "MASTER_DARK_NIR"
#define MOONS_TAG_CALIBRATED_SPECTRA           "CALIBRATED_SPECTRA"

#define MOONS_TAG_FF_TRACE_GUESS               "FF_TRACE_GUESS"
#define MOONS_TAG_FF_TRACE                     "FF_TRACE"
#define MOONS_TAG_FF_EXTSPECTRA                "FF_EXTSPECTRA"
#define MOONS_TAG_MASTER_FLAT                  "MASTER_FLAT"
#define MOONS_TAG_P2P_MAP                      "P2P_MAP"
#define MOONS_TAG_F2F_TABLE                    "F2F_TABLE"

#define MOONS_TAG_ARC_LINE_LIST                "ARC_LINE_LIST"
#define MOONS_TAG_SKY_LINE_LIST                "SKY_LINE_LIST"
#define MOONS_TAG_SPECTRAL_FORMAT              "SPECTRAL_FORMAT"
#define MOONS_TAG_LAYOUT                       "LAYOUT"
#define MOONS_TAG_WAVEMAP_GUESS                "WAVE_MAP_GUESS"
#define MOONS_TAG_WAVEMAP_PPM                  "WAVE_MAP_PPM"
#define MOONS_TAG_ARC_RBNSPECTRA_PPM           "ARC_RBNSPECTRA_PPM"
#define MOONS_TAG_WAVEMAP_REFIT                "WAVE_MAP_REFIT"
#define MOONS_TAG_ARC_RBNSPECTRA_REFIT         "ARC_RBNSPECTRA_REFIT"
#define MOONS_TAG_WAVEMAP                      "WAVE_MAP"

#define MOONS_TAG_ARC_EXTSPECTRA_GUESS         "ARC_EXTSPECTRA_GUESS"
#define MOONS_TAG_ARC_RBNSPECTRA_GUESS         "ARC_RBNSPECTRA_GUESS"
#define MOONS_TAG_ARC_EXTSPECTRA               "ARC_EXTSPECTRA"
#define MOONS_TAG_ARC_FFEXTSPECTRA             "ARC_FFEXTSPECTRA"
#define MOONS_TAG_ARC_RBNSPECTRA               "ARC_RBNSPECTRA"

#define MOONS_TAG_STDFLUX_RBNSPECTRA           "STDFLUX_RBNSPECTRA"
#define MOONS_TAG_STDFLUX_RBNTELLCORRSPECTRA   "STDFLUX_RBNTELLCORRSPECTRA"
#define MOONS_TAG_STDFLUX_SKSSPECTRA           "STDFLUX_SKSSPECTRA"
#define MOONS_TAG_STDTELL_RBNSPECTRA           "STDTELL_RBNSPECTRA"
#define MOONS_TAG_STDTELL_SKSSPECTRA           "STDTELL_SKSSPECTRA"
#define MOONS_TAG_RESPONSE                     "RESPONSE"


#define MOONS_TAG_TELLURIC_CORR                "TELLURIC_CORR"

#define MOONS_TAG_SCIENCE_QUICKLOOK_EXTSPECTRA "SCIENCE_QUICKLOOK_EXTSPECTRA"
#define MOONS_TAG_SCIENCE_QUICKLOOK_RBNSPECTRA "SCIENCE_QUICKLOOK_RBNSPECTRA"
#define MOONS_TAG_SCIENCE_QUICKLOOK_TARGET_TABLE \
    "SCIENCE_QUICKLOOK_TARGET_TABLE"
#define MOONS_TAG_SCIENCE_QUICKLOOK_SKSSPECTRA "SCIENCE_QUICKLOOK_SKSSPECTRA"


#define MOONS_TAG_SCIENCE_STARE_EXTSPECTRA     "SCIENCE_STARE_EXTSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_RBNSPECTRA     "SCIENCE_STARE_RBNSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_RBNFLXSPECTRA  "SCIENCE_STARE_RBNFLXSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_RBNTELLCORRSPECTRA \
    "SCIENCE_STARE_RBNTELLCORRSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_TARGET_TABLE    "SCIENCE_STARE_TARGET_TABLE"
#define MOONS_TAG_SCIENCE_STARE_SKSSPECTRA      "SCIENCE_STARE_SKSSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_TELLCORRSPECTRA "SCIENCE_STARE_TELLCORRSPECTRA"
#define MOONS_TAG_SCIENCE_STARE_1DSPECTRUM      "SCIENCE_STARE_1DSPECTRUM"

#define MOONS_TAG_SCIENCE_STARENOD_EXTSPECTRA   "SCIENCE_STARENOD_EXTSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_RBNSPECTRA   "SCIENCE_STARENOD_RBNSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_RBNFLXSPECTRA \
    "SCIENCE_STARENOD_RBNFLXSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_RBNTELLCORRSPECTRA \
    "SCIENCE_STARENOD_RBNTELLCORRSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_TARGET_TABLE "SCIENCE_STARENOD_TARGET_TABLE"
#define MOONS_TAG_SCIENCE_STARENOD_SKSSPECTRA   "SCIENCE_STARENOD_SKSSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_TELLCORRSPECTRA \
    "SCIENCE_STARENOD_TELLCORRSPECTRA"
#define MOONS_TAG_SCIENCE_STARENOD_1DSPECTRUM   "SCIENCE_STARENOD_1DSPECTRUM"
#define MOONS_TAG_SCIENCE_STARENOD2_1DSPECTRUM  "SCIENCE_STARENOD2_1DSPECTRUM"
#define MOONS_TAG_SCIENCE_XSWITCH_1DSPECTRUM    "SCIENCE_XSWITCH_1DSPECTRUM"
#define MOONS_TAG_SCIENCE_XSWITCH2_1DSPECTRUM   "SCIENCE_XSWITCH2_1DSPECTRUM"

#define MOONS_TAG_SCIENCE_XSWITCH_EXTSPECTRA    "SCIENCE_XSWITCH_EXTSPECTRA"
#define MOONS_TAG_SCIENCE_XSWITCH_RBNSPECTRA    "SCIENCE_XSWITCH_RBNSPECTRA"
#define MOONS_TAG_SCIENCE_XSWITCH_RBNFLXSPECTRA "SCIENCE_XSWITCH_RBNFLXSPECTRA"
#define MOONS_TAG_SCIENCE_XSWITCH_RBNTELLCORRSPECTRA \
    "SCIENCE_XSWITCH_RBNTELLCORRSPECTRA"
#define MOONS_TAG_SCIENCE_XSWITCH_SKSSPECTRA "SCIENCE_XSWITCH_SKSSPECTRA"

#define MOONS_TAG_SCIENCE_TELLCORRSPECTRA    "SCIENCE_TELLCORRSPECTRA"

#define MOONS_TAG_STARENOD_SKSSPECTRA        "SCIENCE_STARENOD_SKSSPECTRA"
#define MOONS_TAG_XSWITCH_SKSSPECTRA         "SCIENCE_XSWITCH_SKSSPECTRA"

#define MOONS_TAG_STARENOD_COMBINED_SPECTRA  "SCIENCE_STARENOD_COMBINED_SPECTRA"
#define MOONS_TAG_STARENOD2_COMBINED_SPECTRA \
    "SCIENCE_STARENOD2_COMBINED_SPECTRA"
#define MOONS_TAG_XSWITCH_COMBINED_SPECTRA  "SCIENCE_XSWITCH_COMBINED_SPECTRA"
#define MOONS_TAG_XSWITCH2_COMBINED_SPECTRA "SCIENCE_XSWITCH2_COMBINED_SPECTRA"

#define MOONS_TAG_AIRGLOW_GROUP             "AIRGLOW_GROUP"
#define MOONS_TAG_AIRGLOW_VAR               "AIRGLOW_VAR"
#define MOONS_TAG_SOLFLUX                   "SOLFLUX"

#define MOONS_TAG_MOLECFIT_SCI              "SCIENCE"
#define MOONS_TAG_MOLECFIT_MOLECULES        "MOLECULES"
#define MOONS_TAG_MOLECFIT_WINCLUDE         "WAVE_INCLUDE"
#define MOONS_TAG_MOLECFIT_ATM_PARAMS       "ATM_PARAMETERS"
#define MOONS_TAG_MOLECFIT_BEST_FIT_PARAMS  "BEST_FIT_PARAMETERS"
#define MOONS_TAG_MOLECFIT_BEST_FIT_MODEL   "BEST_FIT_MODEL"
#define MOONS_TAG_MOLECFIT_KERNEL_LIBRARY   "KERNEL_LIBRARY"

#define MOONS_SLIT_OFFSET_POS1              1
#define MOONS_SLIT_OFFSET_POS2              2
#define MOONS_SLIT_OFFSET_EPSILON           1E-12
/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code moo_dfs_set_groups(cpl_frameset *set);

double *moo_dfs_get_exptime(cpl_frameset *set);

cpl_frameset **moo_dfs_split_by_offset(cpl_frameset *set);

#endif
