/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_DRL_H
#define MOO_DRL_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_single.h"
#include "moo_det.h"
#include "moo_detlist.h"
#include "moo_masklist.h"
#include "moo_ext.h"
#include "moo_psf.h"
#include "moo_f2f.h"
#include "moo_prepare.h"
#include "moo_remove_crh.h"
#include "moo_localise.h"
#include "moo_model_flat.h"
#include "moo_extract.h"
#include "moo_compute_p2p.h"
#include "moo_apply_p2p.h"
#include "moo_compute_fibtrans.h"
#include "moo_wavesol.h"
#include "moo_rebin.h"
#include "moo_apply_flat.h"
#include "moo_target_table.h"
#include "moo_sub_sky_stare.h"
#include "moo_coadd.h"
#include "moo_flx.h"
#include "moo_atm.h"
#include "moo_resp.h"
#include "moo_compute_resp.h"
#include "moo_calib_flux.h"
#include "moo_fibres_table.h"
#include "moo_create_s1d.h"
#define MOO_DEBUG_COMPUTE_NOISE_MAP 0

cpl_error_code moo_compute_noise_map(moo_det *det,
                                     moo_detlist *darkList,
                                     moo_masklist *cosmiclist,
                                     moo_nos_params *params);

cpl_error_code moo_compute_hot_map(moo_det *det, moo_hot_params *params);

cpl_error_code moo_correct_bias(moo_det *det,
                                const cpl_frame *mbias,
                                moo_correct_bias_params *params);

cpl_error_code moo_correct_dark(moo_det *det,
                                moo_det *detoff,
                                const cpl_frame *masterDarkVis,
                                const cpl_frame *masterDarkNir);


cpl_error_code moo_correct_detlin(moo_det *det, const cpl_frame *cube_frame);

#endif
