/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_EXT_H
#define MOO_EXT_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_map.h"
#include "moo_spectral_format.h"
#include "moo_ext_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    moo_ext_single *ri[2];
    moo_ext_single *yj[2];
    moo_ext_single *h[2];
    cpl_table *fibre_table;

} moo_ext;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_ext *moo_ext_new(void);
moo_ext *moo_ext_create(const cpl_frame *frame);
cpl_error_code moo_ext_load(moo_ext *self, unsigned int level);
moo_ext_single *moo_ext_load_single(moo_ext *self,
                                    moo_detector_type type,
                                    int num,
                                    unsigned int level);
cpl_error_code moo_ext_set_single(moo_ext *self,
                                  moo_detector_type type,
                                  int ntas,
                                  moo_ext_single *s);

moo_ext_single *
moo_ext_get_single(moo_ext *self, moo_detector_type type, int num);

cpl_error_code moo_ext_add_single(moo_ext *self,
                                  moo_ext_single *s,
                                  moo_detector_type type,
                                  int ntas);
cpl_error_code moo_ext_add_fibre_table(moo_ext *self, cpl_table *fibre_table);

cpl_table *moo_ext_get_fibre_table(moo_ext *self);
void moo_ext_delete(moo_ext *self);
void moo_ext_save(moo_ext *self, const char *filename);
cpl_error_code moo_ext_dump(const moo_ext *self, FILE *stream);
cpl_error_code
moo_ext_free_single(moo_ext *self, moo_detector_type type, int num);
cpl_error_code moo_ext_sum(moo_ext *self, moo_ext *ext);
cpl_error_code moo_ext_compute_snr(moo_ext *self,
                                   moo_map *wmap,
                                   moo_spectral_format *sformat,
                                   moo_sky_lines_list *skylines);
#endif
