/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_F2F_H
#define MOO_F2F_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    cpl_table *table;
} moo_f2f;

#define MOO_F2F_EXTNAME       "F2F"
#define MOO_F2F_INDEX         "INDEX"
#define MOO_F2F_INDEX_TYPE    CPL_TYPE_INT
#define MOO_F2F_TRANS_RI      "TRANS_RI"
#define MOO_F2F_TRANS_RI_TYPE CPL_TYPE_FLOAT
#define MOO_F2F_TRANS_YJ      "TRANS_YJ"
#define MOO_F2F_TRANS_YJ_TYPE CPL_TYPE_FLOAT
#define MOO_F2F_TRANS_H       "TRANS_H"
#define MOO_F2F_TRANS_H_TYPE  CPL_TYPE_FLOAT
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_f2f *moo_f2f_new(void);
moo_f2f *moo_f2f_load(const cpl_frame *f2f_frame);
moo_f2f *moo_f2f_create(int nbrows, cpl_table *table);
cpl_error_code moo_f2f_order_by_indexrbn(moo_f2f *f2f);
cpl_error_code moo_f2f_order_by_index(moo_f2f *f2f);
cpl_error_code moo_f2f_set_trans(moo_f2f *self,
                                 moo_detector_type type,
                                 cpl_array *idx,
                                 cpl_vector *values);
const char *moo_f2f_get_trans_colname(moo_f2f *self, moo_detector_type type);
cpl_vector *
moo_f2f_get_trans(moo_f2f *self, moo_detector_type type, cpl_array *idxtab);
float *moo_f2f_get_trans_column(moo_f2f *self, moo_detector_type type);

cpl_error_code moo_f2f_compute_qc(moo_f2f *self, int *ref, cpl_array *bad);


/*cpl_error_code moo_ext_set_single(moo_ext* self, moo_detector_type type,
        int ntas, moo_ext_single* s);
moo_ext* moo_ext_create(const char* filename);

moo_ext* moo_ext_load(const cpl_frame* extframe);
moo_ext_single* moo_ext_get_single(moo_ext* self, moo_detector_type type,
        int num);

cpl_error_code moo_ext_add_single(moo_ext* self, moo_ext_single* s,
        moo_detector_type type, int ntas);
cpl_error_code moo_ext_add_fibre_table(moo_ext* self, cpl_table* fibre_table);

cpl_table* moo_ext_get_fibre_table(moo_ext* self);*/
void moo_f2f_delete(moo_f2f *self);
cpl_error_code moo_f2f_save(moo_f2f *self, const char *filename);
//cpl_error_code moo_ext_dump(const moo_ext * self, FILE * stream);
#endif
