/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_FITS_H
#define MOO_FITS_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code moo_fits_create(const char *filename);
cpl_error_code moo_fits_write_extension_mask(cpl_mask *mask,
                                             const char *filename,
                                             const char *name,
                                             const char *detectorname,
                                             cpl_propertylist *header);
cpl_error_code moo_fits_write_extension_image(cpl_image *image,
                                              const char *filename,
                                              const char *name,
                                              const char *detectorname,
                                              cpl_type type,
                                              cpl_propertylist *header);
cpl_error_code moo_fits_write_extension_table(cpl_table *table,
                                              const char *filename,
                                              const char *name,
                                              const char *detectorname,
                                              cpl_propertylist *header);
cpl_error_code moo_fits_write_extension_cube(cpl_imagelist *cube,
                                             const char *filename,
                                             const char *name,
                                             const char *detectorname,
                                             cpl_type type,
                                             cpl_propertylist *header);
cpl_image *moo_fits_load_extension_image(const char *filename,
                                         const char *name,
                                         const char *detectorname,
                                         cpl_type type);
cpl_table *moo_fits_load_extension_table(const char *filename,
                                         const char *name,
                                         const char *detectorname);
cpl_mask *moo_fits_load_extension_mask(const char *filename,
                                       const char *name,
                                       const char *detectorname);
cpl_imagelist *moo_fits_load_extension_cube(const char *filename,
                                            const char *name,
                                            const char *detectorname,
                                            cpl_type type);
cpl_propertylist *moo_fits_load_extension_header(const char *filename,
                                                 const char *name,
                                                 const char *detectorname);
#endif
