/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_FLX_H
#define MOO_FLX_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_ext.h"
#include "moo_spectral_format.h"

/** 
 * @ingroup moo_flx
 * 
 * @brief FLX format
 */

/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_table *catalog;
} moo_flx;

#define MOO_FLX_CATALOG_EXTNAME "CATALOG"
#define MOO_FLX_CATALOG_NAME    "NAME"
#define MOO_FLX_SPECTRUM_WAVE   "WAVE"
#define MOO_FLX_SPECTRUM_FLUX   "FLUX"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_flx *moo_flx_new(void);
moo_flx *moo_flx_load(const cpl_frame *frame);
cpl_table *moo_flx_get_obj(moo_flx *self, const char *objname);
void moo_flx_delete(moo_flx *self);

#endif
