/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_LOCALISE_H
#define MOO_LOCALISE_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_det.h"
#include "moo_loc.h"

#define MOO_DEBUG_LOCALISE                     0
#define MOO_DEBUG_LOCALISE_BAND                0
#define MOO_DEBUG_LOCALISE_TRACKING            0

#define MOO_FIBRE_LOC_TABLE_Y                  "Y"
#define MOO_FIBRE_LOC_TABLE_FLUX               "FLUX"
#define MOO_FIBRE_LOC_TABLE_FLUX_ERR           "FLUX_ERR"
#define MOO_FIBRE_LOC_TABLE_BAD                "BAD"
#define MOO_FIBRE_LOC_TABLE_BACKGROUND         "BACKGROUND"
#define MOO_FIBRE_LOC_TABLE_BACKGROUND_ERR     "BACKGROUND_ERR"
#define MOO_FIBRE_LOC_TABLE_BCKGFITTED         "BCKGFITTED"
#define MOO_FIBRE_LOC_TABLE_THRESH             "THRESH"
#define MOO_FIBRE_LOC_TABLE_FLAG               "FLAG"

#define MOO_DETECT_LOC_TABLE_NUM               "NUM"
#define MOO_DETECT_LOC_TABLE_YMIN              "YMIN"
#define MOO_DETECT_LOC_TABLE_YMAX              "YMAX"
#define MOO_DETECT_LOC_TABLE_FLUX_YMIN         "FLUX_YMIN"
#define MOO_DETECT_LOC_TABLE_FLUX_YMAX         "FLUX_YMAX"

#define MOO_DETECT_LOC_TABLE_YBCKGMIN          "YBCKGMIN"
#define MOO_DETECT_LOC_TABLE_FLUX_YBCKGMIN     "FLUX_YBCKGMIN"
#define MOO_DETECT_LOC_TABLE_YBCKGMAX          "YBCKGMAX"
#define MOO_DETECT_LOC_TABLE_FLUX_YBCKGMAX     "FLUX_YBCKGMAX"
#define MOO_DETECT_LOC_TABLE_YTMIN             "YTMIN"
#define MOO_DETECT_LOC_TABLE_FLUX_YTMIN        "FLUX_YTMIN"
#define MOO_DETECT_LOC_TABLE_YTMAX             "YTMAX"
#define MOO_DETECT_LOC_TABLE_FLUX_YTMAX        "FLUX_YTMAX"
#define MOO_DETECT_LOC_TABLE_YBARY             "YBARY"
#define MOO_DETECT_LOC_TABLE_FLUX_YBARY        "FLUX_YBARY"
#define MOO_DETECT_LOC_TABLE_YWIDTH            "YWIDTH"
#define MOO_DETECT_LOC_TABLE_FIBNUM            "FIBNUM"

#define MOO_TRACKING_LOC_TABLE_FIBNUM          "FIBNUM"
#define MOO_TRACKING_LOC_TABLE_YCENTROID       "YCENTROID"
#define MOO_TRACKING_LOC_TABLE_X               "X"
#define MOO_TRACKING_LOC_TABLE_YMIN            "YMIN"
#define MOO_TRACKING_LOC_TABLE_YMAX            "YMAX"
#define MOO_TRACKING_LOC_TABLE_SNR             "SNR"
#define MOO_TRACKING_LOC_TABLE_WDIFF           "WDIFF"
#define MOO_TRACKING_LOC_TABLE_YDIFF           "YDIFF"
#define MOO_TRACKING_LOC_TABLE_FLAG            "FLAG"
#define MOO_TRACKING_LOC_TABLE_XGOOD_RATIO     "XGOOD_RATIO"
#define MOO_TRACKING_LOC_TABLE_FITYCENTROID    "FIT_YCENTROID"
#define MOO_TRACKING_LOC_TABLE_FITYMIN         "FIT_YMIN"
#define MOO_TRACKING_LOC_TABLE_FITYMAX         "FIT_YMAX"

#define MOO_TRACKING_LOC_TABLE_GUESS_YCENTROID "GUESS_YCENTROID"
#define MOO_TRACKING_LOC_TABLE_GUESS_WLO       "GUESS_WLO"
#define MOO_TRACKING_LOC_TABLE_GUESS_WUP       "GUESS_WUP"
moo_loc *moo_localise(moo_det *det,
                      const cpl_frame *guess_loc,
                      moo_localise_params *params,
                      const char *locname);
#endif
