/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_MAP_H
#define MOO_MAP_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_rbn.h"
#include "moo_spectral_format.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_image *data[6];
    cpl_propertylist *data_header[6];
    cpl_table *fibre_table;
    cpl_table *line_table;
} moo_map;

#define MOO_MAP_CRPIX1 1
#define MOO_MAP_CRVAL1 1
#define MOO_MAP_CD1_1  1.
#define MOO_MAP_CTYPE1 "PIXELS"
#define MOO_MAP_CRPIX2 1
#define MOO_MAP_CRVAL2 1
#define MOO_MAP_CD2_2  1.
#define MOO_MAP_CTYPE2 "PIXELS"
#define MOO_MAP_BUNIT  "nm"

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_map *moo_map_new(void);

moo_map *moo_map_load(const cpl_frame *mapframe);

cpl_table *moo_map_get_line_table(moo_map *self);
cpl_error_code moo_map_set_data(moo_map *self,
                                moo_detector_type type,
                                int ntas,
                                cpl_image *data,
                                cpl_propertylist *header);
cpl_error_code moo_map_set_fibre_table(moo_map *self, cpl_table *fibre_table);
cpl_error_code moo_map_set_line_table(moo_map *self, cpl_table *line_table);
void moo_map_delete(moo_map *self);
void moo_map_update_linetable(moo_map *self, moo_rbn *rbn);
void moo_map_save(moo_map *self, const char *filename);
cpl_error_code moo_map_check(moo_map *self, moo_spectral_format *sformat);
cpl_error_code moo_map_dump(const moo_map *self, FILE *stream);
#endif
