/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_MASKLIST_H
#define MOO_MASKLIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_mask.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */
typedef struct
{
    moo_mask **list;
    cpl_size size;
} moo_masklist;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_masklist *moo_masklist_new(void);
moo_masklist *moo_masklist_create(int size);
cpl_size moo_masklist_get_size(const moo_masklist *self);

void moo_masklist_delete(moo_masklist *self);
moo_mask *moo_masklist_get(moo_masklist *self, int i);
cpl_mask *moo_masklist_get_mask(moo_masklist *self,
                                int i,
                                moo_detector_type type,
                                int num);
#endif
