/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_MOLECFIT_H
#define MOO_MOLECFIT_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_detector.h"
#include "moo_sci.h"
#include "moo_molectable.h"
#include "moo_telluric.h"

#define MOO_DEBUG_MOLECFIT_MODEL     0
#define MOO_DEBUG_MOLECFIT_CALCTRANS 0

#define MOO_MOLECFIT__WAVE "WAVE"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_molectable *
moo_molecfit_model(const cpl_frame *sci,
                   const char *modename,
                   const cpl_frame *molecules,
                   const cpl_frame *winclude,
                   moo_molectable **mt_atm_fitted,
                   moo_molectable **mt_best_fitted_model,
                   moo_molecfit_model_params *molecfit_model_params);

moo_telluric *moo_molecfit_calctrans(const cpl_frame *science,
                                     const char *modename,
                                     const cpl_frame *molecules,
                                     const cpl_frame *atm,
                                     const cpl_frame *best_fit,
                                     const cpl_frame *kenrel_lib,
                                     moo_molecfit_calctrans_params *params);
#endif
