/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_PREPARE_H
#define MOO_PREPARE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_single.h"
#include "moo_det.h"
#include "moo_detlist.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define DEBUG_PREPARE_ADU          0
#define DEBUG_PREPARE_ADU_LIN      0

#define MOO_PREPARE_COUNT_BUNIT    "counts"
#define MOO_PREPARE_ADU_BUNIT      "adu"
#define MOO_TO_ELECTRON(adu, gain) (adu / gain)
#define MOO_TO_ADU(e, gain)        (e * gain)


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

moo_det *moo_prepare(const cpl_frame *rawframe,
                     const char *const badpixmask_rp,
                     const char *const badpixmask_nl,
                     const cpl_frame *masterbias,
                     const cpl_frame *cube_frame,
                     moo_prepare_params *params);
moo_det *moo_prepare_adu(const cpl_frame *rawframe,
                         const char *const badpixmask_rp,
                         moo_prepare_params *params);
#endif
