/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_QC_H
#define MOO_QC_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "moo_detector.h"
#define MOONS_QC_FRAME_RAW1   "ESO QC FRAME RAW1"
#define MOONS_QC_FRAME_RAW1_C "Raw frame used in product"

#define MOONS_QC_FRAME_RAW2   "ESO QC FRAME RAW2"
#define MOONS_QC_FRAME_RAW2_C "Raw frame used in product"

#define MOONS_QC_CRH_NUMBER   "ESO QC NCRH"
#define MOONS_QC_CRH_NUMBER_C "Number of detected cosmic ray hits"

#define MOONS_QC_CRH_TOT      "ESO QC NCRH TOT"
#define MOONS_QC_CRH_TOT_C    "Total number of detected cosmic ray hits"

#define MOONS_QC_CRH_AVG      "ESO QC NCRH AVG"
#define MOONS_QC_CRH_AVG_C    "Average number of cosmic ray hits per frame"

#define MOONS_QC_NCOM         "ESO QC NCOM"
#define MOONS_QC_NCOM_C       "Number of combined frames"

#define MOONS_QC_MBIAS_AVG    "ESO QC MBIAS OUT%d AVG"
#define MOONS_QC_MBIAS_AVG_C \
    "Average value of the master BIAS (excluding bad pixels)"

#define MOONS_QC_MBIAS_MED "ESO QC MBIAS OUT%d MED"
#define MOONS_QC_MBIAS_MED_C \
    "Median value of the master BIAS (excluding bad pixels)"

#define MOONS_QC_MBIAS_RMS "ESO QC MBIAS OUT%d RMS"
#define MOONS_QC_MBIAS_RMS_C \
    "RMS value of the master BIAS (excluding bad pixels)"

#define MOONS_QC_MBIAS_MAD "ESO QC MBIAS OUT%d MAD"
#define MOONS_QC_MBIAS_MAD_C \
    "MAD value of the master BIAS (excluding bad pixels)"

#define MOONS_QC_RON_RAW                  "ESO QC OUT%d RON RAW"
#define MOONS_QC_RON_RAW_C                "Read Out Noise in raw"

#define MOONS_QC_RON_MASTER               "ESO QC OUT%d RON MASTER"
#define MOONS_QC_RON_MASTER_C             "Read Out Noise in master"

#define MOONS_QC_MDARK_NHOT               "ESO QC NHPIX"
#define MOONS_QC_MDARK_NHOT_C             "Number of hot pixels"

#define MOONS_QC_MDARK_NORMALISE_FACTOR   "ESO QC MDARK NORMALISE FACTOR"
#define MOONS_QC_MDARK_NORMALISE_FACTOR_C "Normalisation factor of master dark"

#define MOONS_QC_MDARK_AVG                "ESO QC MDARK AVG"
#define MOONS_QC_MDARK_AVG_C \
    "Average value of the master DARK (excluding bad pixels)"

#define MOONS_QC_MDARK_MED "ESO QC MDARK MED"
#define MOONS_QC_MDARK_MED_C \
    "Median value of the master DARK (excluding bad pixels)"

#define MOONS_QC_MDARK_RMS "ESO QC MDARK RMS"
#define MOONS_QC_MDARK_RMS_C \
    "RMS value of the master DARK (excluding bad pixels)"

#define MOONS_QC_MDARK_CURRENT   "ESO QC MEAN DARK CURRENT"
#define MOONS_QC_MDARK_CURRENT_C "[ADU/h] Mean dark current"

#define MOONS_QC_RESIDY_MED      "ESO QC RESIDY MED"
#define MOONS_QC_RESIDY_MED_C                     \
    "Median of residuals between polynomial fit " \
    "and measured centroids"

#define MOONS_QC_RESIDY_AVG "ESO QC RESIDY AVG"
#define MOONS_QC_RESIDY_AVG_C                            \
    "Average value of residuals between polynomial fit " \
    "and measured centroids"

#define MOONS_QC_RESIDY_SD "ESO QC RESIDY SD"
#define MOONS_QC_RESIDY_SD_C                   \
    "Standard deviation of residuals between " \
    "polynomial fit and measured centroids"

#define MOONS_QC_WIDTHY_MED "ESO QC WIDTHY MED"
#define MOONS_QC_WIDTHY_MED_C         \
    "Median of width polynomial fit " \
    "and measured centroids"

#define MOONS_QC_WIDTHY_AVG "ESO QC WIDTHY AVG"
#define MOONS_QC_WIDTHY_AVG_C          \
    "Average of width polynomial fit " \
    "and measured centroids"

#define MOONS_QC_WIDTHY_SD      "ESO QC WIDTHY SD"
#define MOONS_QC_WIDTHY_SD_C    "Standard deviation of width polynomial fit"

#define MOONS_QC_FIT_DEG        "ESO QC FIT DEG"
#define MOONS_QC_FIT_DEG_C      "Degree of polynomial fit"

#define MOONS_QC_NOUTLIER_PTS   "ESO QC NOUTLIER PTS"
#define MOONS_QC_NOUTLIER_PTS_C "Number of outliers using ydiff"

#define MOONS_QC_NOUTLIER_WID   "ESO QC NOUTLIER WID"
#define MOONS_QC_NOUTLIER_WID_C "Number of outliers using wdiff"

#define MOONS_QC_NBADPROFILE    "ESO QC NBADPROFILE"
#define MOONS_QC_NBADPROFILE_C  "Number of bad profile"

#define MOONS_QC_NBADPIX        "ESO QC NBADPIX"
#define MOONS_QC_NBADPIX_C      "Number of bad pixels"

#define MOONS_QC_SHIFTY_PTS_MED "ESO QC SHIFTY PTS MED"
#define MOONS_QC_SHIFTY_PTS_MED_C \
    "Median shift between trace and guess measured centroids"

#define MOONS_QC_SHIFTY_PTS_AVG "ESO QC SHIFTY PTS AVG"
#define MOONS_QC_SHIFTY_PTS_AVG_C \
    "Average shift between trace and guess measured centroids"

#define MOONS_QC_SHIFTY_PTS_SD "ESO QC SHIFTY PTS SD"
#define MOONS_QC_SHIFTY_PTS_SD_C \
    "Standard deviation shift between trace and guess measured centroids"

#define MOONS_QC_SHIFTY_FIT_MED "ESO QC SHIFTY FIT MED"
#define MOONS_QC_SHIFTY_FIT_MED_C \
    "Median shift between trace and guess fitted centroids"

#define MOONS_QC_SHIFTY_FIT_AVG "ESO QC SHIFTY FIT AVG"
#define MOONS_QC_SHIFTY_FIT_AVG_C \
    "Average shift between trace and guess fitted centroids"

#define MOONS_QC_SHIFTY_FIT_SD "ESO QC SHIFTY FIT SD"
#define MOONS_QC_SHIFTY_FIT_SD_C \
    "Standard deviation shift between trace and guess fitted centroids"

#define MOONS_QC_NMISSINGFIB      "ESO QC NMISSINGFIB"
#define MOONS_QC_NMISSINGFIB_C    "Number of missing fibres"

#define MOONS_QC_MISSINGFIB       "ESO QC MISSINGFIB%d"
#define MOONS_QC_MISSINGFIB_C     "Id of missing fibre"

#define MOONS_QC_P2P_MIN          "ESO QC P2P MIN"
#define MOONS_QC_P2P_MIN_C        "Minimum value of the P2P"

#define MOONS_QC_P2P_MAX          "ESO QC P2P MAX"
#define MOONS_QC_P2P_MAX_C        "Maximum value of the P2P"

#define MOONS_QC_P2P_AVG          "ESO QC P2P AVG"
#define MOONS_QC_P2P_AVG_C        "Average value of the P2P"

#define MOONS_QC_P2P_MED          "ESO QC P2P MED"
#define MOONS_QC_P2P_MED_C        "Median value of the P2P"

#define MOONS_QC_P2P_MAD          "ESO QC P2P MAD"
#define MOONS_QC_P2P_MAD_C        "MAD value of the P2P"

#define MOONS_QC_P2P_RMS          "ESO QC P2P RMS"
#define MOONS_QC_P2P_RMS_C        "RMS value of the P2P"

#define MOONS_QC_DETECT_NOISEMULT "ESO QC DETECT NOISEMULT"
#define MOONS_QC_DETECT_NOISEMULT_C \
    "Mult background noise factor kappa to detect fibres"
#define MOONS_QC_MFLAT_MIN       "ESO QC MFLAT MIN"
#define MOONS_QC_MFLAT_MIN_C     "Minimum value of the extracted flat"

#define MOONS_QC_MFLAT_MAX       "ESO QC MFLAT MAX"
#define MOONS_QC_MFLAT_MAX_C     "Maximum value of the extracted flat"

#define MOONS_QC_MFLAT_AVG       "ESO QC MFLAT AVG"
#define MOONS_QC_MFLAT_AVG_C     "Average value of the extracted flat"

#define MOONS_QC_MFLAT_MED       "ESO QC MFLAT MED"
#define MOONS_QC_MFLAT_MED_C     "Median value of the extracted flat"

#define MOONS_QC_MFLAT_RMS       "ESO QC MFLAT RMS"
#define MOONS_QC_MFLAT_RMS_C     "RMS value of the extracted flat"

#define MOONS_QC_MFLAT_SN_MIN    "ESO QC MFLAT SN MIN"
#define MOONS_QC_MFLAT_SN_MIN_C  "Minimum SNR in the extracted flats"

#define MOONS_QC_MFLAT_SN_MAX    "ESO QC MFLAT SN MAX"
#define MOONS_QC_MFLAT_SN_MAX_C  "Maximum SNR in the extracted flats"

#define MOONS_QC_MFLAT_SN_MED    "ESO QC MFLAT SN MED"
#define MOONS_QC_MFLAT_SN_MED_C  "Median SNR in the extracted flats"

#define MOONS_QC_FIBTRANS_MIN    "ESO QC FIBTRANS %s MIN"
#define MOONS_QC_FIBTRANS_MIN_C  "Minimum fibre relative transmission value"

#define MOONS_QC_FIBTRANS_MAX    "ESO QC FIBTRANS %s MAX"
#define MOONS_QC_FIBTRANS_MAX_C  "Maximum fibre relative transmission value"

#define MOONS_QC_FIBTRANS_MED    "ESO QC FIBTRANS %s MED"
#define MOONS_QC_FIBTRANS_MED_C  "Median fibre relative transmission value"

#define MOONS_QC_FIBTRANS_REF    "ESO QC SPECTRO%d FIBTRANS REF"
#define MOONS_QC_FIBTRANS_REF_C  "Reference fibre index for spectrograph %d"

#define MOONS_QC_WAVECAL_CATLINE "ESO QC WAVECAL CATLINE"
#define MOONS_QC_WAVECAL_CATLINE_C \
    "Number of catalog lines in the considered range"

#define MOONS_QC_WAVECAL_DETECTLINE   "ESO QC WAVECAL DETECTLINE"
#define MOONS_QC_WAVECAL_DETECTLINE_C "Total number of detected peaks"

#define MOONS_QC_WAVECAL_FAILEDFIT    "ESO QC WAVECAL FAILEDFIT"
#define MOONS_QC_WAVECAL_FAILEDFIT_C  "Total number of failed fitted peaks"

#define MOONS_QC_WAVECAL_FITLINE      "ESO QC WAVECAL FITLINE"
#define MOONS_QC_WAVECAL_FITLINE_C    "Total number of fitted peaks"

#define MOONS_QC_WAVECAL_MATCHLINE    "ESO QC WAVECAL MATCHLINE"
#define MOONS_QC_WAVECAL_MATCHLINE_C  "Total number of matched lines"

#define MOONS_QC_WAVECAL_CLIPLINE     "ESO QC WAVECAL CLIPLINE"
#define MOONS_QC_WAVECAL_CLIPLINE_C   "Total number of lines after sigma clip"

#define MOONS_QC_WAVECAL_MONOTONOUS_SOLUTION \
    "ESO QC WAVECAL MONOTONOUS SOLUTION"
#define MOONS_QC_WAVECAL_MONOTONOUS_SOLUTION_C \
    "True if the wavemap is monotonous"

#define MOONS_QC_WAVE_MIN                "ESO QC WAVE MIN"
#define MOONS_QC_WAVE_MIN_C              "Minimum of wavelength in wavemap"
#define MOONS_QC_WAVE_MAX                "ESO QC WAVE MAX"
#define MOONS_QC_WAVE_MAX_C              "Maximum of wavelength in wavemap"

#define MOONS_QC_WAVECAL_VALIDFIBRE      "ESO QC WAVECAL VALIDFIBRE"
#define MOONS_QC_WAVECAL_VALIDFIBRE_C    "Number of valid fibres"

#define MOONS_QC_WAVECAL_DISP_MIN        "ESO QC WAVECAL DISP MIN"
#define MOONS_QC_WAVECAL_DISP_MIN_C      "[nm/pix] minimum measured dispersion"

#define MOONS_QC_WAVECAL_DISP_MAX        "ESO QC WAVECAL DISP MAX"
#define MOONS_QC_WAVECAL_DISP_MAX_C      "[nm/pix] maximum measured dispersion"

#define MOONS_QC_WAVECAL_RESOL_MED       "ESO QC WAVECAL RESOL MED"
#define MOONS_QC_WAVECAL_RESOL_MED_C     "median resolution"

#define MOONS_QC_WAVECAL_RESIDWAVE_MED   "ESO QC WAVECAL RESIDWAVE MED"
#define MOONS_QC_WAVECAL_RESIDWAVE_MED_C "[nm] median residual"

#define MOONS_QC_WAVECAL_RESIDWAVE_STD   "ESO QC WAVECAL RESIDWAVE STD"
#define MOONS_QC_WAVECAL_RESIDWAVE_STD_C "[nm] residual dispersion"

#define MOONS_QC_SNR_RANGE               "ESO QC SNR RANGE"
#define MOONS_QC_SNR_RANGE_C             "pixels range where we compute snr"
#define MOONS_QC_SNR_RANGE_FULL          "FULL"
#define MOONS_QC_SNR_RANGE_OHFREEZONE    "OHFREEZONE"

#define MOONS_QC_IS_LINEARCOR            "ESO QC IS LINEARCOR"
#define MOONS_QC_IS_LINEARCOR_C          "TRUE if is corrected from linearity"
#define MOONS_QC_IS_P2PCOR               "ESO QC IS P2PCOR"
#define MOONS_QC_IS_P2PCOR_C             "TRUE if is corrected from P2P"
#define MOONS_QC_IS_TELLCOR              "ESO QC IS TELLCOR"
#define MOONS_QC_IS_TELLCOR_C            "TRUE if is corrected from telluric"

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code moo_qc_set_frame_raw1(cpl_propertylist *plist, const char *name);
cpl_error_code moo_qc_set_frame_raw2(cpl_propertylist *plist, const char *name);

cpl_error_code moo_qc_set_ncrh(cpl_propertylist *plist, int ncrh);
cpl_error_code moo_qc_set_ncrh_avg(cpl_propertylist *plist, float ncrh);
cpl_error_code moo_qc_set_ncrh_tot(cpl_propertylist *plist, int ncrh);
cpl_error_code moo_qc_set_ncom(cpl_propertylist *plist, int nb);
int moo_qc_get_ncom(cpl_propertylist *plist);

cpl_error_code moo_qc_set_mbias_avg(cpl_propertylist *plist, int i, double val);
cpl_error_code moo_qc_set_mbias_med(cpl_propertylist *plist, int i, double val);
cpl_error_code moo_qc_set_mbias_rms(cpl_propertylist *plist, int i, double val);
cpl_error_code moo_qc_set_mbias_mad(cpl_propertylist *plist, int i, double val);
cpl_error_code moo_qc_set_ron_raw(cpl_propertylist *plist, int i, double val);
cpl_error_code
moo_qc_set_ron_master(cpl_propertylist *plist, int i, double val);

cpl_error_code moo_qc_set_mdark_nhot(cpl_propertylist *plist, int val);
cpl_error_code
moo_qc_set_mdark_normalise_factor(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mdark_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mdark_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mdark_rms(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mdark_current(cpl_propertylist *plist, double val);


cpl_error_code moo_qc_set_widthy_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_widthy_sd(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_widthy_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_residy_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_residy_sd(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_residy_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_fit_deg(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_noutlier_pts(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_noutlier_wid(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_nbadprofile(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_nbadpix(cpl_propertylist *plist, int val);

cpl_error_code moo_qc_set_shifty_pts_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_shifty_pts_sd(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_shifty_pts_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_shifty_fit_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_shifty_fit_sd(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_shifty_fit_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_nmissingfib(cpl_propertylist *plist, int val);
cpl_error_code
moo_qc_set_missingfib(cpl_propertylist *plist, int num, const char *name);

cpl_error_code moo_qc_set_p2p_min(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_p2p_max(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_p2p_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_p2p_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_p2p_mad(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_p2p_rms(cpl_propertylist *plist, double val);

cpl_error_code
moo_qc_set_qc_detect_noisemult(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_min(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_max(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_avg(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_med(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_rms(cpl_propertylist *plist, double val);

cpl_error_code moo_qc_set_mflat_sn_min(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_sn_max(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_mflat_sn_med(cpl_propertylist *plist, double val);

cpl_error_code
moo_qc_set_fibtrans_ref(cpl_propertylist *plist, int ntas, int val);
cpl_error_code moo_qc_set_fibtrans_min(cpl_propertylist *plist,
                                       moo_detector_type type,
                                       double val);
cpl_error_code moo_qc_set_fibtrans_max(cpl_propertylist *plist,
                                       moo_detector_type type,
                                       double val);
cpl_error_code moo_qc_set_fibtrans_med(cpl_propertylist *plist,
                                       moo_detector_type type,
                                       double val);

cpl_error_code moo_qc_set_wavecal_catline(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_detectline(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_failedfit(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_fitline(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_matchline(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_clipline(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wave_min(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_wave_max(cpl_propertylist *plist, double val);
cpl_error_code
moo_qc_set_wavecal_monotonous_solution(cpl_propertylist *plist, int val);

cpl_error_code moo_qc_set_wavecal_validfibre(cpl_propertylist *plist, int val);
cpl_error_code moo_qc_set_wavecal_disp_min(cpl_propertylist *plist, double val);
cpl_error_code moo_qc_set_wavecal_disp_max(cpl_propertylist *plist, double val);
cpl_error_code
moo_qc_set_wavecal_resol_med(cpl_propertylist *plist, double val);
cpl_error_code
moo_qc_set_wavecal_residwave_med(cpl_propertylist *plist, double val);
cpl_error_code
moo_qc_set_wavecal_residwave_std(cpl_propertylist *plist, double val);

cpl_error_code moo_qc_set_snr_range(cpl_propertylist *plist, const char *range);

cpl_error_code
moo_qc_set_is_linearcor(cpl_propertylist *plist, cpl_boolean val);
cpl_error_code moo_qc_set_is_p2pcor(cpl_propertylist *plist, cpl_boolean val);
cpl_error_code moo_qc_set_is_tellcor(cpl_propertylist *plist, cpl_boolean val);

#endif
