/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_RBN_H
#define MOO_RBN_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_rbn_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    moo_rbn_single *ri;
    moo_rbn_single *yj;
    moo_rbn_single *h;
    cpl_table *fibre_table;
} moo_rbn;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_rbn *moo_rbn_new(void);
moo_rbn *moo_rbn_create(const cpl_frame *frame);
cpl_propertylist *moo_rbn_get_primary_header(moo_rbn *self);
void moo_rbn_delete(moo_rbn *self);
cpl_error_code moo_rbn_set_single(moo_rbn *self, moo_rbn_single *s);
cpl_error_code
moo_rbn_add_single(moo_rbn *self, moo_detector_type type, moo_rbn_single *s);
void moo_rbn_save(moo_rbn *self, const char *filename);
cpl_error_code moo_rbn_add_fibre_table(moo_rbn *self, cpl_table *fibre_table);
moo_rbn_single *moo_rbn_get_single(moo_rbn *self, moo_detector_type type);
moo_rbn_single *
moo_rbn_load_single(moo_rbn *self, moo_detector_type type, unsigned int level);
cpl_error_code moo_rbn_free_single(moo_rbn *self, moo_detector_type type);

cpl_table *moo_rbn_get_fibre_table(moo_rbn *self);
cpl_error_code moo_rbn_compute_snr(moo_rbn *self, moo_sky_lines_list *skylines);
cpl_error_code moo_rbn_dump(const moo_rbn *self, FILE *stream);
#endif
