/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more rbnails.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_RBNLIST_H
#define MOO_RBNLIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_rbn.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    moo_rbn **list;
    cpl_size size;
} moo_rbnlist;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_rbnlist *moo_rbnlist_new(void);
moo_rbnlist *moo_rbnlist_create(const cpl_frameset *frameset);
cpl_size moo_rbnlist_get_size(const moo_rbnlist *self);

cpl_error_code moo_rbnlist_set(moo_rbnlist *self, moo_rbn *rbn, cpl_size pos);
cpl_error_code moo_rbnlist_push(moo_rbnlist *self, moo_rbn *rbn);

moo_rbn *moo_rbnlist_unset(moo_rbnlist *self, cpl_size pos);
void moo_rbnlist_empty(moo_rbnlist *self);
void moo_rbnlist_delete(moo_rbnlist *self);
moo_rbn *moo_rbnlist_get(moo_rbnlist *self, int i);

cpl_error_code moo_rbnlist_load_single(const moo_rbnlist *self,
                                       moo_detector_type type,
                                       int level);
cpl_error_code
moo_rbnlist_free_single(const moo_rbnlist *self, moo_detector_type type);

hdrl_imagelist *
moo_rbnlist_get_image(const moo_rbnlist *self, moo_detector_type type);

cpl_imagelist *
moo_rbnlist_get_single_data(const moo_rbnlist *self, moo_detector_type type);
cpl_imagelist *
moo_rbnlist_get_single_qual(const moo_rbnlist *self, moo_detector_type type);
#endif
