/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SATURATE_MAP_H
#define MOO_SATURATE_MAP_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define MOO_SATURATE_MAP_INDEX "INDEX"
#define MOO_SATURATE_MAP_FLUX  "FLUX"
#define MOO_SATURATE_MAP_ERR   "ERR"
#define MOO_SATURATE_MAP_TIME  "TIME"

typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_propertylist *data_header[6];
    cpl_image *data[6];
    cpl_image *flux[6];
    cpl_image *err[6];
    cpl_image *exptime[6];
} moo_saturate_map;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_saturate_map *moo_saturate_map_new(void);
moo_saturate_map *moo_saturate_map_load(const cpl_frame *mapframe);
cpl_error_code moo_saturate_map_set_data(moo_saturate_map *self,
                                         moo_detector_type type,
                                         int ntas,
                                         cpl_image *data,
                                         cpl_image *flux,
                                         cpl_image *err,
                                         cpl_image *exptime,
                                         cpl_propertylist *header);
cpl_error_code moo_saturate_map_add_data(moo_saturate_map *self,
                                         cpl_image *data,
                                         cpl_image *flux,
                                         cpl_image *err,
                                         cpl_image *exptime,
                                         moo_detector_type type,
                                         int ntas);
void moo_saturate_map_save(moo_saturate_map *self, const char *filename);
void moo_saturate_map_delete(moo_saturate_map *self);
#endif
