/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SCI_H
#define MOO_SCI_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_sci_single.h"
#include "moo_detector.h"
#include "moo_sky_lines_list.h"
#include "moo_params.h"
#include "moo_target_table.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    moo_sci_single *ri;
    moo_sci_single *yj;
    moo_sci_single *h;
    moo_target_table *target_table;
} moo_sci;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_sci *moo_sci_new(void);
void moo_sci_delete(moo_sci *self);
cpl_error_code
moo_sci_add_target_table(moo_sci *self, moo_target_table *fibre_table);
cpl_error_code moo_sci_set_single(moo_sci *self, moo_sci_single *s);
cpl_error_code
moo_sci_add_single(moo_sci *self, moo_detector_type type, moo_sci_single *s);

moo_target_table *moo_sci_get_target_table(moo_sci *sci);
moo_sci *moo_sci_create(const cpl_frame *frame);
cpl_error_code moo_sci_load(moo_sci *self, unsigned int level);
moo_sci_single *
moo_sci_load_single(moo_sci *self, moo_detector_type type, int level);
moo_sci_single *moo_sci_get_single(moo_sci *self, moo_detector_type type);
void moo_sci_save(moo_sci *self, const char *filename);
cpl_error_code moo_sci_compute_snr(moo_sci *self, moo_sky_lines_list *skylines);

#endif
