/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SCI_SINGLE_H
#define MOO_SCI_SINGLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
#include "moo_target_table.h"
#include "moo_sky_lines_list.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    const char *extname;
    cpl_propertylist *header;
    hdrl_image *image;
    cpl_image *qual;
    unsigned int badpix_mask;
    moo_detector_type type;
    cpl_image *sky;
} moo_sci_single;

#define MOO_SCI_SINGLE_BUNIT     "counts"
#define MOO_SCI_SINGLE_DATA_TYPE CPL_TYPE_FLOAT
#define MOO_SCI_SINGLE_ERR       "ERR"
#define MOO_SCI_SINGLE_ERR_TYPE  CPL_TYPE_FLOAT
#define MOO_SCI_SINGLE_QUAL      "QUAL"
#define MOO_SCI_SINGLE_QUAL_TYPE CPL_TYPE_INT
#define MOO_SCI_SINGLE_SKY       "SKY"

#define MOO_SCI_SINGLE_CRPIX2 1
#define MOO_SCI_SINGLE_CRVAL2 1
#define MOO_SCI_SINGLE_CDELT2 1.0
#define MOO_SCI_SINGLE_CTYPE2 "INDEX"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_sci_single *moo_sci_single_new(moo_detector_type type);
void moo_sci_single_delete(moo_sci_single *self);
void moo_sci_single_save(moo_sci_single *self,
                         const char *filename,
                         moo_detector_type type);

moo_sci_single *
moo_sci_single_create(const char *filename, moo_detector_type type);

cpl_error_code moo_sci_single_load(moo_sci_single *self, unsigned int level);
cpl_propertylist *moo_sci_single_get_header(moo_sci_single *self);
hdrl_image *moo_sci_single_get_image(moo_sci_single *self);
cpl_image *moo_sci_single_get_sky(moo_sci_single *self);
cpl_image *moo_sci_single_get_qual(moo_sci_single *self);
double moo_sci_single_compute_snr(moo_sci_single *self,
                                  int targ_idx,
                                  moo_sky_lines_list *skylines);
#endif
