/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SCILIST_H
#define MOO_SCILIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_sci.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */
typedef struct
{
    moo_sci **list;
    cpl_size size;
} moo_scilist;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_scilist *moo_scilist_new(void);
moo_scilist *moo_scilist_create(cpl_frameset *frameset);
moo_scilist *moo_scilist_create_clean(cpl_frameset *frameset);
cpl_size moo_scilist_get_size(const moo_scilist *self);

cpl_error_code moo_scilist_set(moo_scilist *self, moo_sci *sci, cpl_size pos);

cpl_error_code moo_scilist_push(moo_scilist *self, moo_sci *sci);

void moo_scilist_delete(moo_scilist *self);

void moo_scilist_empty(moo_scilist *self);

moo_sci *moo_scilist_unset(moo_scilist *self, cpl_size pos);

moo_sci *moo_scilist_get(moo_scilist *self, int i);
moo_sci_single *
moo_scilist_get_single(moo_scilist *self, int i, moo_detector_type type);

cpl_error_code moo_scilist_load_single(const moo_scilist *self,
                                       moo_detector_type type,
                                       int level);

hdrl_imagelist *
moo_scilist_get_image(const moo_scilist *self, moo_detector_type type);

cpl_imagelist *
moo_scilist_get_sky(const moo_scilist *self, moo_detector_type type);
cpl_imagelist *
moo_scilist_get_qual(const moo_scilist *self, moo_detector_type type);
/*
cpl_error_code moo_detlist_free_single(const moo_detlist * self,
        moo_detector_type type, int num);



cpl_imagelist* moo_detlist_get_single_data(const moo_detlist * self,
        moo_detector_type type, int num);
cpl_imagelist* moo_detlist_get_single_qual(const moo_detlist * self,
        moo_detector_type type, int num);
 */
#endif
