/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SPECTRAL_FORMAT_H
#define MOO_SPECTRAL_FORMAT_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_loc_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define ARM_COLNAME       "ARM"
#define MODE_COLNAME      "MODE"
#define WMIN_COLNAME      "WAVEMIN"
#define WMAX_COLNAME      "WAVEMAX"
#define RES_COLNAME       "RESOLUTION"
#define DISPMIN_COLNAME   "DISPMIN"
#define DISPMAX_COLNAME   "DISPMAX"
#define DIRECTION_COLNAME "DIRECTION"

#define MODE_LR "LR"
#define MODE_HR "HR"

typedef struct
{
    double wmin;
    double wmax;
    double resolution;
    double dispmin;
    double dispmax;
    int direction;
} moo_spectral_format_info;

typedef struct
{
    moo_mode_type mode;
    cpl_table *table;

} moo_spectral_format;


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_spectral_format *moo_spectral_format_new(void);

moo_spectral_format *
moo_spectral_format_load(const cpl_frame *frame, moo_mode_type mode);

moo_spectral_format_info *moo_spectral_format_get(moo_spectral_format *self,
                                                  moo_detector_type type,
                                                  int ntas);

cpl_error_code moo_spectral_format_get_wave_range(moo_spectral_format *self,
                                                  moo_detector_type type,
                                                  double *min,
                                                  double *max);

void moo_spectral_format_delete(moo_spectral_format *self);
void moo_spectral_format_info_delete(moo_spectral_format_info *self);
#endif
