/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_TELLURIC_H
#define MOO_TELLURIC_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_scilist.h"
/**
 * @ingroup moo_telluric
 *
 * @brief TELLURIC format
 */

#define MOO_TELLURIC_EXT_RI "RI"
#define MOO_TELLURIC_EXT_YJ "YJ"
#define MOO_TELLURIC_EXT_H "H"
#define MOO_TELLURIC_EXT_STANDARD_TABLE "STANDARD_TABLE"
#define MOO_TELLURIC_TABLE_INDEXRBN "INDEXRBN"
#define MOO_TELLURIC_TABLE_SPECTRO "SPECTRO"
#define MOO_TELLURIC_TABLE_BAND "BAND"
#define MOO_TELLURIC_TABLE_TELLURIC "TELLURIC"
#define MOO_TELLURIC_WAVE "WAVE"
#define MOO_TELLURIC_TELLURIC "TELLURIC"

typedef struct
{
    cpl_propertylist *primary_header;
    cpl_image *data[3];
    cpl_propertylist *data_header[3];
    cpl_table *telluric_table;
} moo_telluric;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_telluric *moo_telluric_new(void);
moo_telluric *moo_telluric_create(moo_scilist *scilist, int badpix_level);
moo_telluric *moo_telluric_create_from_rbn(moo_rbn *rbn);
void moo_telluric_delete(moo_telluric *telluric);
cpl_error_code moo_telluric_set_image(moo_telluric *self,
                                      moo_detector_type type,
                                      cpl_image *t);
cpl_error_code moo_telluric_set_header(moo_telluric *self,
                                       moo_detector_type type,
                                       cpl_propertylist *t);
cpl_image *moo_telluric_get_image(moo_telluric *self, moo_detector_type type);
int moo_telluric_get_index(moo_telluric *self,
                           int idrbn,
                           int spectro,
                           const char *band);
void moo_telluric_save(moo_telluric *self, const char *filename);
moo_telluric *moo_telluric_load(const cpl_frame *frame);
const char *moo_telluric_get_band(moo_detector_type type);
#endif
