/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>

#include <stdlib.h>
#include <stdio.h>

#include "moo_det.h"
#include "moo_apply_p2p.h"
#include "moo_params.h"

char *
path_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", DATA_DIR, name);
}

char *
result_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", RESULT_DIR, name);
}
/*----------------------------------------------------------------------------*/
/**
 * @defgroup drl_functions appy_p2p test
        Testing of functions used in moo_appy_p2p
 */
/*----------------------------------------------------------------------------*/

void
_moo_apply_p2p_test(void)
{
    char *filename = path_from_filename("FLAT_CORRECTDARK_OFFSET1_LR_0.fits");
    char *p2pname = path_from_filename("P2P_MAP_LR.fits");
    cpl_frame *frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_frame_set_tag(frame, "TAG");
    cpl_frame_set_group(frame, CPL_FRAME_GROUP_PRODUCT);
    moo_det *det = moo_det_create(frame);

    cpl_frame *p2pframe = cpl_frame_new();
    cpl_frame_set_filename(p2pframe, p2pname);
    cpl_frame_set_tag(p2pframe, "TAG");
    cpl_frame_set_group(p2pframe, CPL_FRAME_GROUP_PRODUCT);
    moo_det *p2p = moo_det_create(p2pframe);

    moo_apply_p2p(det, p2p);
    char *res = result_from_filename("DET_FLAT_APPLYP2P.fits");
    moo_det_save(det, res);
    cpl_free(res);

    moo_det_delete(det);
    moo_det_delete(p2p);

    cpl_frame_delete(frame);
    cpl_frame_delete(p2pframe);

    cpl_free(filename);
    cpl_free(p2pname);
}


/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests
 **/
/*----------------------------------------------------------------------------*/
int
main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);
    _moo_apply_p2p_test();
    return cpl_test_end(0);
}
