/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>
#include <hdrl.h>
#include "moo_rbn.h"
#include "moo_rbnlist.h"
#include "moo_combine_sky.h"
#include <moo_drl.h>
#include <moo_dfs.h>
#include "moo_testbed_utils.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup moons_prepare_test  Unit test of moons_prepare
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/


/*----------------------------------------------------------------------------*/
/**
  @brief    Unit test of moons_dfs_set_groups
 */
/*----------------------------------------------------------------------------*/

char *
path_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", DATA_DIR, name);
}

char *
result_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", RESULT_DIR, name);
}


static void
_moons_test_combine_sky(void)
{
    cpl_frameset *frameset = cpl_frameset_new();
    moo_rbn *res = NULL;
    char *resname = NULL;

    for (int i = 0; i <= 1; i++) {
        char *name =
            cpl_sprintf("STARENOD_SKY_RBNSPECTRA_OFFSET1_HR_%d.fits", i);
        char *filename = path_from_filename(name);
        cpl_frame *frame = cpl_frame_new();
        cpl_frame_set_filename(frame, filename);
        cpl_frame_set_tag(frame, "TAG");
        cpl_frame_set_group(frame, CPL_FRAME_GROUP_PRODUCT);
        cpl_frameset_insert(frameset, frame);

        cpl_free(name);
        cpl_free(filename);
    }

    moo_rbnlist *rbnlist = moo_rbnlist_create(frameset);


    res = moo_combine_sky(rbnlist);

    resname = result_from_filename("SKY_median.fits");
    moo_rbn_save(res, resname);

    moo_rbn_delete(res);
    cpl_free(resname);
    moo_rbnlist_delete(rbnlist);

    cpl_frameset_delete(frameset);

    return;
}

/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of moons_dfs module
 */
/*----------------------------------------------------------------------------*/

int
main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);
    _moons_test_combine_sky();

    return cpl_test_end(0);
}

/**@}*/
