/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>

#include <stdlib.h>
#include <stdio.h>

#include "moo_ext.h"
#include "moo_f2f.h"
#include "moo_params.h"
#include "moo_compute_fibtrans.h"

char *
path_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", DATA_DIR, name);
}

char *
result_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", RESULT_DIR, name);
}

/*----------------------------------------------------------------------------*/
/**
 * @defgroup drl_functions compute fibre transmission test
        Testing of functions used in moo_compute_fibtrans
 */
/*----------------------------------------------------------------------------*/

void
_moo_compute_fibtrans_lr_test(void)
{
    moo_f2f *f2f = NULL;
    char *filename = path_from_filename("EXT_OFFSET0_LR.fits");

    cpl_frame *extframe = cpl_frame_new();
    cpl_frame_set_filename(extframe, filename);
    cpl_frame_set_tag(extframe, "TAG");
    cpl_frame_set_group(extframe, CPL_FRAME_GROUP_PRODUCT);

    moo_ext *ext = moo_ext_create(extframe);

    moo_compute_fibtrans_params *params = moo_compute_fibtrans_params_new();
    params->fibref[0] = 506;
    params->fibref[1] = 513;

    char *resname = result_from_filename("F2F_OFFSET0_LR.fits");
    f2f = moo_compute_fibtrans(ext, params, resname);
    moo_f2f_save(f2f, resname);
    cpl_free(resname);

    char *resname2 = result_from_filename("EXT_normalized.fits");
    moo_ext_save(ext, resname2);
    cpl_free(resname2);

    moo_f2f_delete(f2f);
    moo_ext_delete(ext);
    moo_compute_fibtrans_params_delete(params);
    cpl_frame_delete(extframe);
    cpl_free(filename);
}

void
_moo_compute_fibtrans_offset1_hr(void)
{
    char *filename = path_from_filename("FLAT_EXTSPECTRA_OFFSET1_HR.fits");

    cpl_frame *extframe = cpl_frame_new();
    cpl_frame_set_filename(extframe, filename);
    cpl_frame_set_tag(extframe, "TAG");
    cpl_frame_set_group(extframe, CPL_FRAME_GROUP_PRODUCT);

    moo_ext *ext = moo_ext_create(extframe);
    moo_ext_single_delete(ext->ri[0]);
    ext->ri[0] = NULL;
    moo_ext_single_delete(ext->h[0]);
    ext->h[0] = NULL;
    moo_ext_single_delete(ext->h[1]);
    ext->h[1] = NULL;
    moo_compute_fibtrans_params *params = moo_compute_fibtrans_params_new();
    params->fibref[0] = 306;
    params->fibref[1] = 306;

    char *resname = result_from_filename("F2F_OFFSET1_HR.fits");
    moo_f2f *f2f = moo_compute_fibtrans(ext, params, resname);
    moo_f2f_save(f2f, resname);
    cpl_free(resname);

    char *resname2 = result_from_filename("ext_normalized_HR.fits");
    moo_ext_save(ext, resname2);
    cpl_free(resname2);

    moo_f2f_delete(f2f);
    moo_ext_delete(ext);
    moo_compute_fibtrans_params_delete(params);
    cpl_frame_delete(extframe);
    cpl_free(filename);
}

void
_moo_compute_fibtrans_test2(void)
{
    char *filename = path_from_filename("1/EXT_OFFSET0.fits");

    cpl_frame *extframe = cpl_frame_new();
    cpl_frame_set_filename(extframe, filename);
    cpl_frame_set_tag(extframe, "TAG");
    cpl_frame_set_group(extframe, CPL_FRAME_GROUP_PRODUCT);

    moo_ext *ext = moo_ext_create(extframe);

    moo_ext_single_delete(ext->yj[0]);
    ext->yj[0] = NULL;
    moo_ext_single_delete(ext->h[0]);
    ext->h[0] = NULL;

    moo_ext_single_delete(ext->ri[1]);
    ext->ri[1] = NULL;
    moo_ext_single_delete(ext->yj[1]);
    ext->yj[1] = NULL;
    moo_ext_single_delete(ext->h[1]);
    ext->h[1] = NULL;

    moo_compute_fibtrans_params *params = moo_compute_fibtrans_params_new();
    params->fibref[0] = 506;
    params->fibref[1] = 513;

    char *resname = result_from_filename("F2F.fits");
    moo_f2f *f2f = moo_compute_fibtrans(ext, params, resname);
    moo_f2f_save(f2f, resname);
    cpl_free(resname);

    char *resname2 = result_from_filename("ext_normalized.fits");
    moo_ext_save(ext, resname2);
    cpl_free(resname2);

    moo_f2f_delete(f2f);
    moo_ext_delete(ext);
    moo_compute_fibtrans_params_delete(params);
    cpl_frame_delete(extframe);
    cpl_free(filename);
}

void
_moo_compute_fibtrans_test3(void)
{
    char *filename = path_from_filename("2/EXT_OFFSET0.fits");

    cpl_frame *extframe = cpl_frame_new();
    cpl_frame_set_filename(extframe, filename);
    cpl_frame_set_tag(extframe, "TAG");
    cpl_frame_set_group(extframe, CPL_FRAME_GROUP_PRODUCT);

    moo_ext *ext = moo_ext_create(extframe);

    /*moo_ext_single_delete(ext->yj[0]);
    ext->yj[0] = NULL;
    moo_ext_single_delete(ext->h[0]);
    ext->h[0] = NULL;
    
    moo_ext_single_delete(ext->ri[1]);
    ext->ri[1] = NULL;
    moo_ext_single_delete(ext->yj[1]);
    ext->yj[1] = NULL;
    moo_ext_single_delete(ext->h[1]);
    ext->h[1] = NULL;
    */
    moo_compute_fibtrans_params *params = moo_compute_fibtrans_params_new();
    params->fibref[0] = 506;
    params->fibref[1] = 513;

    char *resname = result_from_filename("F2F.fits");
    moo_f2f *f2f = moo_compute_fibtrans(ext, params, resname);
    moo_f2f_save(f2f, resname);
    cpl_free(resname);

    char *resname2 = result_from_filename("ext_normalized.fits");
    moo_ext_save(ext, resname2);
    cpl_free(resname2);

    moo_f2f_delete(f2f);
    moo_ext_delete(ext);
    moo_compute_fibtrans_params_delete(params);
    cpl_frame_delete(extframe);
    cpl_free(filename);
}


/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests of hdrl_image module
 **/
/*----------------------------------------------------------------------------*/
int
main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    _moo_compute_fibtrans_offset1_hr();

    return cpl_test_end(0);
}
