/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/

#include "moo_sci.h"
#include "moo_scilist.h"

#include <cpl.h>

#include <stdlib.h>
#include <stdio.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup moo_scilist-test Test of SCI list
        Testing of functions working on Sci_list
 */
/*----------------------------------------------------------------------------*/

void test_get(void)
{
    moo_scilist * sl = NULL;
    cpl_test_eq(moo_scilist_get_size(sl), -1);
    cpl_test_error(CPL_ERROR_NULL_INPUT);
/**/
    sl = moo_scilist_new();
    cpl_test_eq(moo_scilist_get_size(sl), 0);
    cpl_test_error(CPL_ERROR_NONE);
    
    moo_scilist_push(sl, moo_sci_new());    
    cpl_test_eq(moo_scilist_get_size(sl), 1);    
    cpl_test_error(CPL_ERROR_NONE);    
    
    moo_scilist_push(sl, moo_sci_new());
    cpl_test_eq(moo_scilist_get_size(sl), 2);    
    cpl_test_error(CPL_ERROR_NONE);    

    moo_sci* sci = moo_scilist_unset(sl, 1);
    cpl_test_eq(moo_scilist_get_size(sl), 1);        
    cpl_test_error(CPL_ERROR_NONE);    
    moo_sci_delete(sci);
    
    moo_scilist_delete(sl);
}


/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests of hdrl_image module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    test_get();

    return cpl_test_end(0);
}
