/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_KERNEL_H
#define MF_KERNEL_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

#include "mf_constants.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

#define MF_KERNEL_USER_DIFF_LAMBDA_INI_TOL   1.e-4
#define MF_KERNEL_USER_DIFF_LAMBDA_DELTA_TOL 1.e-4

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* Resample and normalize the input kernel to the input spec */
MF_EXPORT cpl_matrix *mf_kernel_user_create(
    const cpl_size          spec_n_lambdas, /* Number of input spectrum lambdas                           */
    const cpl_propertylist *header_spec,    /* Header cpl_propertylist of the         input spectrum      */
    const cpl_propertylist *header_kernel,  /* Header cpl_propertylist of the kernel spectrum             */
    const cpl_matrix       *kernel
); /* Input Kernel matrix, one row per total input spectra pixel */

/*  */
MF_INTERNAL cpl_error_code mf_kernel_user(
    cpl_table        *spec,                      /*  */
    const cpl_matrix *kernel_resample_normalize, /*  */
    const cpl_array  *spec_rows_selected_to_convolve
); /*  */


CPL_END_DECLS


#endif /* MF_KERNEL_H */
