/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_SPECTRUM_H
#define MF_SPECTRUM_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

#include "mf_constants.h"
#include "mf_parameters.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* Create input spectrum from call telluriccorr */
MF_EXPORT cpl_table *mf_spectrum_create_input_to_correct(
    const cpl_table  *spectrum,
    const char       *column_lambda,
    const char       *column_flux,
    const char       *column_dflux,
    const char       *column_mask,
    const cpl_vector *telluric_corr
);

/* Create input spectrum from call telluriccorr */
MF_EXPORT cpl_table *mf_spectrum_create(mf_parameters_config *config, const cpl_table *spectrum);

/* Check ranges cpl_table */
MF_EXPORT cpl_error_code mf_spectrum_ranges_check(const cpl_table *spectrum, const cpl_table *table, const char *tag);

/* Create the telluriccorr internal cpl_table spectrum structure */
MF_INTERNAL cpl_table *mf_spectrum_ranges_apply(
    mf_parameters   *params,
    const cpl_table *spectrum,
    const cpl_table *inc_wranges,
    const cpl_table *exc_wranges,
    const cpl_table *exc_pranges
);

//PIPE_8582 Part 3
/*  */
cpl_error_code mf_spectrum_vacuum_to_air(const char *frame_type, const double obs_erf_rv, cpl_table *spectrum);
//PIPE-8582 Part 3 END


CPL_END_DECLS


#endif /* MF_SPECTRUM_H */
