/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_CALC_H
#define MF_WRAP_CALC_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include <telluriccorr.h>
/*#include <mf_wrap_fits.h>
#include <mf_wrap_data.h>
#include <mf_wrap_dfs.h>*/

#include "mf_wrap_utils.h"
#include "mf_wrap_config.h"
#include "mf_wrap_config_calc.h"


//#include "mf_constants.h" //?
//#include "mf_configuration.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code mf_wrap_calc_molecules(cpl_frameset *frameset, cpl_table **molecules, const char *arm);

cpl_error_code mf_wrap_calc_kernel_library(
    mf_wrap_fits               **kernel_data,
    cpl_table                  **mapping_kernel,
    cpl_frameset                *frameset,
    mf_wrap_calctrans_parameter *parameters,
    const char                  *arm
);

cpl_error_code mf_wrap_calc_mapping_atm(
    cpl_frameset                *frameset,
    cpl_table                  **mapping_atmospheric,
    mf_wrap_calctrans_parameter *parameters,
    const char                  *arm
);

cpl_error_code mf_wrap_calc_mapping_conv(
    cpl_frameset                *frameset,
    cpl_table                  **mapping_convolve,
    mf_wrap_calctrans_parameter *parameters,
    const char                  *arm
);

// mf_wrap_sciframe(cpl_frameset *frameset, const cpl_parameterlist  *parlist, mf_wrap_model_parameter *parameters); // DO WE NEED THIS ??


CPL_END_DECLS


#endif /* MF_WRAP_H */
