/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include "mf_wrap_config.h"
//#include "mf_parameters.h"


/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

//cpl_error_code mf_wrap_config_model_input_filenames(const char* suffix){
//        //cpl_msg_info(cpl_func,"mf_wrap_config_model_input_filenames");

//        cpl_error_code err = CPL_ERROR_NONE;
//        const char * suf;
//        if(!suffix) suf = "";
//        else suf = cpl_sprintf("_%s",suffix);

/*const char* tag = cpl_sprintf("GDAS%s",suf);
        cpl_frame* f = cpl_frameset_find(frameset,tag);
        if(!f){
            cpl_framedata* fd = cpl_framedata_create(tag,1,1);    
            f = cpl_frame_new();
        */


//TODO: REDO THIS SO THAT IT WORKS ON THE FRAMESET????
//after all, these are all from the SOF - which goes into the frameset

//set input file names to reflect the arm
/*        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("KERNEL_LIBRARY%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_MODEL_MAPPING_KERNEL));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("GDAS%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_GDAS));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("WAVE_INCLUDE%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_WAVE_INCLUDE));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("WAVE_EXCLUDE%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_WAVE_EXCLUDE));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("PIX_EXCLUDE%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_PIXEL_EXCLUDE));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("MOLECULES%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_MOLECULES));
        cpl_parameterlist_append(parlist,cpl_parameter_new_value(cpl_sprintf("ATM_PROFILE_STANDARD%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_ATM_PROFILE_STANDARD));
        */
/*cpl_propertylist_update_string(ilist,MOLECFIT_MODEL_MAPPING_KERNEL,cpl_sprintf("KERNEL_LIBRARY%s",suf));
        cpl_propertylist_update_string(ilist,MOLECFIT_GDAS,cpl_sprintf("GDAS%s",suf));
        cpl_propertylist_update_string(ilist,MOLECFIT_WAVE_INCLUDE,cpl_sprintf("WAVE_INCLUDE%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_WAVE_EXCLUDE,cpl_sprintf("WAVE_EXCLUDE%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_PIXEL_EXCLUDE,cpl_sprintf("PIX_EXCLUDE%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_MOLECULES,cpl_sprintf("MOLECULES%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_ATM_PROFILE_STANDARD,cpl_sprintf("ATM_PROFILE_STANDARD%s",suf));
        */
//        return err;
//}

cpl_error_code
mf_wrap_config_model_output_filenames(cpl_frameset *frameset, cpl_parameterlist *parlist, const char *suffix)
{
    //cpl_msg_info(cpl_func,"mf_wrap_config_model_output_filenames");

    cpl_error_code err = CPL_ERROR_NONE;

    const char *suf;
    if (!suffix) {
        suf = "";
    }
    else {
        suf = cpl_sprintf("_%s", suffix);
    }
    /*const char* type;
        if(strstr(input_name, "SCI")) {
            type = "_SCI";
        } else if(strstr(input_name, "STD") || strstr(input_name, "TELL")) {
            type = "_STD";
        } else {
            type = "";
        }*/
    //tag == MOLECFIT_MODEL_MOLECULES
    //filename == cpl_sprintf("MODEL_MOLECULES%s", suf)
    cpl_frame     *f;
    cpl_parameter *p;
    //only add frame if tag is in parameterlist!
    p = cpl_parameterlist_find(parlist, MOLECFIT_PARAMETER_WAVE_RANGE_INCLUDE);
    if (p) {
        //if parameter value is not NULL
        if (strcmp(cpl_parameter_get_string(p), MF_PARAMETERS_NULL) != 0) {
            /*    f = cpl_frame_new();
                err |= cpl_frame_set_filename(f,cpl_sprintf("%s.fits",MOLECFIT_WAVE_INCLUDE));
                //err |= cpl_frame_set_filename(f,cpl_sprintf("%s%s.fits",MOLECFIT_WAVE_INCLUDE,suf));
                err |= cpl_frame_set_tag(f,MOLECFIT_WAVE_INCLUDE); 
                err |= cpl_frame_set_group(f, CPL_FRAME_GROUP_CALIB);
                err |= cpl_frame_set_type(f, CPL_FRAME_TYPE_ANY);
                //err |= cpl_frame_set_type(f, CPL_FRAME_TYPE_TABLE);
                err |= cpl_frame_set_level(f, CPL_FRAME_LEVEL_FINAL);
                err = cpl_frameset_insert(frameset,f);
                */
        }
    }

    p = cpl_parameterlist_find(parlist, MOLECFIT_PARAMETER_WAVE_RANGE_EXCLUDE);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MF_PARAMETERS_NULL) != 0) {
            f = cpl_frame_new();
            err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_WAVE_EXCLUDE, suf));
            //err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_WAVE_EXCLUDE, suf));
            err |= cpl_frame_set_tag(f, MOLECFIT_WAVE_EXCLUDE);
            err = cpl_frameset_insert(frameset, f);
        }
    }
    p = cpl_parameterlist_find(parlist, MOLECFIT_PARAMETER_PIXEL_RANGE_EXCLUDE);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MF_PARAMETERS_NULL) != 0) {
            f = cpl_frame_new();
            err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_PIXEL_EXCLUDE, suf));
            err |= cpl_frame_set_tag(f, MOLECFIT_PIXEL_EXCLUDE);
            err = cpl_frameset_insert(frameset, f);
        }
    }

    /*

        f = cpl_frame_new();
        err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_MODEL_MOLECULES, suf));
        err |= cpl_frame_set_tag(f, MOLECFIT_MODEL_MOLECULES);
        err = cpl_frameset_insert(frameset, f);
        cpl_frameset_dump(frameset, stdout);

        f = cpl_frame_new();
        err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_GDAS, suf));
        err |= cpl_frame_set_tag(f, MOLECFIT_GDAS);
        err = cpl_frameset_insert(frameset, f);
        cpl_frameset_dump(frameset, stdout);

        f = cpl_frame_new();
        err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_GDAS_BEFORE, suf));
        err |= cpl_frame_set_tag(f, MOLECFIT_GDAS_BEFORE);
        err = cpl_frameset_insert(frameset, f);
        cpl_frameset_dump(frameset, stdout);

        f = cpl_frame_new();
        err |= cpl_frame_set_filename(f, cpl_sprintf("%s%s.fits", MOLECFIT_GDAS_AFTER, suf));
        err |= cpl_frame_set_tag(f, MOLECFIT_GDAS_AFTER);
        err = cpl_frameset_insert(frameset, f);
        cpl_frameset_dump(frameset, stdout);

        */


    /*
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("GDAS%s", suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_GDAS));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("GDAS_BEFORE%s", suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_GDAS_BEFORE));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("GDAS_AFTER%s", suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_GDAS_AFTER));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("ATM_PARAMETERS%s%s",type,suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_ATM_PARAMETERS));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("BEST_FIT_PARAMETERS%s%s",type,suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_BEST_FIT_PARAMETERS));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("BEST_FIT_MODEL%s%s",type,suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_BEST_FIT_MODEL));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("KERNEL_LIBRARY%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_KERNEL_LIBRARY));
        cpl_parameterlist_append(ilist, cpl_parameter_new_value(cpl_sprintf("MODEL_MOLECULES%s",suf),CPL_TYPE_STRING,NULL,NULL,MOLECFIT_MODEL_MOLECULES));
        */


    /*
        cpl_propertylist_update_string(ilist, MOLECFIT_GDAS,cpl_sprintf("GDAS%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_GDAS_BEFORE,cpl_sprintf("GDAS_BEFORE%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_GDAS_AFTER,cpl_sprintf("GDAS_AFTER%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_ATM_PARAMETERS,cpl_sprintf("ATM_PARAMETERS%s%s",type,suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_BEST_FIT_PARAMETERS,cpl_sprintf("BEST_FIT_PARAMETERS%s%s",type,suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_BEST_FIT_MODEL,cpl_sprintf("BEST_FIT_MODEL%s%s",type,suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_KERNEL_LIBRARY,cpl_sprintf("KERNEL_LIBRARY%s",suf));
        cpl_propertylist_update_string(ilist, MOLECFIT_MODEL_MOLECULES,cpl_sprintf("MODEL_MOLECULES%s",suf));
        */
    //NEW ONE TO ADD - ONLY FOR UVES
    //cpl_propertylist_update_string(ilist,MOLECFIT_EXTRACTED_SPECTRUM,sprintf("EXTRACTED_SPECTRUM%s",suf));

    return err;
}


cpl_error_code
mf_wrap_preconfig_check(cpl_frameset *frameset, const cpl_parameterlist *parlist, cpl_boolean *science_data_is_table)
{
    /* Check parameters and get initial errorstate */
    cpl_error_ensure(
        frameset && parlist, CPL_ERROR_NULL_INPUT, return CPL_ERROR_NULL_INPUT, "NULL input : frameset and/or parlist"
    );
    //cpl_errorstate initial_errorstate = cpl_errorstate_get();
    cpl_error_code err = CPL_ERROR_NONE;

    /* Check that all input string lists are in valid formats */
    cpl_error_code list_err = CPL_ERROR_NONE;
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_MODEL_MAPPING_KERNEL, MF_N0LIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_PARAMETER_LIST, MF_SLIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_PARAMETER_FIT, MF_BLIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_PARAMETER_RELATIVE_VALUE, MF_DLIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_WAVE_INCLUDE, MF_DRANGE);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_WAVE_EXCLUDE, MF_DRANGE);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MOLECFIT_PIXEL_EXCLUDE, MF_NRANGE);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MF_PARAMETERS_FIT_CONTINUUM, MF_MF_BLIST_OLD);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MF_PARAMETERS_CONTINUUM_N, MF_N0LIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MF_PARAMETERS_MAP_REGIONS_TO_CHIP, MF_NLIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_strlstchk(parlist, MF_PARAMETERS_MAP_REGIONS_TO_CHIP, MF_NLIST);
    }
    if (!list_err) {
        list_err = mf_wrap_config_stroptchk(parlist, MF_PARAMETERS_WAVELENGTH_FRAME, "VAC,AIR,VAC_RV,AIR_RV");
    }
    if (list_err != CPL_ERROR_NONE) {
        err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_error_set_message(cpl_func, err, "Invalid string list parameters");
        return err;
    }

    /*copy of mf_wrap_check_and_set_groups(frameset) from molecfit.c */
    if (!err) {
        /* Check size of frameset for to know if the sof file is not empty */
        cpl_size nframes = cpl_frameset_get_size(frameset);
        if (nframes <= 0) {
            /* Empty sof file */
            return cpl_error_set_message(cpl_func, CPL_ERROR_DATA_NOT_FOUND, "There aren't frames in the frameset");
        }
        else {
            for (cpl_size i = 0; i < nframes; i++) {
                cpl_frame  *frame    = cpl_frameset_get_position(frameset, i);
                const char *filename = cpl_frame_get_filename(frame);

                /* Check if the FITS file exist and have correct data,
               * return 0 if the fits file is valid without extensions */
                if (cpl_fits_count_extensions(filename) < 0) {
                    return cpl_error_set_message(
                        cpl_func, cpl_error_get_code(), "Problem with the file '%s' (%s --> Code %d)", filename,
                        cpl_error_get_message(), cpl_error_get_code()
                    );
                }
            }
        }

        /* Identify the RAW, CONF and CALIB frames in the input frameset */
        if (mf_wrap_dfs_set_groups(frameset)) {
            /* Error classify frames */
            return cpl_error_set_message(cpl_func, CPL_ERROR_DATA_NOT_FOUND, "Cannot classify RAW and/or CALIB frames");
        }
        else {
            /* Check classification */
            for (cpl_size i = 0; i < nframes; i++) {
                cpl_frame      *frame = cpl_frameset_get_position(frameset, i);
                const char     *tag   = cpl_frame_get_tag(frame);
                cpl_frame_group group = cpl_frame_get_group(frame);

                /* The tag is invalid */
                if (group == CPL_FRAME_GROUP_NONE) {
                    return cpl_error_set_message(
                        cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT, "Frame:%lld with tag:%s is invalid", i, tag
                    );
                }
            }
        }
    }

    /* Test kernel mapping */
    /*Might this be instrument independent?*/
    if (!err) {
        cpl_error_code map_err = CPL_ERROR_NONE;
        map_err                = mf_wrap_config_mappingchk(
            frameset, parlist, "KERNEL_LIBRARY", "MAPPING_KERNEL", "KERNEL_LIBRARY_EXT", MOLECFIT_MODEL_MAPPING_KERNEL,
            "NULL"
        );
        if (map_err) {
            cpl_msg_error(cpl_func, "Mapping Errors detected cannot proceed further");
        }
    }

    /* Check mandatory TAGS/Parameters */
    const cpl_frame *input_frame = NULL;
    //cpl_boolean science_data_is_table=CPL_FALSE;
    if (!err) {
        /* STD_MODEL/SCIENCE_CALCTRANS/SCIENCE */
        cpl_errorstate pre_state = cpl_errorstate_get();
        input_frame              = cpl_frameset_find(frameset, MOLECFIT_STD_MODEL);
        if (!input_frame) {
            cpl_errorstate_set(pre_state);
            input_frame = cpl_frameset_find(frameset, MOLECFIT_SCIENCE_CALCTRANS);
            if (!input_frame) {
                cpl_errorstate_set(pre_state);
                input_frame = cpl_frameset_find(frameset, MOLECFIT_SCIENCE);
                if (!input_frame) {
                    err = cpl_error_set_message(
                        cpl_func, CPL_ERROR_DATA_NOT_FOUND,
                        "STD_MODEL/SCIENCE_CALCTRANS/SCIENCE data not found in frameset!"
                    );
                }
            }
        }

        /* Checking the SCIENCE file data type eg is it in table form */
        if (science_data_is_table) {
            cpl_msg_info(cpl_func, "Science frame is in table data format");
        }
        if (!science_data_is_table) {
            cpl_msg_info(cpl_func, "Science frame is not in table data format");
        }

        /* MOLECULES */
        if (!err) {
            const cpl_frame *input_molecules = cpl_frameset_find_const(frameset, MOLECFIT_MOLECULES);
            if (!input_molecules) {
                /* There is no external molecule table so check on the string lists*/
                cpl_error_code molstr_err = CPL_ERROR_NONE;
                molstr_err                = mf_wrap_config_molecule_strs_chk(
                    cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_LIST)),
                    cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_FIT)),
                    cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_RELATIVE_VALUE))
                );

                if (molstr_err) {
                    err = CPL_ERROR_ILLEGAL_INPUT;
                    cpl_error_set_message(cpl_func, err, "Bad molecules definition!");
                }
            }
        }
    }

    /* If no error encountered, return OK */
    return CPL_ERROR_NONE;
}


/*mf_wrap_model_parameter * wrap_config_update(cpl_frameset *frameset, const cpl_parameterlist  *parlist){


}*/
/*put instrument specific stuff*/  // MOVED TO INSTRUMENT_MOLECFIT_MODEL


/*----------------------------------------------------------------------------*/
/**
 * @brief  Generate the internal configuration file required for mf_model and check values
 *
 * @param  parlist   parameterlist with the parameters
 *
 * @return mf_wrap_model_parameter parameters structure with instrument-independent defaults
 *
 */
/*----------------------------------------------------------------------------*/
mf_wrap_model_parameter *
mf_wrap_config_model_init(const cpl_parameterlist *parlist, const cpl_propertylist *data_primary_header)
// cpl_frameset *frameset --> was this needed ?
{
    /* copy of mf_wrap_model_parameters from molecfit_model.c */
    //mf_wrap_model_parameters (replace list => parlist)  //->is this needed ??
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init");

    /* Check input */
    cpl_error_ensure(parlist, CPL_ERROR_NULL_INPUT, return NULL, "parlist input is NULL!");

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 2");
    /* Get pre_state */
    cpl_errorstate pre_state = cpl_errorstate_get();
    cpl_msg_info(cpl_func, "ERROR? %s", cpl_error_get_message());

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 3");
    /* Create the configuration parameter */
    mf_wrap_model_parameter *parameters    = cpl_malloc(sizeof(mf_wrap_model_parameter));
    parameters->molecules_table            = NULL;
    parameters->wave_ranges_include_table  = NULL;
    parameters->wave_ranges_exclude_table  = NULL;
    parameters->pixel_ranges_exclude_table = NULL;
    parameters->mapping_kernel_table       = NULL;
    parameters->mf_config                  = NULL;
    parameters->pl                         = cpl_propertylist_new();

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 4");

    /*** Load recipe parameters ***/
    const cpl_parameter *p;

    cpl_msg_info(cpl_func, "BEFORE TABLE LOADS ERROR? %s", cpl_error_get_message());

    /* Use only primary extension in the input FITS file ? */
    p                                  = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_USE_ONLY_INPUT_PRI);
    parameters->use_only_input_pri_ext = cpl_parameter_get_bool(p);
    cpl_propertylist_update_bool(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_USE_ONLY_INPUT_PRI,
        parameters->use_only_input_pri_ext
    );

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5");
    /* If parameters->use_only_input_pri_ext == CPL_TRUE, you can provide a error flux extension */
    p                                = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_DFLUX_EXTENSION_DATA);
    parameters->dflux_extension_data = cpl_parameter_get_int(p);
    cpl_propertylist_update_int(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_DFLUX_EXTENSION_DATA,
        parameters->dflux_extension_data
    );

    /* If parameters->use_only_input_pri_ext == CPL_TRUE, you can provide a mask extension */
    p                               = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_MASK_EXTENSION_DATA);
    parameters->mask_extension_data = cpl_parameter_get_int(p);
    cpl_propertylist_update_int(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_MASK_EXTENSION_DATA,
        parameters->mask_extension_data
    );


    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.5");
    /* User input kernel ? */
    p                            = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_USE_INPUT_KERNEL);
    parameters->use_input_kernel = cpl_parameter_get_bool(p);
    cpl_propertylist_update_bool(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_USE_INPUT_KERNEL,
        parameters->use_input_kernel
    );


    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.6");
    /* Mapping kernel */
    cpl_msg_info(cpl_func, "mf_wrap_config_table_mapping: %s", cpl_error_get_message());
    p                          = cpl_parameterlist_find_const(parlist, MOLECFIT_MODEL_MAPPING_KERNEL);
    parameters->mapping_kernel = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_MODEL_MAPPING_KERNEL,
        parameters->mapping_kernel
    );

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.7");
    /* Create mapping kernel cpl_table */
    if (strcmp(parameters->mapping_kernel, MF_PARAMETERS_NULL) != 0) {
        parameters->mapping_kernel_table =
            mf_wrap_config_table_mapping(parameters->mapping_kernel, MOLECFIT_MAPPING_KERNEL_EXT);
    }


    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.8");
    /* Molecules list */
    p                      = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_LIST);
    parameters->list_molec = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_LIST, parameters->list_molec
    );

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.9");
    /* Molecules fit */
    p                     = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_FIT);
    parameters->fit_molec = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_FIT, parameters->fit_molec
    );

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 5.10");
    /* Molecules relative value */
    p                   = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_RELATIVE_VALUE);
    parameters->rel_col = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_RELATIVE_VALUE, parameters->rel_col
    );

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6");
    /* Create table */
    if (strcmp(parameters->list_molec, MF_PARAMETERS_NULL) != 0 &&
        strcmp(parameters->fit_molec, MF_PARAMETERS_NULL) != 0 &&
        strcmp(parameters->rel_col, MF_PARAMETERS_NULL) != 0) {
        parameters->molecules_table =
            mf_wrap_config_table_molecules(parameters->list_molec, parameters->fit_molec, parameters->rel_col);
    }
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.1");


    /* Wavelength ranges included */
    p                              = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_WAVE_RANGE_INCLUDE);
    parameters->wave_range_include = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_WAVE_RANGE_INCLUDE,
        parameters->wave_range_include
    );
    /* Create wavelength ranges included cpl_table */
    if (strcmp(parameters->wave_range_include, MF_PARAMETERS_NULL) != 0) {
        parameters->wave_ranges_include_table =
            mf_wrap_config_table_ranges(parameters->wave_range_include, CPL_TYPE_DOUBLE);
    }

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2");

    /* Wavelength ranges exclude */
    p = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_WAVE_RANGE_EXCLUDE);
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2a");
    parameters->wave_range_exclude = cpl_parameter_get_string(p);
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2b %s", parameters->wave_range_exclude);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_WAVE_RANGE_EXCLUDE,
        parameters->wave_range_exclude
    );
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2c");
    cpl_msg_info(cpl_func, "%s", parameters->wave_range_exclude);
    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2c2");
    /* Create wavelength ranges exclude cpl_table */
    if (strcmp(parameters->wave_range_exclude, MF_PARAMETERS_NULL) != 0) {
        //if (strcmp(parameters->wave_range_exclude, MF_PARAMETERS_NULL)) {
        cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.2d");
        parameters->wave_ranges_exclude_table =
            mf_wrap_config_table_ranges(parameters->wave_range_exclude, CPL_TYPE_DOUBLE);
    }

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.3");
    /* Pixel ranges exclude */
    p                               = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_PIXEL_RANGE_EXCLUDE);
    parameters->pixel_range_exclude = cpl_parameter_get_string(p);
    cpl_propertylist_update_string(
        parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_PIXEL_RANGE_EXCLUDE,
        parameters->pixel_range_exclude
    );

    /* Create pixel ranges exclude cpl_table */
    if (strcmp(parameters->pixel_range_exclude, MF_PARAMETERS_NULL) != 0) {
        parameters->pixel_ranges_exclude_table =
            mf_wrap_config_table_ranges(parameters->pixel_range_exclude, CPL_TYPE_INT);
    }

    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 6.4");

    /*** Get Molecfit config parameters from the input recipe parameter list ***/
    /*copied in below*/
    /*parameters->mf_config = mf_wrap_config_get_parameters(parlist, raw_head_pri, parameters->pl);*/


    cpl_msg_info(cpl_func, "mf_wrap_config_model_init 7");


    /* copy of mf_wrap_config_get_parameters from molecfit_config.c 
         (excluding mf_parameters_config_update_with_header_keywords
         change list => parlist; pl to parameters->pl
      */
    /* Check input */
    cpl_error_ensure(parlist && parameters->pl, CPL_ERROR_NULL_INPUT, return NULL, "list input is NULL!");

    cpl_msg_info(cpl_func, "Pre-mf_configuration_create ERROR? %s", cpl_error_get_message());
    /*** Molecfit default configuration ***/
    cpl_msg_info(cpl_func, "Load Molecfit default configuration ...");
    mf_configuration *mf_config = mf_configuration_create();
    if (!mf_config) {
        cpl_error_set_message(cpl_func, CPL_ERROR_ILLEGAL_OUTPUT, "Error loading Molecfit default configuration");
        return NULL;
    }
    cpl_msg_info(cpl_func, "Post-mf_configuration_create ERROR? %s", cpl_error_get_message());

    cpl_msg_info(cpl_func, "Set Molecfit configuration with recipe parameters...");

    /*** Set Molecfit configuration with recipe parameters ***/
    mf_parameters_directories  *directories  = &(mf_config->parameters->directories);
    mf_parameters_inputs       *inputs       = &(mf_config->parameters->inputs);
    mf_parameters_fitting      *fitting      = &(mf_config->parameters->fitting);
    mf_parameters_ambient      *ambient      = &(mf_config->parameters->ambient);
    mf_parameters_instrumental *instrumental = &(mf_config->parameters->instrumental);
    mf_parameters_atmospheric  *atmospheric  = &(mf_config->parameters->atmospheric);

    cpl_msg_info(cpl_func, "DONE with Set Molecfit configuration with recipe parameters...");


    /*** Directories ***/
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELLURICCORR_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->telluric_path) {
                cpl_free(directories->telluric_path);
            }
            directories->telluric_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELLURICCORR_PATH,
                directories->telluric_path
            );
        }
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELLURICCORR_DATA_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->telluriccorr_data_path) {
                cpl_free(directories->telluriccorr_data_path);
            }
            directories->telluriccorr_data_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELLURICCORR_DATA_PATH,
                directories->telluriccorr_data_path
            );
        }
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TMP_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->tmp_path) {
                cpl_free(directories->tmp_path);
            }
            directories->tmp_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TMP_PATH, directories->tmp_path
            );
        }
    }

    /*p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OUTPUT_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT)) {
            if (directories->output_path) cpl_free(directories->output_path);
            directories->output_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OUTPUT_PATH, directories->output_path);
        }
    }*/

    /*p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OUTPUT_NAME);
    if (p) {
        if (directories->output_name) cpl_free(directories->output_name);
        directories->output_name = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OUTPUT_NAME, directories->output_name);
    }*/


    /*** Input parameters ***/

    /* p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OMP_NUM_THREADS);
    if (p) {
        inputs->omp_num_threads = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OMP_NUM_THREADS, inputs->omp_num_threads);
    }*/

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_SILENT_EXTERNAL_BINS);
    if (p) {
        inputs->silent_external_bins = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SILENT_EXTERNAL_BINS,
            inputs->silent_external_bins
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TRANSMISSION);
    if (p) {
        inputs->transmission = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TRANSMISSION, inputs->transmission
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_COLUMN_LAMBDA);
    if (p) {
        if (inputs->column_lambda) {
            cpl_free(inputs->column_lambda);
        }
        inputs->column_lambda = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_LAMBDA, inputs->column_lambda
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_COLUMN_FLUX);
    if (p) {
        if (inputs->column_flux) {
            cpl_free(inputs->column_flux);
        }
        inputs->column_flux = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_FLUX, inputs->column_flux
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_COLUMN_DFLUX);
    if (p) {
        if (inputs->column_dflux) {
            cpl_free(inputs->column_dflux);
        }
        inputs->column_dflux = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_DFLUX, inputs->column_dflux
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_COLUMN_MASK);
    if (p) {
        if (inputs->column_mask) {
            cpl_free(inputs->column_mask);
        }
        inputs->column_mask = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_MASK, inputs->column_mask
        );
    }


    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_DEFAULT_ERROR);
    if (p) {
        inputs->default_error = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_DEFAULT_ERROR, inputs->default_error
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_WLG_TO_MICRON);
    if (p) {
        inputs->wlg_to_micron = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLG_TO_MICRON, inputs->wlg_to_micron
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_WAVELENGTH_FRAME);
    if (p) {
        if (inputs->wavelengths_frame) {
            cpl_free(inputs->wavelengths_frame);
        }
        inputs->wavelengths_frame = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WAVELENGTH_FRAME, inputs->wavelengths_frame
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OBSERVATORY_ERF_RV_KEYWORD);
    if (p) {
        if (inputs->observing_erv_rv.key) {
            cpl_free(inputs->observing_erv_rv.key);
        }
        inputs->observing_erv_rv.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVATORY_ERF_RV_KEYWORD,
            inputs->observing_erv_rv.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OBSERVATORY_ERF_RV_VALUE);
    if (p) {
        inputs->observing_erv_rv.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVATORY_ERF_RV_VALUE,
            inputs->observing_erv_rv.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_CLEAN_MODEL_FLUX);
    if (p) {
        inputs->clean_flux = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CLEAN_MODEL_FLUX, inputs->clean_flux
        );
    }


    /*** Fitting ***/

    /* Convergence criterion */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FTOL);
    if (p) {
        fitting->ftol = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FTOL, fitting->ftol
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_XTOL);
    if (p) {
        fitting->xtol = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_XTOL, fitting->xtol
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FLUX_UNIT);
    if (p) {
        fitting->flux_unit = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FLUX_UNIT, fitting->flux_unit
        );
    }


    /*** EXPERT FITTING OPTIONS ***/
    /* 
      CHIP and RANGE FIT OPTIONS:
        This if from the old molecfit expert options of:
            fit_chip1 =1 or 0
            fit_chip2 =1 or 0
            fit_chip3 =1 or 0
            fit_chip4 =1 or 0
            fit_range1=1 or 0
            fit_range2=1 or 0
            fit_range3=1 or 0
            fit_range4=1 or 0
        These are currently added for instrument scientist to play with
        and maybe later decide of how to use.
    */

    /* FIT_CHIP[1-4]*/
    p = cpl_parameterlist_find_const(parlist, "FIT_CHIP1");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP1 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_CHIP2");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP2 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_CHIP3");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP3 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_CHIP4");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP4 = %f. Ignored as this parameter is now obsolete.", dval);
    }


    /* FIT_RANGE[1-4]*/
    p = cpl_parameterlist_find_const(parlist, "FIT_RANGE1");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE1 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_RANGE2");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE2 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_RANGE3");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE3 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(parlist, "FIT_RANGE4");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE4 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    /* NOTE: The recipe parameter "FIT_RANGES" is a string of 1 and 0s deliminated with ',' character
             and the fitting->fit_ranges is a boolean vector so that telluriccor doen't have to
             parse the string to a vector of booleans */
    p = cpl_parameterlist_find_const(parlist, "FIT_CHIPS");
    if (p) {
        /* Get the string as specified in the .rc file */
        const char *flagstr = cpl_parameter_get_string(p);

        /* Parse the string into a set of 0s and 1s */
        int cnt = 0;
        for (int i = 0; i < (int)strlen(flagstr); i++) {
            if (flagstr[i] != '1' && flagstr[i] != '0') {
                continue;
            }
            cpl_msg_info(cpl_func, "CHIP %d -> %c", cnt, flagstr[i]);
            if (flagstr[i] == '1') {
                fitting->fit_chips[cnt] = CPL_TRUE;
            }
            if (flagstr[i] == '0') {
                fitting->fit_chips[cnt] = CPL_FALSE;
            }
            cnt++;
        }
        if (cnt > 0) {
            fitting->fit_n_cflags = cnt;
        }
        cpl_msg_info(cpl_func, "N CHIP FLAGS DEFINED = %d", fitting->fit_n_cflags);

        cpl_propertylist_update_string(
            parameters->pl,
            MF_PARAMETERS_CONTEX_DEFAULT " "
                                         "FIT_CHIPS",
            flagstr
        );
    }


    /* NOTE: The recipe parameter "FIT_RANGES" is a string of 1 and 0s deliminated with ',' character
             and the fitting->fit_ranges is a boolean vector so that telluriccor doen't have to
             parse the string to a vector of booleans */
    p = cpl_parameterlist_find_const(parlist, "FIT_RANGES");
    if (p) {
        /* Get the string as specified in the .rc file */
        const char *flagstr = cpl_parameter_get_string(p);

        /* Parse the string into a set of 0s and 1s */
        int cnt = 0;
        for (size_t i = 0; i < strlen(flagstr); i++) {
            if (flagstr[i] != '1' && flagstr[i] != '0') {
                continue;
            }
            cpl_msg_info(cpl_func, "RANGE %d -> %c", cnt, flagstr[i]);
            if (flagstr[i] == '1') {
                fitting->fit_ranges[cnt] = CPL_TRUE;
            }
            if (flagstr[i] == '0') {
                fitting->fit_ranges[cnt] = CPL_FALSE;
            }
            cnt++;
        }
        if (cnt > 0) {
            fitting->fit_n_rflags = cnt;
        }

        cpl_propertylist_update_string(
            parameters->pl,
            MF_PARAMETERS_CONTEX_DEFAULT " "
                                         "FIT_RANGES",
            flagstr
        );
    }


    /* Telelescope background */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FIT_TELESCOPE_BACK);
    if (p) {
        fitting->fit_telescope_background.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_TELESCOPE_BACK,
            fitting->fit_telescope_background.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELESCOPE_BACK_CONST);
    if (p) {
        fitting->fit_telescope_background.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_BACK_CONST,
            fitting->fit_telescope_background.const_val
        );
    }


    /* Telelescope backgroud */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FIT_TELESCOPE_BACK);
    if (p) {
        fitting->fit_telescope_background.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_TELESCOPE_BACK,
            fitting->fit_telescope_background.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELESCOPE_BACK_CONST);
    if (p) {
        fitting->fit_telescope_background.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_BACK_CONST,
            fitting->fit_telescope_background.const_val
        );
    }


    /* Continuum */
    p = cpl_parameterlist_find_const(parlist, "FIT_CONTINUUM_OLD");
    if (p) {
        fitting->fit_continuum.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_CONTINUUM, fitting->fit_continuum.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, "CONTINUUM_N_OLD");
    if (p) {
        fitting->fit_continuum.n = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CONTINUUM_N, (int)fitting->fit_continuum.n
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_CONTINUUM_CONST);
    if (p) {
        fitting->fit_continuum.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CONTINUUM_CONST,
            fitting->fit_continuum.const_val
        );
    }

    /*p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OBSERVATORY_BARY_RV);
    if (p) {
        fitting->obs_bary_rv = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OBSERVATORY_BARY_RV, fitting->obs_bary_rv);
    }
    */


    /* Wavelength solution fit/adjustment */
    p = cpl_parameterlist_find_const(parlist, "FIT_WLC_OLD");
    if (p) {
        fitting->fit_wavelenght.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_WLC, fitting->fit_wavelenght.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_WLC_N);
    if (p) {
        fitting->fit_wavelenght.n = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLC_N, (int)fitting->fit_wavelenght.n
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_WLC_CONST);
    if (p) {
        fitting->fit_wavelenght.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLC_CONST,
            (int)fitting->fit_wavelenght.const_val
        );
    }

    /* p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_WLC_REF);
    if (p) {
        if (fitting->wlc_ref) cpl_free(fitting->wlc_ref);
        fitting->wlc_ref = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_WLC_REF, fitting->wlc_ref);
    }*/


    /* Default kernel: Boxcar kernel */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FIT_RES_BOX);
    if (p) {
        fitting->fit_res_box.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_RES_BOX, fitting->fit_res_box.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_RES_BOX);
    if (p) {
        fitting->fit_res_box.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_BOX, fitting->fit_res_box.const_val
        );
    }


    /* Default kernel: Gaussian kernel */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FIT_GAUSS);
    if (p) {
        fitting->fit_gauss.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_GAUSS, fitting->fit_gauss.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_RES_GAUSS);
    if (p) {
        fitting->fit_gauss.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_GAUSS, fitting->fit_gauss.const_val
        );
    }


    /* Default kernel: Lorentz kernel */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_FIT_LORENTZ);
    if (p) {
        fitting->fit_lorentz.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_LORENTZ, fitting->fit_lorentz.fit
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_RES_LORENTZ);
    if (p) {
        fitting->fit_lorentz.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_LORENTZ, fitting->fit_lorentz.const_val
        );
    }


    /* Default kernels: Generic parameters */
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_KERN_MODE);
    if (p) {
        fitting->kern_mode = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_KERN_MODE, fitting->kern_mode
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_KERN_FAC);
    if (p) {
        fitting->kern_fac = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_KERN_FAC, fitting->kern_fac
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_VAR_KERN);
    if (p) {
        fitting->var_kern = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_VAR_KERN, fitting->var_kern
        );
    }


    /*** Ambient ***/
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OBSERVING_DATE_KEYWORD);
    if (p) {
        if (ambient->observing_date.key) {
            cpl_free(ambient->observing_date.key);
        }
        ambient->observing_date.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVING_DATE_KEYWORD,
            ambient->observing_date.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_OBSERVING_DATE_VALUE);
    if (p) {
        ambient->observing_date.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVING_DATE_VALUE,
            ambient->observing_date.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_UTC_KEYWORD);
    if (p) {
        if (ambient->utc.key) {
            cpl_free(ambient->utc.key);
        }
        ambient->utc.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_UTC_KEYWORD, ambient->utc.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_UTC_VALUE);
    if (p) {
        ambient->utc.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_UTC_VALUE, ambient->utc.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELESCOPE_ANGLE_KEYWORD);
    if (p) {
        if (ambient->telescope_angle.key) {
            cpl_free(ambient->telescope_angle.key);
        }
        ambient->telescope_angle.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_ANGLE_KEYWORD,
            ambient->telescope_angle.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TELESCOPE_ANGLE_VALUE);
    if (p) {
        ambient->telescope_angle.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_ANGLE_VALUE,
            ambient->telescope_angle.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_RELATIVE_HUMIDITY_KEYWORD);
    if (p) {
        if (ambient->relative_humidity.key) {
            cpl_free(ambient->relative_humidity.key);
        }
        ambient->relative_humidity.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RELATIVE_HUMIDITY_KEYWORD,
            ambient->relative_humidity.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_RELATIVE_HUMIDITY_VALUE);
    if (p) {
        ambient->relative_humidity.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RELATIVE_HUMIDITY_VALUE,
            ambient->relative_humidity.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_PRESSURE_KEYWORD);
    if (p) {
        if (ambient->pressure.key) {
            cpl_free(ambient->pressure.key);
        }
        ambient->pressure.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PRESSURE_KEYWORD, ambient->pressure.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_PRESSURE_VALUE);
    if (p) {
        ambient->pressure.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PRESSURE_VALUE, ambient->pressure.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TEMPERATURE_KEYWORD);
    if (p) {
        if (ambient->temperature.key) {
            cpl_free(ambient->temperature.key);
        }
        ambient->temperature.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TEMPERATURE_KEYWORD, ambient->temperature.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_TEMPERATURE_VALUE);
    if (p) {
        ambient->temperature.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TEMPERATURE_VALUE, ambient->temperature.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_MIRROR_TEMPERATURE_KEYWORD);
    if (p) {
        if (ambient->mirror_temperature.key) {
            cpl_free(ambient->mirror_temperature.key);
        }
        ambient->mirror_temperature.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_MIRROR_TEMPERATURE_KEYWORD,
            ambient->mirror_temperature.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_MIRROR_TEMPERATURE_VALUE);
    if (p) {
        ambient->mirror_temperature.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_MIRROR_TEMPERATURE_VALUE,
            ambient->mirror_temperature.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_ELEVATION_KEYWORD);
    if (p) {
        if (ambient->elevation.key) {
            cpl_free(ambient->elevation.key);
        }
        ambient->elevation.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_ELEVATION_KEYWORD, ambient->elevation.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_ELEVATION_VALUE);
    if (p) {
        ambient->elevation.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_ELEVATION_VALUE, ambient->elevation.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LONGITUDE_KEYWORD);
    if (p) {
        if (ambient->longitude.key) {
            cpl_free(ambient->longitude.key);
        }
        ambient->longitude.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LONGITUDE_KEYWORD, ambient->longitude.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LONGITUDE_VALUE);
    if (p) {
        ambient->longitude.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LONGITUDE_VALUE, ambient->longitude.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LATITUDE_KEYWORD);
    if (p) {
        if (ambient->latitude.key) {
            cpl_free(ambient->latitude.key);
        }
        ambient->latitude.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_KEYWORD, ambient->latitude.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LATITUDE_VALUE);
    if (p) {
        ambient->latitude.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_VALUE, ambient->latitude.value
        );
    }


    /*** Instrumental ***/
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_SLIT_WIDTH_KEYWORD);
    if (p) {
        if (instrumental->slit_width.key) {
            cpl_free(instrumental->slit_width.key);
        }
        instrumental->slit_width.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SLIT_WIDTH_KEYWORD,
            instrumental->slit_width.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_SLIT_WIDTH_VALUE);
    if (p) {
        instrumental->slit_width.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SLIT_WIDTH_VALUE,
            instrumental->slit_width.value
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_PIXEL_SCALE_KEYWORD);
    if (p) {
        if (instrumental->pixel_scale.key) {
            cpl_free(instrumental->pixel_scale.key);
        }
        instrumental->pixel_scale.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PIXEL_SCALE_KEYWORD,
            instrumental->pixel_scale.key
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_PIXEL_SCALE_VALUE);
    if (p) {
        instrumental->pixel_scale.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PIXEL_SCALE_VALUE,
            instrumental->pixel_scale.value
        );
    }


    /*** Atmospheric ***/
    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_REFERENCE_ATMOSPHERIC);
    if (p) {
        if (atmospheric->ref_atm) {
            cpl_free(atmospheric->ref_atm);
        }
        atmospheric->ref_atm = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_REFERENCE_ATMOSPHERIC, atmospheric->ref_atm
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_GDAS_PROFILE);
    if (p) {
        if (atmospheric->gdas_prof) {
            cpl_free(atmospheric->gdas_prof);
        }
        atmospheric->gdas_prof = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_GDAS_PROFILE, atmospheric->gdas_prof
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LAYERS);
    if (p) {
        atmospheric->layers = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LAYERS, atmospheric->layers
        );
    }


    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_EMIX);
    if (p) {
        atmospheric->emix = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_EMIX, atmospheric->emix
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_PWV);
    if (p) {
        atmospheric->pwv = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PWV, atmospheric->pwv
        );
    }


    /*** LNFL ***/
    mf_io_lnfl_config *lnfl = mf_config->lnfl;

    p = cpl_parameterlist_find_const(parlist, MF_LNFL_LINE_DB);
    if (p) {
        if (lnfl->line_db) {
            cpl_free(lnfl->line_db);
        }
        lnfl->line_db = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LNFL_LINE_DB, lnfl->line_db);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LNFL_LINE_DB_FMT);
    if (p) {
        lnfl->line_db_fmt = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LNFL_LINE_DB_FMT, lnfl->line_db_fmt
        );
    }


    /*** LBLRTM ***/
    mf_io_lblrtm_config *lblrtm = mf_config->lblrtm;

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_ICNTNM);
    if (p) {
        lblrtm->icntnm = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ICNTNM, lblrtm->icntnm);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_IAERSL);
    if (p) {
        lblrtm->iaersl = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_IAERSL, lblrtm->iaersl);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_MPTS);
    if (p) {
        lblrtm->mpts = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_MPTS, lblrtm->mpts);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_NPTS);
    if (p) {
        lblrtm->npts = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NPTS, lblrtm->npts);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_V1);
    if (p) {
        lblrtm->v[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_V1, lblrtm->v[0]);
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_V2);
    if (p) {
        lblrtm->v[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_V2, lblrtm->v[1]);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SAMPLE);
    if (p) {
        lblrtm->sample = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SAMPLE, lblrtm->sample);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_ALFAL0);
    if (p) {
        lblrtm->alfal0 = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALFAL0, lblrtm->alfal0
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_AVMASS);
    if (p) {
        lblrtm->avmass = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_AVMASS, lblrtm->avmass
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_DPTMIN);
    if (p) {
        lblrtm->dptmin = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DPTMIN, lblrtm->dptmin
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_DPTFAC);
    if (p) {
        lblrtm->dptfac = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DPTFAC, lblrtm->dptfac
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_TBOUND);
    if (p) {
        lblrtm->tbound = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TBOUND, lblrtm->tbound
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SREMIS1);
    if (p) {
        lblrtm->sremis[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS1, lblrtm->sremis[0]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SREMIS2);
    if (p) {
        lblrtm->sremis[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS2, lblrtm->sremis[1]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SREMIS3);
    if (p) {
        lblrtm->sremis[2] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS3, lblrtm->sremis[2]
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SRREFL1);
    if (p) {
        lblrtm->srrefl[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL1, lblrtm->srrefl[0]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SRREFL2);
    if (p) {
        lblrtm->srrefl[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL2, lblrtm->srrefl[1]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_SRREFL3);
    if (p) {
        lblrtm->srrefl[2] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL3, lblrtm->srrefl[2]
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_MODEL);
    if (p) {
        lblrtm->model = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_MODEL, lblrtm->model);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_ITYPE);
    if (p) {
        lblrtm->itype = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ITYPE, lblrtm->itype);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_NOZERO);
    if (p) {
        lblrtm->nozero = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NOZERO, lblrtm->nozero);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_NOPRNT);
    if (p) {
        lblrtm->noprnt = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NOPRNT, lblrtm->noprnt);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_IPUNCH);
    if (p) {
        lblrtm->ipunch = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_IPUNCH, lblrtm->ipunch);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_RE);
    if (p) {
        lblrtm->re = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_RE, lblrtm->re);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_HSPACE);
    if (p) {
        lblrtm->hspace = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_HSPACE, lblrtm->hspace
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_LATITUDE_VALUE);
    if (p) {
        lblrtm->ref_lat = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_VALUE, lblrtm->ref_lat
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_PARAMETERS_ELEVATION_VALUE);
    if (p) {
        lblrtm->h[0] = cpl_parameter_get_double(p) / 1000.0;
        /*cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_LBLRTM_H1, lblrtm->h[0]);*/
    }


    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_H2);
    if (p) {
        lblrtm->h[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_H2, lblrtm->h[1]);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_RANGE);
    if (p) {
        lblrtm->range = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_RANGE, lblrtm->range);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_BETA);
    if (p) {
        lblrtm->beta = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_BETA, lblrtm->beta);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_LEN);
    if (p) {
        lblrtm->len = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_LEN, lblrtm->len);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_HOBS);
    if (p) {
        lblrtm->hobs = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_HOBS, lblrtm->hobs);
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_AVTRAT);
    if (p) {
        lblrtm->avtrat = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_AVTRAT, lblrtm->avtrat
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_TDIFF1);
    if (p) {
        lblrtm->tdiff[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TDIFF1, lblrtm->tdiff[0]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_TDIFF2);
    if (p) {
        lblrtm->tdiff[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TDIFF2, lblrtm->tdiff[1]
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_ALTD1);
    if (p) {
        lblrtm->altd[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALTD1, lblrtm->altd[0]
        );
    }
    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_ALTD2);
    if (p) {
        lblrtm->altd[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALTD2, lblrtm->altd[1]
        );
    }

    p = cpl_parameterlist_find_const(parlist, MF_LBLRTM_DELV);
    if (p) {
        lblrtm->delv = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DELV, lblrtm->delv);
    }


    cpl_msg_info(cpl_func, "Calling mf_parameters_config_update_with_header_keywords");

    cpl_msg_info(
        cpl_func, "BEFORE mf_parameters_config_update_with_header_keywords ERROR? %s", cpl_error_get_message()
    );
    /*** Update the Molecfit configuration with the header ***/
    mf_parameters_config_update_with_header_keywords(mf_config->parameters, data_primary_header);

    cpl_msg_info(cpl_func, "About to initialise parameters->chip_extensions");


    /* Combine extensions in the FITS file ? */
    p = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_CHIP_EXTENSIONS);
    if (p) {
        parameters->chip_extensions = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            parameters->pl, MF_PARAMETERS_CONTEX_DEFAULT " " MOLECFIT_PARAMETER_CHIP_EXTENSIONS,
            parameters->chip_extensions
        );
    }

    cpl_msg_info(cpl_func, "Initialised parameters->chip_extensions");
    cpl_msg_info(cpl_func, "Value of parameters->chip_extensions %d", parameters->chip_extensions);
    /* copy in the mf_config parameters */
    parameters->mf_config = mf_config;
    cpl_msg_info(cpl_func, "ERROR? %s", cpl_error_get_message());


    /* Check status */
    if (!cpl_errorstate_is_equal(pre_state) || !(parameters->mf_config)) {
        /* Configuration failed */
        cpl_error_set_message(cpl_func, CPL_ERROR_ILLEGAL_OUTPUT, "Error loading Molecfit default configuration");
        if (parameters) {
            cpl_msg_info(cpl_func, "PREMATURE DELETION");
            if (parameters->molecules_table) {
                cpl_table_delete(parameters->molecules_table);
            }
            if (parameters->wave_ranges_include_table) {
                cpl_table_delete(parameters->wave_ranges_include_table);
            }
            if (parameters->wave_ranges_exclude_table) {
                cpl_table_delete(parameters->wave_ranges_exclude_table);
            }
            if (parameters->pixel_ranges_exclude_table) {
                cpl_table_delete(parameters->pixel_ranges_exclude_table);
            }
            if (parameters->mapping_kernel_table) {
                cpl_table_delete(parameters->mapping_kernel_table);
            }
            if (parameters->mf_config) {
                mf_configuration_delete(parameters->mf_config);
            }
            if (parameters->pl) {
                cpl_propertylist_delete(parameters->pl);
            }

            cpl_free(parameters);
        }
        return NULL;
    }
    else {
        return parameters;
    }
}

//mf_wrap_model_parameter * init_wrap_check_tags()
/*cpl_frameset *frameset, const cpl_parameterlist  *parlist*/
/*{
//common - instrument agnostic checks
 * FILL THIS IN
}*/

cpl_error_code
mf_wrap_merge_parameterlists(cpl_parameterlist *ilist, const cpl_parameterlist *parlist, cpl_parameterlist *result)
{
    //PERHAPS THE DUPLICATE / NOT DELETING PARAM is causing segfaults....

    //duplicate parlist into result
    cpl_parameter *param = (cpl_parameter *)cpl_parameterlist_get_first_const(parlist);
    while (param != NULL) {
        //need to duplicate param here since parlist is read-only (const)
        cpl_parameterlist_append(result, cpl_parameter_duplicate(param));
        param = (cpl_parameter *)cpl_parameterlist_get_next_const(parlist);
    }

    param = cpl_parameterlist_get_first(ilist);
    while (param != NULL) {
        const char    *param_name = cpl_parameter_get_name(param);
        cpl_parameter *param2     = cpl_parameterlist_find(result, param_name);
        //if the parameter is not in the result (parlist), add it
        if (param2 == NULL) {
            cpl_parameterlist_append(result, param);
        }
        else {
            //update the parlist value with the new ilist value, but only if the rc file
            //has a value that is NOT the default (i.e. the user specified their own value)
            //this doesn't work if you actually want to insist on the default being set...
            cpl_type type = cpl_parameter_get_type(param2);
            if (type == CPL_TYPE_INT) {
                cpl_parameter_set_int(param2, cpl_parameter_get_int(param));
                /*
                    int val = cpl_parameter_get_int(param2);
                    int def = cpl_parameter_get_default_int(param2);
                    int newval = cpl_parameter_get_int(param);
                    if(val != def){
                        cpl_parameter_set_int(param2,newval);
                    }
                    */
            }
            else if (type == CPL_TYPE_BOOL) {
                cpl_parameter_set_bool(param2, cpl_parameter_get_bool(param));
                /* int val = cpl_parameter_get_bool(param2);
                    int def = cpl_parameter_get_default_bool(param2);
                    int newval = cpl_parameter_get_bool(param);
                    if(val != def){
                        cpl_parameter_set_bool(param2,newval);
                    }*/
            }
            else if (type == CPL_TYPE_DOUBLE) {
                cpl_parameter_set_double(param2, cpl_parameter_get_double(param));
                /*double val = cpl_parameter_get_double(param2);
                    double def= cpl_parameter_get_default_double(param2);
                    double newval = cpl_parameter_get_double(param);
                    if(val != def){
                        cpl_parameter_set_double(param2,newval);
                    }*/
            }
            else if (type == CPL_TYPE_STRING) {
                cpl_parameter_set_string(param2, cpl_parameter_get_string(param));
                /*const char* val = cpl_parameter_get_string(param2);
                    const char* def= cpl_parameter_get_default_string(param2);
                    const char* newval = cpl_parameter_get_string(param);
                    if(!strcmp(val,def)){
                        cpl_parameter_set_string(param2,newval);
                    }*/
            }
        }  //end else
        param = cpl_parameterlist_get_next(ilist);
    }  //end while
    /*
    for each param in parlist;
        append to result
    //each value in parlist will have a current and default value
    //only update with ilist value if the current != default (i.e. the user has set a value in their rc file)
    //TODO: setup this logic later; only really needed if we are using the rc file, which we don't need to at the moment.
    for each param in ilist;
        if(param is in result):
            result[param] = ilist[param]
        else:
            append to result
    */
    // Structure ->
    /*
     * molecfit model paramters
     * 1st stage -> default values (set by telluriccorr/ wrap functions => parlist
     * 2nd state -> instrument level default values => ilist 
     * 3rd stage -> input parameters given by the user (as input for instr_molecfit_model.c)
     */
    // MAKE A COPY OF PARLIST, AND ITERATE OVER THE ILIST->
    //IF VALUE IS IN PARLIST, THEN DO NOTHING, IF VALUE IS NOT IN PARLIST, THEN ADD THAT PARAMETER TO ILIST.

    return CPL_ERROR_NONE;
}

cpl_error_code init_wrap_merge_with_header(mf_parameters_config *config, const cpl_propertylist *header)
{
    cpl_error_code err = CPL_ERROR_NONE;
    mf_parameters_config_update_with_header_keywords(config, header);
    return err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Given a frame for SCIENCE data, check if the data format is a table or not
 *
 * @param cpl_frame *input_frame The science data frame being investigated
 *
 * @return           True if table type false otherwise
 *
 *
 */
/* ---------------------------------------------------------------------------*/

cpl_boolean mf_wrap_config_chk_science_is_table(cpl_frame *input_frame)
{
    const char *filename = cpl_frame_get_filename(input_frame);
    cpl_msg_info(cpl_func, "Checking data structure type of the SCIENCE file %s", filename);
    mf_wrap_fits_file_format format = mf_wrap_fits_get_file_format(filename, CPL_FALSE);
    switch (format) {
        case mf_wrap_fits_file_table:
            cpl_msg_info(cpl_func, "\t Data structure is in a molecfits table format");
            break;
        case mf_wrap_fits_file_image_1D:
            cpl_msg_info(cpl_func, "\t Data structure is a 1D image");
            break;
        case mf_wrap_fits_file_image_2D:
            cpl_msg_info(cpl_func, "\t Data structure is a 2D image");
            break;
        case mf_wrap_fits_file_image_3D:
            cpl_msg_info(cpl_func, "\t Data structure is a 3D image");
            break;
        default:
            cpl_msg_info(cpl_func, "\t Data structure is a Something else!");
            break;
    }

    if (format != mf_wrap_fits_file_table) {
        return CPL_FALSE;
    }

    return CPL_TRUE;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that the 3 molecule parameter strings are consistent
 *
 * @param char*      str1        List of molecule names
 * @param char*      str2        List of molecule fitting flags
 * @param char*      str3        List of molecule rel values.
 *
 * @return           Error if incompatible
 *
 *
 */
/* ---------------------------------------------------------------------------*/

cpl_error_code mf_wrap_config_molecule_strs_chk(const char *str1, const char *str2, const char *str3)

{
    /* Check that strings are valid*/
    if (!str1) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (!str2) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (!str3) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (mf_strlst_is_null(str1)) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (mf_strlst_is_null(str2)) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (mf_strlst_is_null(str3)) {
        cpl_msg_info(cpl_func, "No external molecule table defined nor any valid molecule list parameters");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    /* Check that string lists have same sizes*/
    int n1 = mf_strlst_get_size(str1);
    int n2 = mf_strlst_get_size(str2);
    int n3 = mf_strlst_get_size(str3);

    if (n1 != n2 || n1 != n3 || n2 != n3) {
        cpl_msg_info(cpl_func, "Molecule parameter lists have incompatible sizes");
        cpl_msg_info(cpl_func, "\t%s", str1);
        cpl_msg_info(cpl_func, "\t%s", str2);
        cpl_msg_info(cpl_func, "\t%s", str3);
        return CPL_ERROR_ILLEGAL_INPUT;
    }


    return CPL_ERROR_NONE;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given string list has valid syntax for its type
 *
 * @param str         The string to split.
 * @param delimiter   String specifying the locations where to split.
 * @param size        (Output) If non NULL, the number of found tokens is returned.
 *
 * @return err
 *
 *
 */
/* ---------------------------------------------------------------------------*/

cpl_error_code
mf_wrap_config_strlstchk(const cpl_parameterlist *parlist, const char *parname, mf_wrap_strlst_type strlst_type)

{
    cpl_error_code       err;
    const cpl_parameter *par;

    err = CPL_ERROR_NONE;


    /* Check that the parameter name is legal */
    if (!err) {
        par = cpl_parameterlist_find_const(parlist, parname);
        if (!par) {
            err = CPL_ERROR_ILLEGAL_INPUT;
            cpl_msg_error(cpl_func, "Invalid parameter name %s", parname);
            return err;
        }
    }

    /* Check that the string list is a valid list of the specified element type */
    const char *strlst = NULL;
    if (!err) {
        strlst = cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, parname));

        if (mf_strlst_is_null(strlst)) {
            cpl_msg_info(cpl_func, "Syntax format for parameter %s OK (=NULL)", parname);
            return err;
        }


        switch (strlst_type) {
            case (MF_SLIST):
                if (!mf_wrap_strlst_is_valid(strlst, MF_WRAP_STRLST_STRING)) {
                    cpl_msg_error(cpl_func, "Bad string list specified for parameter %s", parname);
                    return CPL_ERROR_ILLEGAL_INPUT;
                }
                break;

            case (MF_DLIST):
            case (MF_DRANGE):
                if (!mf_wrap_strlst_is_valid(strlst, MF_WRAP_STRLST_DOUBLE)) {
                    cpl_msg_error(cpl_func, "Bad double list specified for parameter %s", parname);
                    return CPL_ERROR_ILLEGAL_INPUT;
                }
                break;

            case (MF_NLIST):
            case (MF_N0LIST):
            case (MF_NRANGE):
            case (MF_N0RANGE):
                if (!mf_wrap_strlst_is_valid(strlst, MF_WRAP_STRLST_INT)) {
                    cpl_msg_error(cpl_func, "Bad integer list specified for parameter %s", parname);
                    return CPL_ERROR_ILLEGAL_INPUT;
                }
                break;

            case (MF_MF_BLIST_OLD):
                if (strlst[0] == 'T' || strlst[0] == 't' || strlst[0] == 'F' || strlst[0] == 'f') {
                    break;
                }
                else if (!mf_wrap_strlst_is_valid(strlst, MF_WRAP_STRLST_BOOL)) {
                    cpl_msg_error(cpl_func, "Bad boolean list specified for parameter %s", parname);
                    return CPL_ERROR_ILLEGAL_INPUT;
                }
                break;

            case (MF_BLIST):
                if (!mf_wrap_strlst_is_valid(strlst, MF_WRAP_STRLST_BOOL)) {
                    cpl_msg_error(cpl_func, "Bad boolean list specified for parameter %s", parname);
                    return CPL_ERROR_ILLEGAL_INPUT;
                }
                break;

        } /*end switch strlst_type*/
    }

    if (err != CPL_ERROR_NONE) {
        return err;
    }

    /* If the type is a range list then check that there is an even number of elements */
    int nelems = mf_strlst_get_size(strlst);
    if (strlst_type == MF_DRANGE || strlst_type == MF_NRANGE || strlst_type == MF_N0RANGE) {
        if (nelems % 2 != 0) {
            cpl_msg_error(cpl_func, "Range list parameter %s has odd number of elements", parname);
            err = CPL_ERROR_ILLEGAL_INPUT;
            return err;
        }
    }


    /* If N list or N range check that all values are positive */
    if (strlst_type == MF_NRANGE || strlst_type == MF_NLIST) {
        cpl_boolean non_positive_integer = CPL_FALSE;
        for (int idx = 1; idx <= nelems; idx++) {
            int ival = mf_strlst_get_int(strlst, idx);
            if (ival < 1) {
                non_positive_integer = CPL_TRUE;
            }
        }
        if (non_positive_integer) {
            cpl_msg_error(cpl_func, "Range list parameter %s has invalid non positive values", parname);
            err = CPL_ERROR_ILLEGAL_INPUT;
            return err;
        }
    }


    /* If N0 list or N0 range check that all values are positive or zero*/
    if (strlst_type == MF_N0RANGE || strlst_type == MF_N0LIST) {
        cpl_boolean negative_integer = CPL_FALSE;
        for (int idx = 1; idx <= nelems; idx++) {
            int ival = mf_strlst_get_int(strlst, idx);
            if (ival < 0) {
                negative_integer = CPL_TRUE;
            }
        }
        if (negative_integer) {
            cpl_msg_error(cpl_func, "Range list parameter %s has invalid negative values", parname);
            err = CPL_ERROR_ILLEGAL_INPUT;
            return err;
        }
    }
    cpl_msg_info(cpl_func, "Syntax format for parameter %s  OK", parname);
    return err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given wlc_n and wlc_const are compatible strings.
 *
 * @param char*      wlc_n_str          wlc poly order string list
 * @param char*      wlc_c_str          wlc const value string list
 * @param char*      nchips             No of actual chips
 *
 * @return           Error if any input molecule is not listed in the Ref Atmos file
 *
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_error_code mf_wrap_config_mappingchk(
    const cpl_frameset      *frameset,
    const cpl_parameterlist *parlist,
    const char              *library,
    const char              *lib_map,
    const char              *ext_column,
    const char              *map_parname,
    const char              *target_tag
)
{
    cpl_msg_info(cpl_func, "Validating any declared mappings to %s ...", library);

    cpl_boolean chk_numbers_match = CPL_TRUE;
    if (!strcmp(target_tag, "NULL")) {
        chk_numbers_match = CPL_FALSE;
    }

    /* Check the input parameters */
    if (!frameset) {
        cpl_error_code err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_msg_error(cpl_func, "Invalid frameset!");
        cpl_error_set_message(cpl_func, err, "Error in handling frameset!");
        return err;
    }

    if (!parlist) {
        cpl_error_code err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_msg_error(cpl_func, "Invalid parameter list!");
        cpl_error_set_message(cpl_func, err, "Error in handling parameter list!");
        return err;
    }

    cpl_boolean          chip_extensions = CPL_FALSE;
    const cpl_parameter *p               = cpl_parameterlist_find_const(parlist, MOLECFIT_PARAMETER_CHIP_EXTENSIONS);
    if (parlist) {
        chip_extensions = cpl_parameter_get_bool(p);
    }
    if (chip_extensions && strcmp(target_tag, "SCIENCE") == 0) {
        cpl_msg_info(
            cpl_func, "\t Using chip extensions with SCIENCE frame so skipping SCIENCE related mapping checks"
        );
        return CPL_ERROR_NONE;
    }


    /* FIRST CHECK THAT THERE IS A LIBRARY FILE WITH EXTENSIONS */
    const cpl_frame *frame = cpl_frameset_find_const(frameset, library);
    if (!frame) {
        cpl_msg_info(cpl_func, "\tThere is no specified frame with tag %s so nothing to check", library);
        return CPL_ERROR_NONE;
    }

    /* Get the no of extensions in this library frame */
    cpl_size    n_ext = cpl_frame_get_nextensions(frame);
    const char *str;
    str = (n_ext == 1) ? "extension" : "extensions";
    cpl_msg_info(cpl_func, "\tFound frame %s with %lld %s", library, n_ext, str);


    /* NOW CHECK FOR ANY MAPPINGS TO THE LIBRARY EXTENSIONS */

    cpl_msg_info(cpl_func, "\tChecking that the %s parameter declares a valid  mapping to %s:", map_parname, library);
    if (chk_numbers_match) {
        cpl_msg_info(cpl_func, "\tChecking that the numbers match.");
    }

    const cpl_parameter *par;


    /* Now check for a MAPPING KERNEL declaration in the MODEL_MAPPING_KERNEL parameter of the.rc file */
    /*parname = MOLECFIT_MODEL_MAPPING_KERNE*/
    par = cpl_parameterlist_find_const(parlist, map_parname);
    if (!par) {
        cpl_error_code err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_msg_error(cpl_func, "Cannot find parameter %s", map_parname);
        cpl_error_set_message(cpl_func, err, "Error in parameter %s appears to be missing!", map_parname);
        return err;
    }

    const char *string = cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, map_parname));

    /* We have a string value for the MAPPING  now check it */
    cpl_error_code mapping_err = CPL_ERROR_NONE;
    cpl_size       n_mappings;
    cpl_size       n_non_primary_mappings;


    /* Check if this string is "NULL" in which case look up for a mapping file or a string list of values*/
    if (mf_strlst_is_null(string)) {
        /* Parameter value is NULL so look for a mapping file */

        const cpl_frame *map_frame = cpl_frameset_find_const(frameset, lib_map);
        const char      *filename  = cpl_frame_get_filename(map_frame);
        cpl_table       *map_table = NULL;
        if (filename) {
            map_table = cpl_table_load(filename, 1, 0);
        }

        if (!map_table) {
            cpl_msg_info(
                cpl_func, "\t%s String is null. Looking for a mapping frame %s  .... Not Found!", map_parname, lib_map
            );
            cpl_msg_error(cpl_func, "\tUnable to find mapping table in valid %s frame!", lib_map);
            return CPL_ERROR_ILLEGAL_INPUT;
        }
        cpl_msg_info(cpl_func, "\t%s String is null. Looking for a mapping frame %s  .... Found", map_parname, lib_map);

        /*cpl_table_dump(map_table, 0, cpl_table_get_nrow(map_table), NULL);                */
        cpl_msg_info(cpl_func, "\t\tChecking main table values of %s are within bounds.", lib_map);

        /* Extract the extension values from the column of the form: _EXT */
        /* and check that they are within bounds */
        cpl_size n          = cpl_table_get_nrow(map_table);
        cpl_size n_non_zero = 0;
        for (cpl_size i = 0; i < n; i++) {
            /*int ival = cpl_table_get_int (mapping_kernel_tst,"KERNEL_LIBRARY_EXT",i,NULL);*/
            long long llval = cpl_table_get_long_long(map_table, ext_column, i, NULL);
            if (llval < 0) {
                cpl_msg_error(cpl_func, "Row %lld of the MAPPING TABLE has -ve extension value %lld", i + 1, llval);
                mapping_err = CPL_ERROR_ILLEGAL_INPUT;
            }
            if (llval > n_ext) {
                cpl_msg_error(
                    cpl_func,
                    "Row %lld of the MAPPING TABLE has extension value %lld which is > than number of extensions in "
                    "Library (%lld)",
                    i + 1, llval, n_ext
                );
                mapping_err = CPL_ERROR_ILLEGAL_INPUT;
            }
            if (llval > 0 && llval <= n_ext) {
                n_non_zero++;
            }
            /*cpl_msg_info(cpl_func,"Row %lld = %lld", i, llval);           */
        }
        if (!mapping_err) {
            cpl_msg_info(cpl_func, "\t\tAll mappings are to valid extension numbers.");
        }

        if (map_table) {
            cpl_free(map_table);
        }

        n_mappings             = n;
        n_non_primary_mappings = n_non_zero;
    }
    else {
        /* Parameter value is a string list so check its integer elements are within bounds */

        int nelems     = mf_strlst_get_size(string);
        int n_non_zero = 0;
        for (int i = 1; i <= nelems; i++) {
            int ival = mf_strlst_get_int(string, i);
            if (ival < 0) {
                cpl_msg_error(cpl_func, "Item %d of the MAPPING string list has -ve extension value %d", i + 1, ival);
                mapping_err = CPL_ERROR_ILLEGAL_INPUT;
            }
            if (ival > n_ext) {
                cpl_msg_error(
                    cpl_func,
                    "Item %d of the MAPPING string list has extension value %d which is > than number of extensions in "
                    "Library (%lld)",
                    i + 1, ival, n_ext
                );
                mapping_err = CPL_ERROR_ILLEGAL_INPUT;
            }
            if (ival > 0 && ival <= n_ext) {
                n_non_zero++;
            }
        }

        n_mappings             = nelems;
        n_non_primary_mappings = n_non_zero;
    }


    /* Report if there is a mapping error */
    if (mapping_err) {
        cpl_error_set_message(cpl_func, mapping_err, "Invalid Mapping Definition %s", lib_map);
    }


    /* If requested check that the numbers match */
    if (!mapping_err && chk_numbers_match) {
        cpl_msg_info(
            cpl_func, "\t\tChecking that there are the same no of non primary mappings as there are extensions in %s",
            target_tag
        );
        const cpl_frame *target_frame = cpl_frameset_find_const(frameset, target_tag);

        if (!target_frame) {
            cpl_msg_info(cpl_func, "\t\tThere is no specified frame with tag %s so nothing to check", target_tag);
            return CPL_ERROR_NONE;
        }
        /* Get the no of extensions in this library frame */
        cpl_size n_ext_target = cpl_frame_get_nextensions(target_frame);
        if (n_ext == n_non_primary_mappings) {
            cpl_msg_info(
                cpl_func, "\t\tFound target_frame %s with %lld extensions.   ... Numbers match.", target_tag,
                n_ext_target
            );
        }
        else {
            cpl_msg_info(
                cpl_func, "\t\tFound target_frame %s with %lld extensions.   ... Numbers do not match!", target_tag,
                n_ext_target
            );
            cpl_msg_info(
                cpl_func, "\t\t Number of mappings found=%lld. Number of non primary mappings found=%lld", n_mappings,
                n_non_primary_mappings
            );
            cpl_msg_error(cpl_func, "\t\t\t Problems with mapping!");
            mapping_err = CPL_ERROR_ILLEGAL_INPUT;
            cpl_error_set_message(cpl_func, mapping_err, "Mapping mismatch for %s to %s", map_parname, target_tag);
        }
    }

    return mapping_err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given fits data contains the specific header keyword
 *
 * @param mf_wrap_fits* data         Loaded fits data.
 * @param char*          keyword      Name of keyword to look for
 *
 * @return             Error if keyword is not present.
 *
 *
 */
/* ---------------------------------------------------------------------------*/

cpl_error_code
mf_wrap_config_check_keyword(const mf_wrap_fits *fits_data, const cpl_parameterlist *parlist, const char *keyword_par)
{
    if (fits_data == NULL) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    if (keyword_par == NULL) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    const cpl_parameter *par     = cpl_parameterlist_find_const(parlist, keyword_par);
    const char          *keyword = cpl_parameter_get_string(par);

    unsigned long keyword_len = strlen(keyword);
    if (keyword_len < 1) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    if (keyword_len == 4) {
        if ((keyword[0] == 'N' || keyword[0] == 'n') && (keyword[1] == 'O' || keyword[1] == 'o') &&
            (keyword[2] == 'N' || keyword[2] == 'n') && (keyword[3] == 'E' || keyword[3] == 'e')) {
            return CPL_ERROR_NONE;
        }
    }


    if (keyword_len == 3) {
        if ((keyword[0] == 'A' || keyword[0] == 'a') && (keyword[1] == 'N' || keyword[1] == 'n') &&
            (keyword[2] == 'Y' || keyword[2] == 'y')) {
            return CPL_ERROR_NONE;
        }
    }


    /* Check that there are extensions */
    if (!fits_data->v_ext) {
        cpl_msg_info(cpl_func, "No extensions found in target frame!");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    /* Iterate through each (non primary) extension*/

    cpl_size ext = 0;

    /* Skip if this extension does not have a header */
    if (!fits_data->v_ext[ext].header) {
        cpl_msg_info(cpl_func, "No primary header found in target frame");
        return CPL_ERROR_ILLEGAL_INPUT;
    }


    /* Note: this will be stored as a cpl_property element */
    const cpl_propertylist *pl     = fits_data->v_ext[ext].header;
    cpl_size                nprops = cpl_propertylist_get_size(pl);

    /* Iterate through all header property items looking for a name */
    /*   that ends with keyword, i.e. "*[keyword]                   */
    for (cpl_size i = 1; i < nprops; i++) {
        const cpl_property *p        = cpl_propertylist_get_const(pl, i);
        const char         *name     = cpl_property_get_name(p);
        unsigned long       name_len = strlen(name);
        if (name_len != keyword_len) {
            continue;
        }
        if (strcmp(keyword, name) == 0) {
            cpl_msg_info(cpl_func, "Looking for header keyword %s\t....Found", keyword);
            return CPL_ERROR_NONE;
        }
    }

    cpl_msg_info(cpl_func, "Looking for header keyword %s\t....Not Found!", keyword);
    return cpl_error_set_message(
        cpl_func, CPL_ERROR_ILLEGAL_INPUT, "Unable to find keyword %s in target file header!", keyword
    );
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given fits data contains tables with a column of given name
 *
 * @param mf_wrap_fits* data         Loaded fits data.
 * @param char*          col_name     Name of column to look for
 *
 * @return             Error if column does not exist
 *
 *
 */
/* ---------------------------------------------------------------------------*/


cpl_error_code mf_wrap_config_chk_column(const mf_wrap_fits *fits_data, const char *col_name)
{
    if (fits_data == NULL) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    if (col_name == NULL) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }


    if (mf_strlst_is_null(col_name)) {
        /* Column name is null. This is ok */
        return CPL_ERROR_NONE;
    }


    /* Check that there are extensions */
    if (!fits_data->v_ext) {
        cpl_msg_error(cpl_func, "No extensions found in target frame with column name: %s!", col_name);
        cpl_error_code err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_error_set_message(cpl_func, err, "Invalid science frame!");
        return err;
    }

    /* Iterate through each (non primary) extension*/

    cpl_boolean match_found_in_all_extensions = CPL_TRUE;
    for (cpl_size ext = 1; ext < fits_data->n_ext; ext++) {
        /* Skip if this extension does not have a header */
        if (!fits_data->v_ext[ext].header) {
            continue;
        }


        /* Find all TTYPE[n] components in the header */
        /* Note: this will be stored as a cpl_property element */
        const cpl_propertylist *pl     = fits_data->v_ext[ext].header;
        cpl_size                nprops = cpl_propertylist_get_size(pl);

        /* Iterate through all header property items looking for a name */
        /*   that starts "TTY"                                          */
        cpl_boolean match_found = CPL_FALSE;
        for (cpl_size i = 1; i < nprops; i++) {
            const cpl_property *p    = cpl_propertylist_get_const(pl, i);
            const char         *name = cpl_property_get_name(p);
            if (name[0] == 'T' && name[1] == 'T' && name[2] == 'Y') {
                /* This is a TTYP[n} header keyword now get the string value */
                const char *str_val = cpl_property_get_string(p);

                /* Check if this matches the given column name to look for */
                if (strcmp(str_val, col_name) == 0) {
                    cpl_msg_info(cpl_func, "Looking for column %s in extension %lld ... Found.", col_name, ext);
                    match_found = CPL_TRUE;
                }
            } /* end if name = "TTY*"*/

        } /* end for i*/

        if (!match_found) {
            cpl_msg_info(cpl_func, "Looking for column %s in extension %lld ... Not found.", col_name, ext);
            match_found_in_all_extensions = CPL_FALSE;
        }

    } /* end for ext */


    if (!match_found_in_all_extensions) {
        cpl_msg_error(cpl_func, "Could not find column %s in any extension of the data frame!", col_name);
        cpl_error_code err = CPL_ERROR_ILLEGAL_INPUT;
        cpl_error_set_message(cpl_func, err, "Could not find column %s as required!", col_name);
        return err;
    }


    return CPL_ERROR_NONE;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given ref atmos file lists all required molecules.
 *
 * @param char*      dirname          Path to Telliccorr data
 * @param char*      filename         Name of chosen Ref Atmos fits file
 * @param cpl_table* molecules        Table of molecules given as input parameters
 *
 * @return           Error if any input molecule is not listed in the Ref Atmos file
 *
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_error_code mf_config_chk_ref_atmos(const char *dirname, const char *filename, const cpl_table *molecules)
{
    /* Check input */
    if (!dirname) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    if (!filename) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    if (!molecules) {
        cpl_msg_info(cpl_func, "No molecules!");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    /* Get the actual Ref Atmos fits file */
    const char *subpath = "/profiles/mipas/";

    char *fullpathname = cpl_sprintf("%s%s%s", dirname, subpath, filename);
    cpl_msg_info(cpl_func, "Checking Reference Atmosphere file: %s", fullpathname);
    mf_wrap_fits *rat_data = NULL;

    /* Load up Ref Atmos fits file into table data */
    rat_data = mf_wrap_fits_load(fullpathname, CPL_FALSE);

    /* Check the Ref Atmos table data */
    if (!rat_data) {
        cpl_msg_info(cpl_func, "Unable to open rat data file %s!", fullpathname);
        cpl_free(fullpathname);
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    cpl_free(fullpathname);
    /* Search for a bintable within this data*/
    cpl_array *column_names = NULL;
    cpl_size   n_cols       = 0;
    for (cpl_size ext = 0; ext < rat_data->n_ext; ext++) {
        /* Skip if this extension does not have a bintable */
        if (!rat_data->v_ext[ext].table) {
            continue;
        }

        /* Get the table details */
        const cpl_table *table = rat_data->v_ext[ext].table;
        n_cols                 = cpl_table_get_ncol(table);
        column_names           = cpl_table_get_column_names(table);
        break;
    }

    /* Check that we have a valid bin table from the fits file */
    if (!column_names) {
        cpl_msg_info(cpl_func, "Unable to find Molecular data in %s", filename);
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    /* Iterate through the columns and list all molecules */
    /* (note this is all other than "HGT", "PRE" and "TEM")     */
    char   **colname  = cpl_array_get_data_string(column_names);
    cpl_size max_size = n_cols * 10;
    char     str_lst[max_size];
    str_lst[0] = '\0';
    for (cpl_size col = 0; col < n_cols; col++) {
        const char *name = colname[col];
        if (strcmp(name, "HGT") == 0) {
            continue;
        }
        if (strcmp(name, "PRE") == 0) {
            continue;
        }
        if (strcmp(name, "TEM") == 0) {
            continue;
        }
        if (str_lst[0] != '\0') {
            strcat(str_lst, ",");
        }
        strcat(str_lst, name);
    }

    cpl_msg_info(cpl_func, "%s contains details on the following molecules:", filename);
    cpl_msg_info(cpl_func, "%s", str_lst);

    /** Now lets go through each molecule in the molecule table */
    cpl_size n_mols      = cpl_table_get_ncol(molecules);
    n_mols               = cpl_table_get_nrow(molecules);
    cpl_boolean all_fine = CPL_TRUE;
    for (cpl_size i = 0; i < n_mols; i++) {
        /* Get the molecule name at this table index*/
        const char *mol_name = cpl_table_get_string(molecules, "LIST_MOLEC", i);

        /* Is this molecule in the file list of molecules */
        cpl_boolean isok = mf_wrap_config_str_isin_strlst(mol_name, str_lst);
        if (isok) {
            cpl_msg_info(cpl_func, "\tDoes list contain molecule %s ... Yes", mol_name);
        }
        if (!isok) {
            cpl_msg_info(cpl_func, "\tDoes list contain molecule %s ... No!", mol_name);
        }
        if (!isok) {
            all_fine = CPL_FALSE;
        }
    }

    /* Free up the allocations */
    if (column_names) {
        cpl_free(column_names);
    }
    if (rat_data) {
        cpl_free(rat_data);
    }

    /* Report error if not fine */
    if (!all_fine) {
        cpl_msg_info(cpl_func, "Not all requested molecules are contained in the atmos ref file");
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    return CPL_ERROR_NONE;
}

cpl_boolean mf_wrap_config_str_isin_strlst(const char *inp_str, const char *options_strlst)
{
    /* Iterate through the options string list to see if the list contains this string value*/
    unsigned long inp_str_size        = strlen(inp_str);
    int           nelems              = mf_strlst_get_size(options_strlst);
    cpl_boolean   found               = CPL_FALSE;
    unsigned long options_strlst_size = strlen(options_strlst);
    char          str_elem[options_strlst_size];
    for (int idx = 1; idx <= nelems; idx++) {
        cpl_boolean flag = mf_strlst_get_bool_err(options_strlst, idx, str_elem);
        if (flag == CPL_FALSE) {
            continue;
        }
        unsigned long str_size = strlen(str_elem);
        if (str_size != inp_str_size) {
            continue;
        }

        /* Strings are the same length so check that they are identical */
        cpl_boolean is_same = CPL_TRUE;
        for (unsigned long i = 0; i < inp_str_size; i++) {
            if (str_elem[i] != inp_str[i]) {
                is_same = CPL_FALSE;
            }
        }

        if (is_same) {
            found = CPL_TRUE;
            break;
        }
    }

    return found;
}


/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given gdas_prof is a valid values.
 *
 * @param char*      gdas_prof        Supplied value for gdas profile
 *
 * @return           Error if specified file cannot be found.
 *
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_error_code mf_config_chk_gdas_prof(const char *gdas_prof)
{
    /* Check that gdas_prof is not "auto" or "none" */
    if (strcmp(gdas_prof, "auto") == 0) {
        return CPL_ERROR_NONE;
    }
    if (strcmp(gdas_prof, "AUTO") == 0) {
        return CPL_ERROR_NONE;
    }
    if (strcmp(gdas_prof, "none") == 0) {
        return CPL_ERROR_NONE;
    }
    if (strcmp(gdas_prof, "NONE") == 0) {
        return CPL_ERROR_NONE;
    }
    if (strcmp(gdas_prof, "null") == 0) {
        return CPL_ERROR_NONE;
    }
    if (strcmp(gdas_prof, "NULL") == 0) {
        return CPL_ERROR_NONE;
    }

    /* Assume that this is a given filename and check that it exists*/
    cpl_error_code file_err = access(gdas_prof, F_OK);

    if (!file_err) {
        cpl_msg_info(cpl_func, "GDAS Profile file %s Exists .... Yes", gdas_prof);
    }
    if (file_err) {
        cpl_msg_info(cpl_func, "GDAS Profile file %s Exists .... No!", gdas_prof);
    }
    if (file_err) {
        cpl_msg_info(cpl_func, "Invalid GDAS Profile. Cannot find file %s", gdas_prof);
    }

    return file_err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given lnfl line data base exists.
 *
 * @param char*      dirname          Path to Telliccorr data
 * @param char*      db               Name of chosen database file
 *
 * @return           Error if any input molecule is not listed in the Ref Atmos file
 *
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_error_code mf_config_chk_lnfl_line_db(const char *dirname, const char *db)
{
    /* Check input */
    if (!dirname) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }
    if (!db) {
        return CPL_ERROR_ILLEGAL_INPUT;
    }

    /* Get the actual lnfl_line_db file pathname */
    const char *subpath = "/hitran/";

    char *fullpathname = cpl_sprintf("%s%s%s", dirname, subpath, db);
    cpl_msg_info(cpl_func, "Checking LNFL Line DataBase file: %s", fullpathname);

    /* Assume that this is a given filename and check that it exists*/
    cpl_error_code file_err = access(fullpathname, F_OK);

    if (!file_err) {
        cpl_msg_info(cpl_func, "LNFL database  %s Exists .... Yes", db);
    }
    if (file_err) {
        cpl_msg_info(cpl_func, "LNFL database  %s Exists .... No!", db);
    }
    if (file_err) {
        cpl_msg_error(cpl_func, "Invalid LNFL database %s", db);
    }

    cpl_free(fullpathname);
    return file_err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Check that given string is one of a list of string values
 *
 * @param str         The string to split.
 * @param delimiter   String specifying the locations where to split.
 * @param size        (Output) If non NULL, the number of found tokens is returned.
 *
 * @return err
 *
 *
 */
/* ---------------------------------------------------------------------------*/

cpl_error_code
mf_wrap_config_stroptchk(const cpl_parameterlist *parlist, const char *parname, const char *options_strlst)
{
    cpl_error_code       err;
    const cpl_parameter *par;

    err = CPL_ERROR_NONE;


    /* Check that the parameter name is legal */
    if (!err) {
        par = cpl_parameterlist_find_const(parlist, parname);
        if (!par) {
            cpl_msg_error(cpl_func, "Invalid parameter %s.", parname);
            return CPL_ERROR_ILLEGAL_INPUT;
        }
    }

    /* Check that the options string list is a valid string list */
    if (!err) {
        if (!mf_wrap_strlst_is_valid(options_strlst, MF_WRAP_STRLST_STRING)) {
            cpl_msg_error(cpl_func, "Invalid string list %s", options_strlst);
            return CPL_ERROR_ILLEGAL_INPUT;
        }
    }


    /* Now check that the parameter string value is in the string list*/
    if (!err) {
        /* Get the parameter as a string value */
        const char   *par_str     = cpl_parameter_get_string(cpl_parameterlist_find_const(parlist, parname));
        unsigned long parstr_size = strlen(par_str);

        /* Iterate through the options string list to see if the list contains this string value*/
        int         nelems = mf_strlst_get_size(options_strlst);
        cpl_boolean found  = CPL_FALSE;
        char        str_elem[parstr_size];
        for (int idx = 1; idx <= nelems; idx++) {
            cpl_boolean flag = mf_strlst_get_bool_err(options_strlst, idx, str_elem);
            if (flag == CPL_FALSE) {
                continue;
            }
            unsigned long str_size = strlen(str_elem);
            if (str_size != parstr_size) {
                continue;
            }

            /* Strings are same length so check if each character is identical*/
            cpl_boolean is_same = CPL_TRUE;
            for (unsigned long i = 0; i < parstr_size; i++) {
                if (str_elem[i] != par_str[i]) {
                    is_same = CPL_FALSE;
                }
            }
            if (is_same) {
                found = CPL_TRUE;
                break;
            }
        }

        /* If not found then falg illegal input error */
        if (!found) {
            cpl_msg_error(
                cpl_func, "Invalid option %s. Parameter value of %s must be one of: %s", par_str, parname,
                options_strlst
            );
            err = CPL_ERROR_ILLEGAL_INPUT;
        }
    }

    if (err) {
        cpl_msg_error(cpl_func, "%s parameter is not ok", parname);
    }

    cpl_msg_info(cpl_func, "%s parameter is ok", parname);

    return err;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Build one mapping cpl_table
 *
 * @param mapping_str        .
 * @param column_name        .
 *
 * @return cpl_error_code    CPL_ERROR_NONE is everything is OK.
 *                           If not, these are the errors:
 *                           - .
 *                           - Error in subroutine (see subroutines).
 *
 * @note .
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_table *mf_wrap_config_table_mapping(const char *mapping_str, const char *column_name)
{
    cpl_errorstate prestate = cpl_errorstate_get();

    cpl_msg_info(cpl_func, "mf_wrap_config_table_mapping: mapping_str = %s; %s", mapping_str, cpl_error_get_message());
    cpl_size n_tokens;
    char   **tokens = mf_str_split(mapping_str, ",", &n_tokens);

    cpl_msg_info(cpl_func, "mf_wrap_config_table_mapping 2");
    /* Create mappingtab */
    cpl_table *mappingtab = cpl_table_new(n_tokens);
    cpl_table_new_column(mappingtab, column_name, CPL_TYPE_INT);

    cpl_msg_info(cpl_func, "mf_wrap_config_table_mapping 3");
    for (cpl_size i = 0; i < n_tokens; i++) {
        cpl_size ext_num = atoi(tokens[i]);
        cpl_table_set_int(mappingtab, column_name, i, ext_num);
        cpl_msg_info(cpl_func, "Column[%s] : Mapping input extension[%lld] to {%lld}", column_name, i, ext_num);
    }
    cpl_msg_info(cpl_func, "mf_wrap_config_table_mapping 4");

    /* Cleanup */
    mf_str_array_delete(tokens);

    /* Check possible errors */
    if (!cpl_errorstate_is_equal(prestate) || cpl_error_get_code() != CPL_ERROR_NONE) {
        cpl_error_set_message(cpl_func, cpl_error_get_code(), "Building cpl_table mapping failed!");
        cpl_table_delete(mappingtab);
        return NULL;
    }
    else if (mappingtab) {
        cpl_msg_info(cpl_func, "cpl_table *mappingtab loaded :");
        //cpl_table_dump(mappingtab, 0, cpl_table_get_nrow(mappingtab), NULL);
    }

    return mappingtab;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Build the molecules Molecfit cpl_table.
 *
 * @param list_molec_str     .
 * @param fit_molec_str      .
 * @param rel_col_str        .
 *
 * @return cpl_error_code    CPL_ERROR_NONE is everything is OK.
 *                           If not, these are the errors:
 *                           - .
 *                           - Error in subroutine (see subroutines).
 *
 * @note .
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_table *
mf_wrap_config_table_molecules(const char *list_molec_str, const char *fit_molec_str, const char *rel_col_str)
{
    cpl_msg_info(
        cpl_func, "mf_wrap_config_table_molecules: list_molec_str = %s; %s", list_molec_str, cpl_error_get_message()
    );
    cpl_errorstate prestate = cpl_errorstate_get();
    cpl_error_code err      = CPL_ERROR_NONE;

    cpl_size n_molec;

    char **list_molecs = mf_str_split(list_molec_str, ",", &n_molec);
    if (!list_molecs || n_molec <= 0) {
        err += cpl_error_set_message(
            cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT,
            "There has to be at least one molecule specified in the LIST_MOLEC parameter"
        );
    }
    for (cpl_size i = 0; i < n_molec && !err; i++) {
        if (mf_molecules_str_check(list_molecs[i]) != CPL_ERROR_NONE) {
            err += cpl_error_set_message(
                cpl_func, cpl_error_get_code(), "Invalid molecule %s specified in the LIST_MOLEC parameter",
                list_molecs[i]
            );
        }
    }

    char **fit_molecs = mf_str_split(fit_molec_str, ",", &n_molec);
    if (!fit_molecs || n_molec <= 0) {
        err += cpl_error_set_message(
            cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT,
            "There has to be at least one boolean flag specified in the FIT_MOLEC parameter"
        );
    }
    for (cpl_size i = 0; i < n_molec; i++) {
        int fit_molec = atoi(fit_molecs[i]);
        if (fit_molec != 0 && fit_molec != 1) {
            err += cpl_error_set_message(
                cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT,
                "Unexpected value %d in the FIT_MOLEC list parameter. Expected a boolean, 0 or 1", fit_molec
            );
        }
    }

    char **rel_cols = mf_str_split(rel_col_str, ",", &n_molec);
    if (!rel_cols || n_molec <= 0) {
        err += cpl_error_set_message(
            cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT,
            "It is necessary to have at least one relative value specified in the REL_COL parameter."
        );
    }
    for (cpl_size i = 0; i < n_molec; i++) {
        double rel_col = strtod(rel_cols[i], NULL);
        if (rel_col < 0.) {
            err += cpl_error_set_message(
                cpl_func, CPL_ERROR_INCOMPATIBLE_INPUT,
                "Unexpected value %f in the REL_COL list parameter. It must be >= 0.", rel_col
            );
        }
    }

    /* Check fails */
    if (err != CPL_ERROR_NONE) {
        if (list_molecs) {
            mf_str_array_delete(list_molecs);
        }
        if (fit_molecs) {
            mf_str_array_delete(fit_molecs);
        }
        if (rel_cols) {
            mf_str_array_delete(rel_cols);
        }
        return NULL;
    }

    /* Create Molecules */
    cpl_table *molectab = cpl_table_new(n_molec);
    cpl_table_new_column(molectab, MF_COL_LIST_MOLECULES, CPL_TYPE_STRING);
    cpl_table_new_column(molectab, MF_COL_FIT_MOLECULES, CPL_TYPE_INT);
    cpl_table_new_column(molectab, MF_COL_REL_COL, CPL_TYPE_DOUBLE);

    /* Insert molecules properties in the cpl_table */
    for (cpl_size i = 0; i < n_molec; i++) {
        int    fit    = atoi(fit_molecs[i]);
        double relcol = strtod(rel_cols[i], NULL);

        cpl_table_set_string(molectab, MF_COL_LIST_MOLECULES, i, list_molecs[i]);
        cpl_table_set_int(molectab, MF_COL_FIT_MOLECULES, i, fit);
        cpl_table_set_double(molectab, MF_COL_REL_COL, i, relcol);

        cpl_msg_debug(cpl_func, "(mf_molecules ) Molecule[%s] -> Fit[%d] : rel_col[%lf]", list_molecs[i], fit, relcol);
    }

    /* Cleanup */
    mf_str_array_delete(list_molecs);
    mf_str_array_delete(fit_molecs);
    mf_str_array_delete(rel_cols);

    /* Check possible errors */
    if (!cpl_errorstate_is_equal(prestate) || cpl_error_get_code() != CPL_ERROR_NONE || !molectab) {
        cpl_error_set_message(cpl_func, cpl_error_get_code(), "Building cpl_table molecules failed!");
        cpl_table_delete(molectab);
        return NULL;
    }
    else {
        cpl_msg_info(cpl_func, "cpl_table *molecules loaded :");
        //cpl_table_dump(molectab, 0, cpl_table_get_nrow(molectab), NULL);
    }

    return molectab;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Build the wave/pixel range Molecfit cpl_table
 *
 * @param range_str          .
 * @param type               .
 *
 * @return cpl_error_code    CPL_ERROR_NONE is everything is OK.
 *                           If not, these are the errors:
 *                           - .
 *                           - Error in subroutine (see subroutines).
 *
 * @note .
 *
 */
/* ---------------------------------------------------------------------------*/
cpl_table *mf_wrap_config_table_ranges(const char *range_str, cpl_type type)
{
    cpl_errorstate prestate = cpl_errorstate_get();
    cpl_msg_info(cpl_func, "mf_wrap_config_table_ranges: range_str = %s; %s", range_str, cpl_error_get_message());

    /*** Wavelength ranges ***/
    cpl_size n_range_tokens;
    char   **ranges  = mf_str_split(range_str, ",", &n_range_tokens);
    cpl_size n_range = n_range_tokens / 2;

    /* Create rangetab */
    cpl_table *rangetab = cpl_table_new(n_range);
    cpl_table_new_column(rangetab, MF_COL_WAVE_RANGE_LOWER, type);
    cpl_table_new_column(rangetab, MF_COL_WAVE_RANGE_UPPER, type);

    for (cpl_size i = 0; i < n_range; i++) {
        cpl_size idx = i * 2;

        if (type == CPL_TYPE_DOUBLE) {
            double start = strtod(ranges[idx], NULL);
            double end   = strtod(ranges[idx + 1], NULL);

            cpl_table_set_double(rangetab, MF_COL_WAVE_RANGE_LOWER, i, start);
            cpl_table_set_double(rangetab, MF_COL_WAVE_RANGE_UPPER, i, end);

            cpl_msg_info(cpl_func, "range[%lld] = {%g, %g}", i, start, end);
        }
        else if (type == CPL_TYPE_INT) {
            int start = atoi(ranges[idx]);
            int end   = atoi(ranges[idx + 1]);

            cpl_table_set_int(rangetab, MF_COL_WAVE_RANGE_LOWER, i, start);
            cpl_table_set_int(rangetab, MF_COL_WAVE_RANGE_UPPER, i, end);

            cpl_msg_info(cpl_func, "range[%lld] = {%i, %i}", i, start, end);
        }
        else {
            cpl_error_set_message(cpl_func, cpl_error_get_code(), "Building cpl_table ranges failed!");
            cpl_table_delete(rangetab);
            return NULL;
        }
    }


    /* Cleanup */
    mf_str_array_delete(ranges);
    cpl_msg_info(cpl_func, "Done deleting");


    /* Check possible errors */
    if (!cpl_errorstate_is_equal(prestate) || cpl_error_get_code() != CPL_ERROR_NONE) {
        cpl_error_set_message(cpl_func, cpl_error_get_code(), "Building cpl_table ranges failed!");
        cpl_table_delete(rangetab);
        return NULL;
    }
    else if (rangetab) {
        cpl_msg_info(cpl_func, "cpl_table *rangetab loaded :");
        //cpl_table_dump(rangetab, 0, cpl_table_get_nrow(rangetab), NULL);
    }

    return rangetab;
}

/*----------------------------------------------------------------------------*/
/**
 * @brief  Get Molecfit config parameters from the input recipe parameter list
 *
 * @param  list                          .
 * @param  data_primary_header           .
 * @param  pl                            .
 *
 * @return   cpl_error_code
 */
/*----------------------------------------------------------------------------*/
mf_configuration *mf_wrap_config_get_parameters(
    const cpl_parameterlist *list,
    const cpl_propertylist  *data_primary_header,
    cpl_propertylist        *pl
)
{
    /* Check input */
    cpl_error_ensure(list && data_primary_header && pl, CPL_ERROR_NULL_INPUT, return NULL, "list input is NULL!");

    /* Get preState */
    cpl_errorstate       pre_state = cpl_errorstate_get();
    const cpl_parameter *p;


    /*** Molecfit default configuration ***/
    cpl_msg_info(cpl_func, "Load Molecfit default configuration ...");
    mf_configuration *mf_config = mf_configuration_create();
    if (!mf_config) {
        cpl_error_set_message(cpl_func, CPL_ERROR_ILLEGAL_OUTPUT, "Error loading Molecfit default configuration");
        return NULL;
    }


    /*** Set Molecfit configuration with recipe parameters ***/
    mf_parameters_directories  *directories  = &(mf_config->parameters->directories);
    mf_parameters_inputs       *inputs       = &(mf_config->parameters->inputs);
    mf_parameters_fitting      *fitting      = &(mf_config->parameters->fitting);
    mf_parameters_ambient      *ambient      = &(mf_config->parameters->ambient);
    mf_parameters_instrumental *instrumental = &(mf_config->parameters->instrumental);
    mf_parameters_atmospheric  *atmospheric  = &(mf_config->parameters->atmospheric);


    /*** Directories ***/
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELLURICCORR_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->telluric_path) {
                cpl_free(directories->telluric_path);
            }
            directories->telluric_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELLURICCORR_PATH, directories->telluric_path
            );
        }
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELLURICCORR_DATA_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->telluriccorr_data_path) {
                cpl_free(directories->telluriccorr_data_path);
            }
            directories->telluriccorr_data_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELLURICCORR_DATA_PATH,
                directories->telluriccorr_data_path
            );
        }
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TMP_PATH);
    if (p) {
        if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT) != 0) {
            if (directories->tmp_path) {
                cpl_free(directories->tmp_path);
            }
            directories->tmp_path = cpl_strdup(cpl_parameter_get_string(p));
            cpl_propertylist_update_string(
                pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TMP_PATH, directories->tmp_path
            );
        }
    }

    /*p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OUTPUT_PATH);
  if (p) {
      if (strcmp(cpl_parameter_get_string(p), MOLECIFT_TELLURICCORR_PARAMETER_DEFAULT)) {
          if (directories->output_path) cpl_free(directories->output_path);
          directories->output_path = cpl_strdup(cpl_parameter_get_string(p));
          cpl_propertylist_update_string(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OUTPUT_PATH, directories->output_path);
      }
  }*/

    /*p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OUTPUT_NAME);
  if (p) {
      if (directories->output_name) cpl_free(directories->output_name);
      directories->output_name = cpl_strdup(cpl_parameter_get_string(p));
      cpl_propertylist_update_string(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OUTPUT_NAME, directories->output_name);
  }*/


    /*** Input parameters ***/

    /* p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OMP_NUM_THREADS);
  if (p) {
      inputs->omp_num_threads = cpl_parameter_get_int(p);
      cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OMP_NUM_THREADS, inputs->omp_num_threads);
  }*/

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_SILENT_EXTERNAL_BINS);
    if (p) {
        inputs->silent_external_bins = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SILENT_EXTERNAL_BINS, inputs->silent_external_bins
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TRANSMISSION);
    if (p) {
        inputs->transmission = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TRANSMISSION, inputs->transmission
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_COLUMN_LAMBDA);
    if (p) {
        if (inputs->column_lambda) {
            cpl_free(inputs->column_lambda);
        }
        inputs->column_lambda = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_LAMBDA, inputs->column_lambda
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_COLUMN_FLUX);
    if (p) {
        if (inputs->column_flux) {
            cpl_free(inputs->column_flux);
        }
        inputs->column_flux = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_FLUX, inputs->column_flux
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_COLUMN_DFLUX);
    if (p) {
        if (inputs->column_dflux) {
            cpl_free(inputs->column_dflux);
        }
        inputs->column_dflux = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_DFLUX, inputs->column_dflux
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_COLUMN_MASK);
    if (p) {
        if (inputs->column_mask) {
            cpl_free(inputs->column_mask);
        }
        inputs->column_mask = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_COLUMN_MASK, inputs->column_mask
        );
    }


    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_DEFAULT_ERROR);
    if (p) {
        inputs->default_error = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_DEFAULT_ERROR, inputs->default_error
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_WLG_TO_MICRON);
    if (p) {
        inputs->wlg_to_micron = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLG_TO_MICRON, inputs->wlg_to_micron
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_WAVELENGTH_FRAME);
    if (p) {
        if (inputs->wavelengths_frame) {
            cpl_free(inputs->wavelengths_frame);
        }
        inputs->wavelengths_frame = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WAVELENGTH_FRAME, inputs->wavelengths_frame
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OBSERVATORY_ERF_RV_KEYWORD);
    if (p) {
        if (inputs->observing_erv_rv.key) {
            cpl_free(inputs->observing_erv_rv.key);
        }
        inputs->observing_erv_rv.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVATORY_ERF_RV_KEYWORD, inputs->observing_erv_rv.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OBSERVATORY_ERF_RV_VALUE);
    if (p) {
        inputs->observing_erv_rv.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVATORY_ERF_RV_VALUE, inputs->observing_erv_rv.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_CLEAN_MODEL_FLUX);
    if (p) {
        inputs->clean_flux = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CLEAN_MODEL_FLUX, inputs->clean_flux
        );
    }


    /*** Fitting ***/

    /* Convergence criterion */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FTOL);
    if (p) {
        fitting->ftol = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FTOL, fitting->ftol);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_XTOL);
    if (p) {
        fitting->xtol = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_XTOL, fitting->xtol);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FLUX_UNIT);
    if (p) {
        fitting->flux_unit = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FLUX_UNIT, fitting->flux_unit);
    }


    /*** EXPERT FITTING OPTIONS ***/
    /*
    CHIP and RANGE FIT OPTIONS:
      This if from the old molecfit expert options of:
          fit_chip1 =1 or 0
          fit_chip2 =1 or 0
          fit_chip3 =1 or 0
          fit_chip4 =1 or 0
          fit_range1=1 or 0
          fit_range2=1 or 0
          fit_range3=1 or 0
          fit_range4=1 or 0
      These are currently added for instrument scientist to play with
      and maybe later decide of how to use.
  */

    /* FIT_CHIP[1-4]*/
    p = cpl_parameterlist_find_const(list, "FIT_CHIP1");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP1 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_CHIP2");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP2 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_CHIP3");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP3 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_CHIP4");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_CHIP4 = %f. Ignored as this parameter is now obsolete.", dval);
    }


    /* FIT_RANGE[1-4]*/
    p = cpl_parameterlist_find_const(list, "FIT_RANGE1");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE1 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_RANGE2");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE2 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_RANGE3");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE3 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    p = cpl_parameterlist_find_const(list, "FIT_RANGE4");
    if (p) {
        double dval = cpl_parameter_get_double(p);
        cpl_msg_info(cpl_func, "FIT_RANGE4 = %f. Ignored as this parameter is now obsolete.", dval);
    }

    /* NOTE: The recipe parameter "FIT_RANGES" is a string of 1 and 0s deliminated with ',' character
           and the fitting->fit_ranges is a boolean vector so that telluriccor doen't have to
           parse the string to a vector of booleans */
    p = cpl_parameterlist_find_const(list, "FIT_CHIPS");
    if (p) {
        /* Get the string as specified in the .rc file */
        const char *flagstr = cpl_parameter_get_string(p);

        /* Parse the string into a set of 0s and 1s */
        int cnt = 0;
        for (int i = 0; i < (int)strlen(flagstr); i++) {
            if (flagstr[i] != '1' && flagstr[i] != '0') {
                continue;
            }
            cpl_msg_info(cpl_func, "CHIP %d -> %c", cnt, flagstr[i]);
            if (flagstr[i] == '1') {
                fitting->fit_chips[cnt] = CPL_TRUE;
            }
            if (flagstr[i] == '0') {
                fitting->fit_chips[cnt] = CPL_FALSE;
            }
            cnt++;
        }
        if (cnt > 0) {
            fitting->fit_n_cflags = cnt;
        }
        cpl_msg_info(cpl_func, "N CHIP FLAGS DEFINED = %d", fitting->fit_n_cflags);

        cpl_propertylist_update_string(
            pl,
            MF_PARAMETERS_CONTEX_DEFAULT " "
                                         "FIT_CHIPS",
            flagstr
        );
    }


    /* NOTE: The recipe parameter "FIT_RANGES" is a string of 1 and 0s deliminated with ',' character
           and the fitting->fit_ranges is a boolean vector so that telluriccor doen't have to
           parse the string to a vector of booleans */
    p = cpl_parameterlist_find_const(list, "FIT_RANGES");
    if (p) {
        /* Get the string as specified in the .rc file */
        const char *flagstr = cpl_parameter_get_string(p);

        /* Parse the string into a set of 0s and 1s */
        int cnt = 0;
        for (size_t i = 0; i < strlen(flagstr); i++) {
            if (flagstr[i] != '1' && flagstr[i] != '0') {
                continue;
            }
            cpl_msg_info(cpl_func, "RANGE %d -> %c", cnt, flagstr[i]);
            if (flagstr[i] == '1') {
                fitting->fit_ranges[cnt] = CPL_TRUE;
            }
            if (flagstr[i] == '0') {
                fitting->fit_ranges[cnt] = CPL_FALSE;
            }
            cnt++;
        }
        if (cnt > 0) {
            fitting->fit_n_rflags = cnt;
        }

        cpl_propertylist_update_string(
            pl,
            MF_PARAMETERS_CONTEX_DEFAULT " "
                                         "FIT_RANGES",
            flagstr
        );
    }


    /* Telelescope background */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FIT_TELESCOPE_BACK);
    if (p) {
        fitting->fit_telescope_background.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_TELESCOPE_BACK, fitting->fit_telescope_background.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELESCOPE_BACK_CONST);
    if (p) {
        fitting->fit_telescope_background.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_BACK_CONST,
            fitting->fit_telescope_background.const_val
        );
    }


    /* Telelescope backgroud */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FIT_TELESCOPE_BACK);
    if (p) {
        fitting->fit_telescope_background.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_TELESCOPE_BACK, fitting->fit_telescope_background.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELESCOPE_BACK_CONST);
    if (p) {
        fitting->fit_telescope_background.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_BACK_CONST,
            fitting->fit_telescope_background.const_val
        );
    }


    /* Continuum */
    p = cpl_parameterlist_find_const(list, "FIT_CONTINUUM_OLD");
    if (p) {
        fitting->fit_continuum.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_CONTINUUM, fitting->fit_continuum.fit
        );
    }

    p = cpl_parameterlist_find_const(list, "CONTINUUM_N_OLD");
    if (p) {
        fitting->fit_continuum.n = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CONTINUUM_N, (int)fitting->fit_continuum.n
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_CONTINUUM_CONST);
    if (p) {
        fitting->fit_continuum.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_CONTINUUM_CONST, fitting->fit_continuum.const_val
        );
    }

    /*p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OBSERVATORY_BARY_RV);
  if (p) {
      fitting->obs_bary_rv = cpl_parameter_get_double(p);
      cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_OBSERVATORY_BARY_RV, fitting->obs_bary_rv);
  }
  */


    /* Wavelength solution fit/adjustment */
    p = cpl_parameterlist_find_const(list, "FIT_WLC_OLD");
    if (p) {
        fitting->fit_wavelenght.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_WLC, fitting->fit_wavelenght.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_WLC_N);
    if (p) {
        fitting->fit_wavelenght.n = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLC_N, fitting->fit_wavelenght.n
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_WLC_CONST);
    if (p) {
        fitting->fit_wavelenght.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_WLC_CONST, fitting->fit_wavelenght.const_val
        );
    }

    /* p = cpl_parameterlist_find_const(list, MF_PARAMETERS_WLC_REF);
  if (p) {
      if (fitting->wlc_ref) cpl_free(fitting->wlc_ref);
      fitting->wlc_ref = cpl_strdup(cpl_parameter_get_string(p));
      cpl_propertylist_update_string(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_PARAMETERS_WLC_REF, fitting->wlc_ref);
  }*/


    /* Default kernel: Boxcar kernel */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FIT_RES_BOX);
    if (p) {
        fitting->fit_res_box.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_RES_BOX, fitting->fit_res_box.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_RES_BOX);
    if (p) {
        fitting->fit_res_box.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_BOX, fitting->fit_res_box.const_val
        );
    }


    /* Default kernel: Gaussian kernel */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FIT_GAUSS);
    if (p) {
        fitting->fit_gauss.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_GAUSS, fitting->fit_gauss.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_RES_GAUSS);
    if (p) {
        fitting->fit_gauss.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_GAUSS, fitting->fit_gauss.const_val
        );
    }


    /* Default kernel: Lorentz kernel */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_FIT_LORENTZ);
    if (p) {
        fitting->fit_lorentz.fit = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_FIT_LORENTZ, fitting->fit_lorentz.fit
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_RES_LORENTZ);
    if (p) {
        fitting->fit_lorentz.const_val = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RES_LORENTZ, fitting->fit_lorentz.const_val
        );
    }


    /* Default kernels: Generic parameters */
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_KERN_MODE);
    if (p) {
        fitting->kern_mode = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_KERN_MODE, fitting->kern_mode);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_KERN_FAC);
    if (p) {
        fitting->kern_fac = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_KERN_FAC, fitting->kern_fac);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_VAR_KERN);
    if (p) {
        fitting->var_kern = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_VAR_KERN, fitting->var_kern);
    }


    /*** Ambient ***/
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OBSERVING_DATE_KEYWORD);
    if (p) {
        if (ambient->observing_date.key) {
            cpl_free(ambient->observing_date.key);
        }
        ambient->observing_date.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVING_DATE_KEYWORD, ambient->observing_date.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_OBSERVING_DATE_VALUE);
    if (p) {
        ambient->observing_date.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_OBSERVING_DATE_VALUE, ambient->observing_date.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_UTC_KEYWORD);
    if (p) {
        if (ambient->utc.key) {
            cpl_free(ambient->utc.key);
        }
        ambient->utc.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_UTC_KEYWORD, ambient->utc.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_UTC_VALUE);
    if (p) {
        ambient->utc.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_UTC_VALUE, ambient->utc.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELESCOPE_ANGLE_KEYWORD);
    if (p) {
        if (ambient->telescope_angle.key) {
            cpl_free(ambient->telescope_angle.key);
        }
        ambient->telescope_angle.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_ANGLE_KEYWORD, ambient->telescope_angle.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TELESCOPE_ANGLE_VALUE);
    if (p) {
        ambient->telescope_angle.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TELESCOPE_ANGLE_VALUE, ambient->telescope_angle.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_RELATIVE_HUMIDITY_KEYWORD);
    if (p) {
        if (ambient->relative_humidity.key) {
            cpl_free(ambient->relative_humidity.key);
        }
        ambient->relative_humidity.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RELATIVE_HUMIDITY_KEYWORD, ambient->relative_humidity.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_RELATIVE_HUMIDITY_VALUE);
    if (p) {
        ambient->relative_humidity.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_RELATIVE_HUMIDITY_VALUE, ambient->relative_humidity.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_PRESSURE_KEYWORD);
    if (p) {
        if (ambient->pressure.key) {
            cpl_free(ambient->pressure.key);
        }
        ambient->pressure.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PRESSURE_KEYWORD, ambient->pressure.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_PRESSURE_VALUE);
    if (p) {
        ambient->pressure.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PRESSURE_VALUE, ambient->pressure.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TEMPERATURE_KEYWORD);
    if (p) {
        if (ambient->temperature.key) {
            cpl_free(ambient->temperature.key);
        }
        ambient->temperature.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TEMPERATURE_KEYWORD, ambient->temperature.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_TEMPERATURE_VALUE);
    if (p) {
        ambient->temperature.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_TEMPERATURE_VALUE, ambient->temperature.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_MIRROR_TEMPERATURE_KEYWORD);
    if (p) {
        if (ambient->mirror_temperature.key) {
            cpl_free(ambient->mirror_temperature.key);
        }
        ambient->mirror_temperature.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_MIRROR_TEMPERATURE_KEYWORD,
            ambient->mirror_temperature.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_MIRROR_TEMPERATURE_VALUE);
    if (p) {
        ambient->mirror_temperature.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_MIRROR_TEMPERATURE_VALUE,
            ambient->mirror_temperature.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_ELEVATION_KEYWORD);
    if (p) {
        if (ambient->elevation.key) {
            cpl_free(ambient->elevation.key);
        }
        ambient->elevation.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_ELEVATION_KEYWORD, ambient->elevation.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_ELEVATION_VALUE);
    if (p) {
        ambient->elevation.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_ELEVATION_VALUE, ambient->elevation.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LONGITUDE_KEYWORD);
    if (p) {
        if (ambient->longitude.key) {
            cpl_free(ambient->longitude.key);
        }
        ambient->longitude.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LONGITUDE_KEYWORD, ambient->longitude.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LONGITUDE_VALUE);
    if (p) {
        ambient->longitude.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LONGITUDE_VALUE, ambient->longitude.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LATITUDE_KEYWORD);
    if (p) {
        if (ambient->latitude.key) {
            cpl_free(ambient->latitude.key);
        }
        ambient->latitude.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_KEYWORD, ambient->latitude.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LATITUDE_VALUE);
    if (p) {
        ambient->latitude.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_VALUE, ambient->latitude.value
        );
    }


    /*** Instrumental ***/
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_SLIT_WIDTH_KEYWORD);
    if (p) {
        if (instrumental->slit_width.key) {
            cpl_free(instrumental->slit_width.key);
        }
        instrumental->slit_width.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SLIT_WIDTH_KEYWORD, instrumental->slit_width.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_SLIT_WIDTH_VALUE);
    if (p) {
        instrumental->slit_width.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_SLIT_WIDTH_VALUE, instrumental->slit_width.value
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_PIXEL_SCALE_KEYWORD);
    if (p) {
        if (instrumental->pixel_scale.key) {
            cpl_free(instrumental->pixel_scale.key);
        }
        instrumental->pixel_scale.key = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PIXEL_SCALE_KEYWORD, instrumental->pixel_scale.key
        );
    }
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_PIXEL_SCALE_VALUE);
    if (p) {
        instrumental->pixel_scale.value = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PIXEL_SCALE_VALUE, instrumental->pixel_scale.value
        );
    }


    /*** Atmospheric ***/
    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_REFERENCE_ATMOSPHERIC);
    if (p) {
        if (atmospheric->ref_atm) {
            cpl_free(atmospheric->ref_atm);
        }
        atmospheric->ref_atm = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_REFERENCE_ATMOSPHERIC, atmospheric->ref_atm
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_GDAS_PROFILE);
    if (p) {
        if (atmospheric->gdas_prof) {
            cpl_free(atmospheric->gdas_prof);
        }
        atmospheric->gdas_prof = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_GDAS_PROFILE, atmospheric->gdas_prof
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LAYERS);
    if (p) {
        atmospheric->layers = cpl_parameter_get_bool(p);
        cpl_propertylist_update_bool(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LAYERS, atmospheric->layers);
    }


    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_EMIX);
    if (p) {
        atmospheric->emix = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_EMIX, atmospheric->emix);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_PWV);
    if (p) {
        atmospheric->pwv = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_PWV, atmospheric->pwv);
    }


    /*** LNFL ***/
    mf_io_lnfl_config *lnfl = mf_config->lnfl;

    p = cpl_parameterlist_find_const(list, MF_LNFL_LINE_DB);
    if (p) {
        if (lnfl->line_db) {
            cpl_free(lnfl->line_db);
        }
        lnfl->line_db = cpl_strdup(cpl_parameter_get_string(p));
        cpl_propertylist_update_string(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LNFL_LINE_DB, lnfl->line_db);
    }

    p = cpl_parameterlist_find_const(list, MF_LNFL_LINE_DB_FMT);
    if (p) {
        lnfl->line_db_fmt = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LNFL_LINE_DB_FMT, lnfl->line_db_fmt);
    }


    /*** LBLRTM ***/
    mf_io_lblrtm_config *lblrtm = mf_config->lblrtm;

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_ICNTNM);
    if (p) {
        lblrtm->icntnm = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ICNTNM, lblrtm->icntnm);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_IAERSL);
    if (p) {
        lblrtm->iaersl = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_IAERSL, lblrtm->iaersl);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_MPTS);
    if (p) {
        lblrtm->mpts = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_MPTS, lblrtm->mpts);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_NPTS);
    if (p) {
        lblrtm->npts = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NPTS, lblrtm->npts);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_V1);
    if (p) {
        lblrtm->v[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_V1, lblrtm->v[0]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_V2);
    if (p) {
        lblrtm->v[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_V2, lblrtm->v[1]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SAMPLE);
    if (p) {
        lblrtm->sample = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SAMPLE, lblrtm->sample);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_ALFAL0);
    if (p) {
        lblrtm->alfal0 = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALFAL0, lblrtm->alfal0);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_AVMASS);
    if (p) {
        lblrtm->avmass = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_AVMASS, lblrtm->avmass);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_DPTMIN);
    if (p) {
        lblrtm->dptmin = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DPTMIN, lblrtm->dptmin);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_DPTFAC);
    if (p) {
        lblrtm->dptfac = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DPTFAC, lblrtm->dptfac);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_TBOUND);
    if (p) {
        lblrtm->tbound = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TBOUND, lblrtm->tbound);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SREMIS1);
    if (p) {
        lblrtm->sremis[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS1, lblrtm->sremis[0]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SREMIS2);
    if (p) {
        lblrtm->sremis[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS2, lblrtm->sremis[1]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SREMIS3);
    if (p) {
        lblrtm->sremis[2] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SREMIS3, lblrtm->sremis[2]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SRREFL1);
    if (p) {
        lblrtm->srrefl[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL1, lblrtm->srrefl[0]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SRREFL2);
    if (p) {
        lblrtm->srrefl[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL2, lblrtm->srrefl[1]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_SRREFL3);
    if (p) {
        lblrtm->srrefl[2] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_SRREFL3, lblrtm->srrefl[2]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_MODEL);
    if (p) {
        lblrtm->model = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_MODEL, lblrtm->model);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_ITYPE);
    if (p) {
        lblrtm->itype = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ITYPE, lblrtm->itype);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_NOZERO);
    if (p) {
        lblrtm->nozero = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NOZERO, lblrtm->nozero);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_NOPRNT);
    if (p) {
        lblrtm->noprnt = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_NOPRNT, lblrtm->noprnt);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_IPUNCH);
    if (p) {
        lblrtm->ipunch = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_IPUNCH, lblrtm->ipunch);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_RE);
    if (p) {
        lblrtm->re = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_RE, lblrtm->re);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_HSPACE);
    if (p) {
        lblrtm->hspace = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_HSPACE, lblrtm->hspace);
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_LATITUDE_VALUE);
    if (p) {
        lblrtm->ref_lat = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(
            pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_PARAMETERS_LATITUDE_VALUE, lblrtm->ref_lat
        );
    }

    p = cpl_parameterlist_find_const(list, MF_PARAMETERS_ELEVATION_VALUE);
    if (p) {
        lblrtm->h[0] = cpl_parameter_get_double(p) / 1000.0;
        /*cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT" "MF_LBLRTM_H1, lblrtm->h[0]);*/
    }


    p = cpl_parameterlist_find_const(list, MF_LBLRTM_H2);
    if (p) {
        lblrtm->h[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_H2, lblrtm->h[1]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_RANGE);
    if (p) {
        lblrtm->range = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_RANGE, lblrtm->range);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_BETA);
    if (p) {
        lblrtm->beta = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_BETA, lblrtm->beta);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_LEN);
    if (p) {
        lblrtm->len = cpl_parameter_get_int(p);
        cpl_propertylist_update_int(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_LEN, lblrtm->len);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_HOBS);
    if (p) {
        lblrtm->hobs = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_HOBS, lblrtm->hobs);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_AVTRAT);
    if (p) {
        lblrtm->avtrat = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_AVTRAT, lblrtm->avtrat);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_TDIFF1);
    if (p) {
        lblrtm->tdiff[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TDIFF1, lblrtm->tdiff[0]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_TDIFF2);
    if (p) {
        lblrtm->tdiff[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_TDIFF2, lblrtm->tdiff[1]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_ALTD1);
    if (p) {
        lblrtm->altd[0] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALTD1, lblrtm->altd[0]);
    }
    p = cpl_parameterlist_find_const(list, MF_LBLRTM_ALTD2);
    if (p) {
        lblrtm->altd[1] = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_ALTD2, lblrtm->altd[1]);
    }

    p = cpl_parameterlist_find_const(list, MF_LBLRTM_DELV);
    if (p) {
        lblrtm->delv = cpl_parameter_get_double(p);
        cpl_propertylist_update_double(pl, MF_PARAMETERS_CONTEX_DEFAULT " " MF_LBLRTM_DELV, lblrtm->delv);
    }


    /*** Update the Molecfit configuration with the header ***/
    cpl_error_code e = mf_parameters_config_update_with_header_keywords(mf_config->parameters, data_primary_header);


    /* Check possible errors */
    if (!cpl_errorstate_is_equal(pre_state) || e != CPL_ERROR_NONE) {
        mf_configuration_delete(mf_config);
        cpl_error_set_message(cpl_func, CPL_ERROR_ILLEGAL_OUTPUT, "Error loading Molecfit default configuration");
        return NULL;
    }

    return mf_config;
}


/*----------------------------------------------------------------------------*/
/**
 * @brief    Deallocate the given parameter configuration object and its contents
 *
 * @param    parameters       The parameter configuration variable in the recipe.
 */
/*----------------------------------------------------------------------------*/
void mf_wrap_model_parameter_delete(mf_wrap_model_parameter *parameters)
{
    if (parameters) {
        if (parameters->molecules_table) {
            cpl_table_delete(parameters->molecules_table);
        }

        if (parameters->wave_ranges_include_table) {
            cpl_table_delete(parameters->wave_ranges_include_table);
        }

        if (parameters->wave_ranges_exclude_table) {
            cpl_table_delete(parameters->wave_ranges_exclude_table);
        }

        if (parameters->pixel_ranges_exclude_table) {
            cpl_table_delete(parameters->pixel_ranges_exclude_table);
        }

        if (parameters->mapping_kernel_table) {
            cpl_table_delete(parameters->mapping_kernel_table);
        }

        if (parameters->mf_config) {
            mf_configuration_delete(parameters->mf_config);
        }

        if (parameters->pl) {
            cpl_propertylist_delete(parameters->pl);
        }

        cpl_free(parameters);
    }
}
