/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_UTILS_H
#define MF_WRAP_UTILS_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include "mf_constants.h"
#include "mf_configuration.h"
//#include "mf_wrap_dfs.h"
#include "mf_wrap_data.h"
//#include "mf_wrap_fits.h"


#include <sys/stat.h>
#include <math.h>

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* ------------------------ START: Common  Functions ------------------------ */

/* Check inputs in the recipe */
cpl_error_code mf_wrap_check_and_set_groups(cpl_frameset *frameset);

/* Load kernel tag */
mf_wrap_fits *mf_wrap_load_kernel_tag(
    cpl_frameset         *frameset,
    const char           *tag_kernel,
    cpl_boolean           use_input_kernel,
    mf_parameters_config *parameters,
    cpl_boolean           verbose
);

/* Convert input data to internal spectrum */
cpl_error_code mf_wrap_data_convert_to_table(
    mf_wrap_fits *data,
    cpl_boolean   chip_extensions,
    cpl_boolean   use_only_pri_ext,
    int           dflux_extension_data,
    int           mask_extension_data,
    const char   *column_lambda,
    const char   *column_flux,
    const char   *column_dflux,
    const char   *column_mask
);

/* Load ranges in a input FITS BINTABLE with one only extension */
cpl_table *mf_wrap_load_unique_table(const cpl_frameset *frameset, const char *tag);

/* Load table in a input FITS BINTABLE of the extension 'ext' */
cpl_table *mf_wrap_load_table(const cpl_frame *frame, const cpl_size ext);

/* Save to disk a new *.fits output file */
cpl_error_code mf_wrap_save(
    cpl_frameset            *all_frameset,
    cpl_frameset            *used_frameset,
    const cpl_parameterlist *parlist,
    const char              *recipe,
    cpl_propertylist        *list,
    const char              *tag,
    const char              *filename
);

/* Save to disk a cpl_table output for one molecfit execution */
cpl_error_code mf_wrap_save_mf_results(
    cpl_propertylist *header_data,
    const char       *name,
    cpl_boolean       addFitsExtension,
    cpl_matrix       *matrix,
    cpl_table        *table,
    cpl_vector       *vec
);

const char *mf_wrap_tag_suffix(const char *tag, const char *suffix, cpl_boolean fits);


/* ------------------------ END: Common  Functions ------------------------ */

/* ------------------------ START: DFS  Functions ------------------------ */


/* ------------------------- END: DFS  Functions ------------------------- */


#endif /* MF_WRAP_UTILS_H */
