/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2025 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * All download functionality should be replaced with libcurl. This test
 * can then be removed, as it is better to have tests that can run
 * fully offline.
 */

#include "mf_io.h"
#include "cpl.h"

int main(void)
{
    /* mf_io_curl should be refactored long before ftp.gnu.org is removed. */
    cpl_init(CPL_INIT_DEFAULT);
    mf_io_curl("ftp.gnu.org", "/welcome.msg", ".message");
    mf_io_curl(
        "eso-ftp02.hq.eso.org", "/pub/dfs/pipelines/skytools/molecfit/gdas/gdas_profiles_C-70.4-24.6.tar.gz",
        "gdas_profiles_C-70.4-24.6.tar.gz"
    );
}
