# MOONS_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([MOONS_SET_VERSION_INFO],
[
    moons_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    moons_major_version=`echo "$moons_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    moons_minor_version=`echo "$moons_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    moons_micro_version=`echo "$moons_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$moons_major_version"; then moons_major_version=0
    fi

    if test -z "$moons_minor_version"; then moons_minor_version=0
    fi

    if test -z "$moons_micro_version"; then moons_micro_version=0
    fi

    MOONS_VERSION="$moons_version"
    MOONS_MAJOR_VERSION=$moons_major_version
    MOONS_MINOR_VERSION=$moons_minor_version
    MOONS_MICRO_VERSION=$moons_micro_version

    if test -z "$4"; then MOONS_INTERFACE_AGE=0
    else MOONS_INTERFACE_AGE="$4"
    fi

    MOONS_BINARY_AGE=`expr 100 '*' $MOONS_MINOR_VERSION + $MOONS_MICRO_VERSION`
    MOONS_BINARY_VERSION=`expr 10000 '*' $MOONS_MAJOR_VERSION + \
                          $MOONS_BINARY_AGE`

    AC_SUBST(MOONS_VERSION)
    AC_SUBST(MOONS_MAJOR_VERSION)
    AC_SUBST(MOONS_MINOR_VERSION)
    AC_SUBST(MOONS_MICRO_VERSION)
    AC_SUBST(MOONS_INTERFACE_AGE)
    AC_SUBST(MOONS_BINARY_VERSION)
    AC_SUBST(MOONS_BINARY_AGE)

    AC_DEFINE_UNQUOTED(MOONS_MAJOR_VERSION, $MOONS_MAJOR_VERSION,
                       [MOONS major version number])
    AC_DEFINE_UNQUOTED(MOONS_MINOR_VERSION, $MOONS_MINOR_VERSION,
                       [MOONS minor version number])
    AC_DEFINE_UNQUOTED(MOONS_MICRO_VERSION, $MOONS_MICRO_VERSION,
                       [MOONS micro version number])
    AC_DEFINE_UNQUOTED(MOONS_INTERFACE_AGE, $MOONS_INTERFACE_AGE,
                       [MOONS interface age])
    AC_DEFINE_UNQUOTED(MOONS_BINARY_VERSION, $MOONS_BINARY_VERSION,
                       [MOONS binary version number])
    AC_DEFINE_UNQUOTED(MOONS_BINARY_AGE, $MOONS_BINARY_AGE,
                       [MOONS binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# MOONS_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([MOONS_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi
    AC_SUBST(plugindir)

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi
    AC_SUBST(configdir)

    if test -z "$pipelinelibdir"; then
        pipelinelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi
    AC_SUBST(pipelinelibdir)

    if test -z "$pipelinedocdir"; then
        pipelinedocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi
    AC_SUBST(pipelinedocdir)

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi
    AC_SUBST(workflowdir)

    if test -z "$reportsdir"; then
       reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi
    AC_SUBST(reportsdir)

    if test -z "$apidocdir"; then
        apidocdir='${pipelinedocdir}/html'
    fi
    AC_SUBST(apidocdir)

])


# MOONS_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([MOONS_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    MOONS_INCLUDES='-I$(top_srcdir)/moons -I$(top_builddir)/moons -I$(top_srcdir)/skycorr -I$(top_srcdir)/irplib -I$(top_srcdir)/hdrl'
    MOONS_LDFLAGS='-L$(top_builddir)/moons'

    # Library aliases
    
    LIBMOONS='$(top_builddir)/moons/libmoons.la'
    LIBIRPLIB='$(top_builddir)/irplib/libirplib.la'
    LIBHDRL='$(top_builddir)/hdrl/libhdrl.la'
    LIBSKYCORR='$(top_builddir)/skycorr/libskycorr.la'

    # Substitute the defined symbols

    AC_SUBST(MOONS_INCLUDES)
    AC_SUBST(MOONS_LDFLAGS)

    AC_SUBST(LIBSKYCORR)
    AC_SUBST(LIBIRPLIB)
    AC_SUBST(LIBMOONS)
  

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(MOONS_INCLUDES) $(CPL_INCLUDES) $(HDRL_INCLUDES) $(EXTRA_INCLUDES) $(XXCLIPM_INCLUDES)'
    all_ldflags='$(MOONS_LDFLAGS) $(CPL_LDFLAGS) $(HDRL_LDFLAGS) $(IRPLIB_LDFLAGS) $(EXTRA_LDFLAGS) $(XXCLIPM_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])


#
# ESO_ENABLE_OPENMP(openmp=no)
#-----------------------------
AC_DEFUN([ESO_ENABLE_OPENMP],
[
    AC_REQUIRE([AC_PROG_CC])

    AC_ARG_ENABLE(openmp,
                  AS_HELP_STRING([--enable-openmp],
                                 [compiles with openmp compiler options (may not work!) [[default=$1]]]),
                  eso_enable_openmp=$enableval, eso_enable_openmp=$1)

    AC_CACHE_CHECK([whether openmp compiler options should be used],
                   eso_cv_enable_openmp,
                   eso_cv_enable_openmp=$eso_enable_openmp)


    if test x"$eso_cv_enable_openmp" = xyes; then
        ESO_PROG_CC_FLAG([fopenmp], [CFLAGS="$CFLAGS -fopenmp"
                                     LDFLAGS="$LDFLAGS -fopenmp"])
        ESO_PROG_CC_FLAG([xopenmp], [CFLAGS="$CFLAGS -xopenmp"
                                     LDFLAGS="$LDFLAGS -xopenmp"])
    fi
])


# MOONS_WITH_TESTDATA
#--------------------
# Setup the location where the MOONS unit test data can be found.
AC_DEFUN([MOONS_WITH_TESTDATA],
[
    AC_ARG_VAR([MOONS_TESTDATA], [MOONS test data location])
    
    AC_ARG_WITH(testdata,
                AS_HELP_STRING([--with-testdata],
                               [location of the MOONS test data files]),
                [moons_with_testdata=$with_testdata],
                [moons_with_testdata="$MOONS_TESTDATA"])

    AC_CACHE_VAL([moons_cv_with_testdata],
                 [moons_cv_with_testdata=$moons_with_testdata])

    if test -n "$moons_cv_with_testdata"; then
        testdatadir="$moons_cv_with_testdata"
    else
        testdatadir='$(top_srcdir)/testdata'
    fi

    AC_SUBST(testdatadir)
])
