/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_ATM_H
#define MOO_ATM_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>

/**
 * @ingroup moo_atm
 *
 * @brief ATM format
 */
#define MOO_ATM_EXTNAME    "EXTINCTION TABLE"
#define MOO_ATM_WAVE       "WAVE"
#define MOO_ATM_EXTINCTION "EXTINCTION"
#define MOO_ATM_FLUX       "FLUX"

#define MOO_DEBUG_ATM 0
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_table *table;
} moo_atm;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_atm *moo_atm_new(void);
moo_atm *moo_atm_load(const cpl_frame *frame);
cpl_table *moo_atm_convert_mag_to_flux(moo_atm *self, double airm);
void moo_atm_delete(moo_atm *self);
#endif
