/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_BPM_H
#define MOO_BPM_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    cpl_propertylist *data_header[6];
    cpl_image *data[6];
} moo_bpm;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_bpm *moo_bpm_new(void);
cpl_error_code moo_bpm_set_data(moo_bpm *self,
                                moo_detector_type type,
                                int ntas,
                                cpl_image *data,
                                cpl_propertylist *header);
cpl_error_code moo_bpm_add_data(moo_bpm *self,
                                cpl_image *data,
                                moo_detector_type type,
                                int ntas);
cpl_error_code moo_bpm_merge(moo_bpm *a, moo_bpm *b);
void moo_bpm_save(moo_bpm *self, const char *filename);
void moo_bpm_delete(moo_bpm *self);
#endif
